/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointReadOnly;
import us.ihmc.mecano.tools.MecanoTools;

public interface SphericalJointBasics
extends SphericalJointReadOnly,
JointBasics {
    public QuaternionBasics getJointOrientation();

    public FixedFrameVector3DBasics getJointAngularVelocity();

    public FixedFrameVector3DBasics getJointAngularAcceleration();

    public FixedFrameVector3DBasics getJointTorque();

    @Override
    default public void setJointConfigurationToZero() {
        this.getJointOrientation().setToZero();
    }

    @Override
    default public void setJointTwistToZero() {
        this.getJointAngularVelocity().setToZero();
    }

    @Override
    default public void setJointAccelerationToZero() {
        this.getJointAngularAcceleration().setToZero();
    }

    @Override
    default public void setJointTauToZero() {
        this.getJointTorque().setToZero();
    }

    @Override
    default public void setJointConfiguration(JointReadOnly other) {
        this.setJointConfiguration(MecanoTools.checkTypeAndCast(other, SphericalJointReadOnly.class));
    }

    default public void setJointConfiguration(SphericalJointReadOnly other) {
        this.getJointOrientation().set(other.getJointOrientation());
    }

    @Override
    default public void setJointTwist(JointReadOnly other) {
        this.setJointTwist(MecanoTools.checkTypeAndCast(other, SphericalJointReadOnly.class));
    }

    default public void setJointTwist(SphericalJointReadOnly other) {
        FrameVector3DReadOnly otherAngularVelocity = other.getJointAngularVelocity();
        this.setJointAngularVelocity((Vector3DReadOnly)otherAngularVelocity);
    }

    @Override
    default public void setJointAcceleration(JointReadOnly other) {
        this.setJointAcceleration(MecanoTools.checkTypeAndCast(other, SphericalJointReadOnly.class));
    }

    default public void setJointAcceleration(SphericalJointReadOnly other) {
        FrameVector3DReadOnly otherAngularAcceleration = other.getJointAngularAcceleration();
        this.setJointAngularAcceleration((Vector3DReadOnly)otherAngularAcceleration);
    }

    @Override
    default public void setJointWrench(JointReadOnly other) {
        this.setJointWrench(MecanoTools.checkTypeAndCast(other, SphericalJointReadOnly.class));
    }

    default public void setJointWrench(SphericalJointReadOnly other) {
        FrameVector3DReadOnly otherTorque = other.getJointTorque();
        this.setJointTorque((Vector3DReadOnly)otherTorque);
    }

    @Override
    default public int setJointConfiguration(int rowStart, DMatrix matrix) {
        this.getJointOrientation().set(rowStart, matrix);
        return rowStart + this.getConfigurationMatrixSize();
    }

    @Override
    default public int setJointVelocity(int rowStart, DMatrix matrix) {
        this.getJointAngularVelocity().set(rowStart, matrix);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int setJointAcceleration(int rowStart, DMatrix matrix) {
        this.getJointAngularAcceleration().set(rowStart, matrix);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public int setJointTau(int rowStart, DMatrix matrix) {
        this.getJointTorque().set(rowStart, matrix);
        return rowStart + this.getDegreesOfFreedom();
    }

    @Override
    default public void setJointOrientation(Orientation3DReadOnly jointOrientation) {
        this.getJointOrientation().set(jointOrientation);
    }

    @Override
    default public void setJointPosition(Tuple3DReadOnly jointPosition) {
    }

    @Override
    default public void setJointAngularVelocity(Vector3DReadOnly jointAngularVelocity) {
        this.getJointAngularVelocity().set((Tuple3DReadOnly)jointAngularVelocity);
    }

    @Override
    default public void setJointLinearVelocity(Vector3DReadOnly jointLinearVelocity) {
    }

    @Override
    default public void setJointAngularAcceleration(Vector3DReadOnly jointAngularAcceleration) {
        this.getJointAngularAcceleration().set((Tuple3DReadOnly)jointAngularAcceleration);
    }

    @Override
    default public void setJointLinearAcceleration(Vector3DReadOnly jointLinearAcceleration) {
    }

    @Override
    default public void setJointTorque(Vector3DReadOnly jointTorque) {
        this.getJointTorque().set((Tuple3DReadOnly)jointTorque);
    }

    @Override
    default public void setJointForce(Vector3DReadOnly jointForce) {
    }
}

