/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem.interfaces;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.JointIterable;
import us.ihmc.mecano.multiBodySystem.iterators.RigidBodyIterable;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;

public interface RigidBodyReadOnly {
    public static final String NAME_ID_SEPARATOR = ":";

    public SpatialInertiaReadOnly getInertia();

    public MovingReferenceFrame getBodyFixedFrame();

    public JointReadOnly getParentJoint();

    default public List<? extends JointReadOnly> getParentLoopClosureJoints() {
        return Collections.emptyList();
    }

    public List<? extends JointReadOnly> getChildrenJoints();

    default public boolean hasChildrenJoints() {
        return !this.getChildrenJoints().isEmpty();
    }

    default public boolean isRootBody() {
        return this.getParentJoint() == null;
    }

    public String getName();

    default public void getCenterOfMass(FramePoint3DBasics centerOfMassToPack) {
        centerOfMassToPack.setIncludingFrame((FrameTuple3DReadOnly)this.getInertia().getCenterOfMassOffset());
    }

    default public Iterable<? extends RigidBodyReadOnly> subtreeIterable() {
        return new RigidBodyIterable<RigidBodyReadOnly>(RigidBodyReadOnly.class, null, this);
    }

    default public Iterable<? extends JointReadOnly> childrenSubtreeIterable() {
        return new JointIterable<JointReadOnly>(JointReadOnly.class, null, this.getChildrenJoints());
    }

    default public Stream<? extends RigidBodyReadOnly> subtreeStream() {
        return SubtreeStreams.from(this);
    }

    default public List<? extends RigidBodyReadOnly> subtreeList() {
        return this.subtreeStream().collect(Collectors.toList());
    }

    default public RigidBodyReadOnly[] subtreeArray() {
        return (RigidBodyReadOnly[])this.subtreeStream().toArray(RigidBodyReadOnly[]::new);
    }

    public String getNameId();
}

