/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem;

import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MecanoTools;

public class PlanarJoint
extends Joint
implements PlanarJointBasics {
    private final Pose3DBasics jointPose = MecanoFactories.newPlanarPose3DBasics();
    private final FixedFrameTwistBasics jointTwist = MecanoFactories.newPlanarFixedFrameTwistBasics(this.afterJointFrame, this.beforeJointFrame, this.afterJointFrame);
    private final FixedFrameSpatialAccelerationBasics jointAcceleration = MecanoFactories.newPlanarFixedFrameSpatialAccelerationVectorBasics(this.afterJointFrame, this.beforeJointFrame, this.afterJointFrame);
    private FixedFrameWrenchBasics jointWrench;
    private final List<TwistReadOnly> unitTwists = MecanoTools.computePlanarJointMotionSubspace(this.beforeJointFrame, this.afterJointFrame);

    public PlanarJoint(String name, RigidBodyBasics predecessor) {
        this(name, predecessor, null);
    }

    public PlanarJoint(String name, RigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
        super(name, predecessor, transformToParent);
    }

    @Override
    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        MovingReferenceFrame successorFrame = successor.getBodyFixedFrame();
        this.jointWrench = MecanoFactories.newPlanarFixedFrameWrenchBasics(successorFrame, this.afterJointFrame);
    }

    @Override
    public Pose3DBasics getJointPose() {
        return this.jointPose;
    }

    @Override
    public FixedFrameTwistBasics getJointTwist() {
        return this.jointTwist;
    }

    @Override
    public FixedFrameSpatialAccelerationBasics getJointAcceleration() {
        return this.jointAcceleration;
    }

    @Override
    public FixedFrameWrenchBasics getJointWrench() {
        return this.jointWrench;
    }

    @Override
    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }
}

