/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.frames;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.exceptions.ScrewTheoryException;
import us.ihmc.mecano.frames.FixedMovingReferenceFrame;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public abstract class MovingReferenceFrame
extends ReferenceFrame {
    private boolean isTwistOfFrameUpToDate = false;
    private final Twist twistRelativeToParent;
    private final Twist twistOfFrame = new Twist();
    private final MovingReferenceFrame closestAncestorMovingFrame;
    private final List<MovingReferenceFrame> descendantsMovingFrames = new ArrayList<MovingReferenceFrame>();

    public static MovingReferenceFrame constructFrameFixedInParent(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent) {
        return new FixedMovingReferenceFrame(frameName, parentFrame, transformToParent);
    }

    public MovingReferenceFrame(String frameName, ReferenceFrame parentFrame) {
        this(frameName, parentFrame, null, false, false);
    }

    public MovingReferenceFrame(String frameName, ReferenceFrame parentFrame, boolean isZUpFrame) {
        this(frameName, parentFrame, (RigidBodyTransformReadOnly)new RigidBodyTransform(), isZUpFrame, false);
    }

    public MovingReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent) {
        this(frameName, parentFrame, transformToParent, false, false);
    }

    public MovingReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent, boolean isZUpFrame) {
        this(frameName, parentFrame, transformToParent, isZUpFrame, false);
    }

    protected MovingReferenceFrame(String frameName, ReferenceFrame parentFrame, RigidBodyTransformReadOnly transformToParent, boolean isZUpFrame, boolean isFixedInParent) {
        super(frameName, parentFrame, transformToParent, parentFrame.isAStationaryFrame() && isFixedInParent, isZUpFrame, isFixedInParent);
        this.closestAncestorMovingFrame = MovingReferenceFrame.findClosestAncestorMovingFrame(parentFrame);
        if (this.closestAncestorMovingFrame != null) {
            this.closestAncestorMovingFrame.descendantsMovingFrames.add(this);
        }
        if (!MovingReferenceFrame.isAncestorValid(parentFrame)) {
            throw MovingReferenceFrame.unhandledReferenceFrameTypeException(parentFrame);
        }
        this.twistRelativeToParent = isFixedInParent ? null : new Twist((ReferenceFrame)this, parentFrame, this);
    }

    private static MovingReferenceFrame findClosestAncestorMovingFrame(ReferenceFrame frame) {
        if (frame == null) {
            return null;
        }
        if (frame instanceof MovingReferenceFrame) {
            return (MovingReferenceFrame)frame;
        }
        return MovingReferenceFrame.findClosestAncestorMovingFrame(frame.getParent());
    }

    private static boolean isAncestorValid(ReferenceFrame frame) {
        if (frame instanceof MovingReferenceFrame) {
            return true;
        }
        if (frame.isAStationaryFrame()) {
            return true;
        }
        if (frame.isRootFrame()) {
            return true;
        }
        if (frame.isFixedInParent()) {
            return MovingReferenceFrame.isAncestorValid(frame.getParent());
        }
        return false;
    }

    public void update() {
        super.update();
        if (!this.isFixedInParent()) {
            this.updateTwistRelativeToParent(this.twistRelativeToParent);
            this.twistRelativeToParent.checkReferenceFrameMatch(this, this.getParent(), this);
        }
        this.isTwistOfFrameUpToDate = false;
    }

    protected abstract void updateTwistRelativeToParent(Twist var1);

    private void updateTwistOfFrame() {
        if (this.isTwistOfFrameUpToDateRecursive()) {
            return;
        }
        if (this.closestAncestorMovingFrame == null) {
            if (this.isFixedInParent()) {
                this.twistOfFrame.setToZero(this, this.getParent(), this);
            } else {
                this.twistOfFrame.setIncludingFrame(this.twistRelativeToParent);
            }
        } else {
            this.twistOfFrame.setIncludingFrame(this.closestAncestorMovingFrame.getTwistOfFrame());
            this.twistOfFrame.changeFrame(this);
            if (this.isFixedInParent()) {
                this.twistOfFrame.setBodyFrame(this);
            } else {
                this.twistOfFrame.setBodyFrame(this.getParent());
                this.twistOfFrame.add(this.twistRelativeToParent);
            }
        }
        this.isTwistOfFrameUpToDate = true;
        for (int i = 0; i < this.descendantsMovingFrames.size(); ++i) {
            this.descendantsMovingFrames.get((int)i).isTwistOfFrameUpToDate = false;
        }
    }

    private boolean isTwistOfFrameUpToDateRecursive() {
        return this.isTwistOfFrameUpToDate && (this.closestAncestorMovingFrame == null || this.closestAncestorMovingFrame.isTwistOfFrameUpToDateRecursive());
    }

    public TwistReadOnly getTwistRelativeToParent() {
        return this.twistRelativeToParent;
    }

    public TwistReadOnly getTwistOfFrame() {
        this.updateTwistOfFrame();
        return this.twistOfFrame;
    }

    public void getTwistOfFrame(TwistBasics twistToPack) {
        twistToPack.setIncludingFrame(this.getTwistOfFrame());
    }

    public void getTwistRelativeToOther(ReferenceFrame base, TwistBasics relativeTwistToPack) {
        this.verifySameRoots(base);
        if (base.isAStationaryFrame()) {
            this.getTwistOfFrame(relativeTwistToPack);
            relativeTwistToPack.setBaseFrame(base);
        } else if (base instanceof MovingReferenceFrame) {
            ((MovingReferenceFrame)base).getTwistOfFrame(relativeTwistToPack);
            relativeTwistToPack.changeFrame(this);
            relativeTwistToPack.sub(this.getTwistOfFrame());
            relativeTwistToPack.invert();
        } else {
            throw MovingReferenceFrame.unhandledReferenceFrameTypeException(base);
        }
    }

    public MovingReferenceFrame getMovingParent() {
        return this.closestAncestorMovingFrame;
    }

    private static ScrewTheoryException unhandledReferenceFrameTypeException(ReferenceFrame referenceFrame) {
        return new ScrewTheoryException("The reference frame type: " + referenceFrame.getClass().getSimpleName() + " is currently not handled. Reference frame name: " + referenceFrame.getName());
    }
}

