/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms.interfaces;

import java.util.function.BooleanSupplier;
import java.util.function.Function;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public interface RigidBodyAccelerationProvider {
    public SpatialAccelerationReadOnly getAccelerationOfBody(RigidBodyReadOnly var1);

    public SpatialAccelerationReadOnly getRelativeAcceleration(RigidBodyReadOnly var1, RigidBodyReadOnly var2);

    default public FrameVector3DReadOnly getLinearAccelerationOfBodyFixedPoint(RigidBodyReadOnly body, FramePoint3DReadOnly bodyFixedPoint) {
        return this.getLinearAccelerationOfBodyFixedPoint(null, body, bodyFixedPoint);
    }

    public FrameVector3DReadOnly getLinearAccelerationOfBodyFixedPoint(RigidBodyReadOnly var1, RigidBodyReadOnly var2, FramePoint3DReadOnly var3);

    default public boolean areVelocitiesConsidered() {
        return true;
    }

    default public boolean areAccelerationsConsidered() {
        return true;
    }

    public ReferenceFrame getInertialFrame();

    public static RigidBodyAccelerationProvider toRigidBodyAccelerationProvider(Function<RigidBodyReadOnly, SpatialAccelerationReadOnly> accelerationFunction, ReferenceFrame inertialFrame) {
        return RigidBodyAccelerationProvider.toRigidBodyAccelerationProvider(accelerationFunction, inertialFrame, true, true);
    }

    public static RigidBodyAccelerationProvider toRigidBodyAccelerationProvider(Function<RigidBodyReadOnly, SpatialAccelerationReadOnly> accelerationFunction, ReferenceFrame inertialFrame, boolean considerVelocities, boolean considerAccelerations) {
        return RigidBodyAccelerationProvider.toRigidBodyAccelerationProvider(accelerationFunction, inertialFrame, () -> considerVelocities, () -> considerAccelerations);
    }

    public static RigidBodyAccelerationProvider toRigidBodyAccelerationProvider(final Function<RigidBodyReadOnly, SpatialAccelerationReadOnly> accelerationFunction, final ReferenceFrame inertialFrame, final BooleanSupplier considerVelocities, final BooleanSupplier considerAccelerations) {
        return new RigidBodyAccelerationProvider(){
            private final Twist deltaTwist = new Twist();
            private final SpatialAcceleration baseAcceleration = new SpatialAcceleration();
            private final SpatialAcceleration acceleration = new SpatialAcceleration();
            private final FrameVector3D linearAcceleration = new FrameVector3D();
            private final FramePoint3D localBodyFixedPoint = new FramePoint3D();
            private final Twist twistForLinearAcceleration = new Twist();

            @Override
            public SpatialAccelerationReadOnly getAccelerationOfBody(RigidBodyReadOnly body) {
                return (SpatialAccelerationReadOnly)accelerationFunction.apply(body);
            }

            @Override
            public SpatialAccelerationReadOnly getRelativeAcceleration(RigidBodyReadOnly base, RigidBodyReadOnly body) {
                MovingReferenceFrame baseFrame = base.getBodyFixedFrame();
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                SpatialAccelerationReadOnly immutableBaseAcceleration = this.getAccelerationOfBody(base);
                if (immutableBaseAcceleration == null) {
                    return null;
                }
                this.baseAcceleration.setIncludingFrame(immutableBaseAcceleration);
                SpatialAccelerationReadOnly immutableAcceleration = this.getAccelerationOfBody(body);
                if (immutableAcceleration == null) {
                    return null;
                }
                this.acceleration.setIncludingFrame(immutableAcceleration);
                if (this.areVelocitiesConsidered()) {
                    baseFrame.getTwistRelativeToOther(bodyFrame, this.deltaTwist);
                    this.baseAcceleration.changeFrame(bodyFrame, this.deltaTwist, baseFrame.getTwistOfFrame());
                } else {
                    this.baseAcceleration.changeFrame(bodyFrame);
                }
                this.acceleration.sub(this.baseAcceleration);
                return this.acceleration;
            }

            @Override
            public FrameVector3DReadOnly getLinearAccelerationOfBodyFixedPoint(RigidBodyReadOnly base, RigidBodyReadOnly body, FramePoint3DReadOnly bodyFixedPoint) {
                SpatialAccelerationReadOnly accelerationToUse;
                SpatialAccelerationReadOnly spatialAccelerationReadOnly = accelerationToUse = base != null ? this.getRelativeAcceleration(base, body) : this.getAccelerationOfBody(body);
                if (accelerationToUse == null) {
                    return null;
                }
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                ReferenceFrame baseFrame = accelerationToUse.getBaseFrame();
                this.localBodyFixedPoint.setIncludingFrame((FrameTuple3DReadOnly)bodyFixedPoint);
                this.localBodyFixedPoint.changeFrame((ReferenceFrame)bodyFrame);
                if (this.areVelocitiesConsidered()) {
                    bodyFrame.getTwistRelativeToOther(baseFrame, this.twistForLinearAcceleration);
                } else {
                    this.twistForLinearAcceleration.setToZero(bodyFrame, baseFrame, bodyFrame);
                }
                accelerationToUse.getLinearAccelerationAt((TwistReadOnly)this.twistForLinearAcceleration, (FramePoint3DReadOnly)this.localBodyFixedPoint, (FrameVector3DBasics)this.linearAcceleration);
                this.linearAcceleration.changeFrame(baseFrame);
                return this.linearAcceleration;
            }

            @Override
            public boolean areVelocitiesConsidered() {
                return considerVelocities.getAsBoolean();
            }

            @Override
            public boolean areAccelerationsConsidered() {
                return considerAccelerations.getAsBoolean();
            }

            @Override
            public ReferenceFrame getInertialFrame() {
                return inertialFrame;
            }
        };
    }
}

