/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.multiBodySystem;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.fourBar.CrossFourBarJointIKBinarySolver;
import us.ihmc.mecano.fourBar.CrossFourBarJointIKSolver;
import us.ihmc.mecano.fourBar.FourBarKinematicLoopFunction;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.CrossFourBarJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.CrossFourBarJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MultiBodySystemFactories;

public class CrossFourBarJoint
implements CrossFourBarJointBasics {
    private final String name;
    private final String nameId;
    private final RigidBodyBasics predecessor;
    private RigidBodyBasics successor;
    private final MovingReferenceFrame beforeJointFrame;
    private final MovingReferenceFrame afterJointFrame;
    private final FourBarKinematicLoopFunction fourBarFunction;
    private CrossFourBarJointIKSolver ikSolver;
    private final TwistReadOnly jointTwist;
    private final Twist unitJointTwist = new Twist();
    private final Twist unitSuccessorTwist = new Twist();
    private final Twist unitPredecessorTwist = new Twist();
    private final List<TwistReadOnly> unitTwists;
    private final SpatialAccelerationReadOnly jointAcceleration;
    private final SpatialAcceleration jointBiasAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration successorBiasAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration unitJointAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration unitSuccessorAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration unitPredecessorAcceleration = new SpatialAcceleration();
    private final Wrench unitJointWrench = new Wrench();
    private WrenchReadOnly jointWrench;
    private final Vector3D rotationVector = new Vector3D();
    private double jointLimitLower = Double.NEGATIVE_INFINITY;
    private double jointLimitUpper = Double.POSITIVE_INFINITY;
    private double velocityLimitLower = Double.NEGATIVE_INFINITY;
    private double velocityLimitUpper = Double.POSITIVE_INFINITY;
    private double effortLimitLower = Double.NEGATIVE_INFINITY;
    private double effortLimitUpper = Double.POSITIVE_INFINITY;
    private final Twist deltaTwist = new Twist();
    private final Twist bodyTwist = new Twist();

    public CrossFourBarJoint(String name, RigidBodyBasics predecessor, String jointNameA, String jointNameB, String jointNameC, String jointNameD, String bodyNameDA, String bodyNameBC, RigidBodyTransformReadOnly transformAToPredecessor, RigidBodyTransformReadOnly transformBToPredecessor, RigidBodyTransformReadOnly transformDToA, RigidBodyTransformReadOnly transformCToB, Matrix3DReadOnly bodyInertiaDA, Matrix3DReadOnly bodyInertiaBC, double bodyMassDA, double bodyMassBC, RigidBodyTransformReadOnly bodyInertiaPoseDA, RigidBodyTransformReadOnly bodyInertiaPoseBC, int actuatedJointIndex, int loopClosureJointIndex, Vector3DReadOnly jointAxis) {
        this(name, predecessor, jointNameA, jointNameB, jointNameC, jointNameD, bodyNameDA, bodyNameBC, transformAToPredecessor, transformBToPredecessor, transformDToA, transformCToB, bodyInertiaDA, bodyInertiaBC, bodyMassDA, bodyMassBC, bodyInertiaPoseDA, bodyInertiaPoseBC, MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER, actuatedJointIndex, loopClosureJointIndex, jointAxis);
    }

    public CrossFourBarJoint(String name, RigidBodyBasics predecessor, String jointNameA, String jointNameB, String jointNameC, String jointNameD, String bodyNameDA, String bodyNameBC, RigidBodyTransformReadOnly transformAToPredecessor, RigidBodyTransformReadOnly transformBToPredecessor, RigidBodyTransformReadOnly transformDToA, RigidBodyTransformReadOnly transformCToB, Matrix3DReadOnly bodyInertiaDA, Matrix3DReadOnly bodyInertiaBC, double bodyMassDA, double bodyMassBC, RigidBodyTransformReadOnly bodyInertiaPoseDA, RigidBodyTransformReadOnly bodyInertiaPoseBC, MultiBodySystemFactories.RigidBodyBuilder rigidBodyBuilder, int actuatedJointIndex, int loopClosureJointIndex, Vector3DReadOnly jointAxis) {
        if (actuatedJointIndex == loopClosureJointIndex) {
            throw new IllegalArgumentException("The actuated joint cannot be the loop closure.");
        }
        if (loopClosureJointIndex < 2) {
            throw new UnsupportedOperationException("Only the joint C and D support the loop closure.");
        }
        JointReadOnly.checkJointNameSanity(name);
        jointNameA = CrossFourBarJoint.getInternalName(name, jointNameA, "A");
        jointNameB = CrossFourBarJoint.getInternalName(name, jointNameB, "B");
        jointNameC = CrossFourBarJoint.getInternalName(name, jointNameC, "C");
        jointNameD = CrossFourBarJoint.getInternalName(name, jointNameD, "D");
        bodyNameBC = CrossFourBarJoint.getInternalName(name, bodyNameBC, "BC");
        bodyNameDA = CrossFourBarJoint.getInternalName(name, bodyNameDA, "DA");
        if (bodyInertiaBC == null) {
            bodyInertiaBC = new Matrix3D();
        }
        if (bodyInertiaDA == null) {
            bodyInertiaDA = new Matrix3D();
        }
        if (bodyInertiaPoseBC == null) {
            bodyInertiaPoseBC = new RigidBodyTransform();
        }
        if (bodyInertiaPoseDA == null) {
            bodyInertiaPoseDA = new RigidBodyTransform();
        }
        MovingReferenceFrame parentFrame = predecessor.isRootBody() ? predecessor.getBodyFixedFrame() : predecessor.getParentJoint().getFrameAfterJoint();
        RigidBody base = new RigidBody(name + "InternalBase", parentFrame);
        RevoluteJoint jointA = new RevoluteJoint(jointNameA, (RigidBodyBasics)base, transformAToPredecessor, jointAxis);
        RevoluteJoint jointB = new RevoluteJoint(jointNameB, (RigidBodyBasics)base, transformBToPredecessor, jointAxis);
        RigidBodyBasics bodyBC = rigidBodyBuilder.build(bodyNameBC, jointB, bodyInertiaBC, bodyMassBC, bodyInertiaPoseBC);
        RigidBodyBasics bodyDA = rigidBodyBuilder.build(bodyNameDA, jointA, bodyInertiaDA, bodyMassDA, bodyInertiaPoseDA);
        RevoluteJoint jointC = new RevoluteJoint(jointNameC, bodyBC, transformCToB, jointAxis);
        RevoluteJoint jointD = new RevoluteJoint(jointNameD, bodyDA, transformDToA, jointAxis);
        RigidBodyTransform transformDToC = new RigidBodyTransform();
        transformDToC.multiply(transformCToB);
        transformDToC.multiply(transformBToPredecessor);
        transformDToC.multiplyInvertOther(transformAToPredecessor);
        transformDToC.multiplyInvertOther(transformDToA);
        if (loopClosureJointIndex == 2) {
            RigidBody end = new RigidBody(name + "InternalEnd", (JointBasics)jointD, (Matrix3DReadOnly)new Matrix3D(), 0.0, (RigidBodyTransformReadOnly)new RigidBodyTransform());
            jointC.setupLoopClosure(end, (RigidBodyTransformReadOnly)transformDToC);
        } else {
            RigidBody end = new RigidBody(name + "InternalEnd", (JointBasics)jointC, (Matrix3DReadOnly)new Matrix3D(), 0.0, (RigidBodyTransformReadOnly)new RigidBodyTransform());
            RigidBodyTransform transformCToD = new RigidBodyTransform();
            transformCToD.setAndInvert((RigidBodyTransformReadOnly)transformDToC);
            jointD.setupLoopClosure(end, (RigidBodyTransformReadOnly)transformCToD);
        }
        this.fourBarFunction = new FourBarKinematicLoopFunction(name, Arrays.asList(jointA, jointB, jointC, jointD), actuatedJointIndex);
        if (!this.fourBarFunction.isCrossed()) {
            throw new IllegalArgumentException("The given joint configuration does not represent a cross four bar.");
        }
        this.setIKSolver(new CrossFourBarJointIKBinarySolver(1.0E-5));
        this.name = name;
        this.predecessor = predecessor;
        predecessor.addChildJoint(this);
        this.nameId = JointReadOnly.computeNameId(this);
        if (this.getJointB().isLoopClosure() || this.getJointC().isLoopClosure()) {
            this.beforeJointFrame = this.getJointA().getFrameBeforeJoint();
            this.afterJointFrame = this.getJointD().getFrameAfterJoint();
        } else {
            this.beforeJointFrame = this.getJointB().getFrameBeforeJoint();
            this.afterJointFrame = this.getJointC().getFrameAfterJoint();
        }
        this.unitTwists = Collections.singletonList(this.unitJointTwist);
        this.jointTwist = MecanoFactories.newTwistReadOnly(this::getQd, this.unitJointTwist);
        this.jointAcceleration = MecanoFactories.newSpatialAccelerationVectorReadOnly(this::getQdd, this.unitJointAcceleration, this.jointBiasAcceleration);
    }

    private static String getInternalName(String jointName, String internalName, String defaultNameSuffix) {
        if (internalName == null) {
            return jointName + "_" + defaultNameSuffix;
        }
        return internalName;
    }

    public CrossFourBarJoint(String name, RevoluteJointBasics[] fourBarJoints, int actuatedJointIndex) {
        this.fourBarFunction = new FourBarKinematicLoopFunction(name, fourBarJoints, actuatedJointIndex);
        if (!this.fourBarFunction.isCrossed()) {
            throw new IllegalArgumentException("The given joint configuration does not represent a cross four bar.");
        }
        this.setIKSolver(new CrossFourBarJointIKBinarySolver(1.0E-5));
        this.name = name;
        this.predecessor = this.getJointA().getPredecessor();
        this.predecessor.getChildrenJoints().remove(this.getJointA());
        this.predecessor.getChildrenJoints().remove(this.getJointB());
        this.predecessor.addChildJoint(this);
        if (this.getJointB().isLoopClosure() || this.getJointC().isLoopClosure()) {
            this.beforeJointFrame = this.getJointA().getFrameBeforeJoint();
            this.afterJointFrame = this.getJointD().getFrameAfterJoint();
        } else {
            this.beforeJointFrame = this.getJointB().getFrameBeforeJoint();
            this.afterJointFrame = this.getJointC().getFrameAfterJoint();
        }
        this.nameId = this.predecessor.isRootBody() ? name : this.predecessor.getParentJoint().getNameId() + ":" + name;
        this.unitTwists = Collections.singletonList(this.unitJointTwist);
        this.jointTwist = MecanoFactories.newTwistReadOnly(this::getQd, this.unitJointTwist);
        this.jointAcceleration = MecanoFactories.newSpatialAccelerationVectorReadOnly(this::getQdd, this.unitJointAcceleration, this.jointBiasAcceleration);
    }

    @Override
    public void setSuccessor(RigidBodyBasics successor) {
        this.successor = successor;
        this.jointWrench = MecanoFactories.newWrenchReadOnly(this::getTau, this.unitJointWrench);
    }

    public void setIKSolver(CrossFourBarJointIKSolver ikSolver) {
        this.ikSolver = ikSolver;
        ikSolver.setConverters(this.fourBarFunction.getConverters());
    }

    @Override
    public void updateFrame() {
        this.fourBarFunction.updateState(true, true);
        this.getJointA().getFrameBeforeJoint().update();
        this.getJointB().getFrameBeforeJoint().update();
        this.getJointC().getFrameBeforeJoint().update();
        this.getJointD().getFrameBeforeJoint().update();
        this.getJointA().getFrameAfterJoint().update();
        this.getJointB().getFrameAfterJoint().update();
        this.getJointC().getFrameAfterJoint().update();
        this.getJointD().getFrameAfterJoint().update();
        this.updateMotionSubspace();
    }

    @Override
    public void updateMotionSubspace() {
        CrossFourBarJoint.updateUnitJointTwist(this, this.unitJointTwist);
        this.unitJointAcceleration.setIncludingFrame(this.unitJointTwist);
        CrossFourBarJoint.updateBiasAcceleration(this, this.deltaTwist, this.bodyTwist, this.jointBiasAcceleration);
        if (this.getSuccessor() != null) {
            this.unitSuccessorTwist.setIncludingFrame(this.unitJointTwist);
            this.unitSuccessorTwist.setBaseFrame(this.predecessor.getBodyFixedFrame());
            this.unitSuccessorTwist.setBodyFrame(this.successor.getBodyFixedFrame());
            this.unitSuccessorTwist.changeFrame(this.successor.getBodyFixedFrame());
            this.unitPredecessorTwist.setIncludingFrame(this.unitSuccessorTwist);
            this.unitPredecessorTwist.invert();
            this.unitPredecessorTwist.changeFrame(this.predecessor.getBodyFixedFrame());
            this.unitSuccessorAcceleration.setIncludingFrame(this.unitSuccessorTwist);
            this.unitPredecessorAcceleration.setIncludingFrame(this.unitPredecessorTwist);
            this.successorBiasAcceleration.setIncludingFrame(this.jointBiasAcceleration);
            this.successorBiasAcceleration.setBaseFrame(this.getPredecessor().getBodyFixedFrame());
            this.successorBiasAcceleration.setBodyFrame(this.getSuccessor().getBodyFixedFrame());
            this.successorBiasAcceleration.changeFrame(this.getSuccessor().getBodyFixedFrame());
            this.unitJointWrench.setIncludingFrame(this.fourBarFunction.getActuatedJoint().getUnitJointTwist());
            this.unitJointWrench.changeFrame(this.afterJointFrame);
            this.unitJointWrench.setBodyFrame(this.getSuccessor().getBodyFixedFrame());
        }
    }

    public static void updateUnitJointTwist(CrossFourBarJointReadOnly joint, TwistBasics unitJointTwistToPack) {
        double J_2;
        double J_1;
        RevoluteJointReadOnly joint2;
        RevoluteJointReadOnly joint1;
        DMatrix loopJacobian = joint.getLoopJacobian();
        if (joint.getFrameBeforeJoint() == joint.getJointA().getFrameBeforeJoint()) {
            joint1 = joint.getJointA();
            joint2 = joint.getJointD();
            J_1 = loopJacobian.get(0, 0);
            J_2 = loopJacobian.get(3, 0);
        } else {
            joint1 = joint.getJointB();
            joint2 = joint.getJointC();
            J_1 = loopJacobian.get(1, 0);
            J_2 = loopJacobian.get(2, 0);
        }
        TwistReadOnly j1UnitTwist = joint1.getUnitJointTwist();
        TwistReadOnly j2UnitTwist = joint2.getUnitJointTwist();
        unitJointTwistToPack.setIncludingFrame(j1UnitTwist);
        unitJointTwistToPack.scale(J_1);
        unitJointTwistToPack.setBodyFrame(joint2.getFrameBeforeJoint());
        unitJointTwistToPack.changeFrame(joint2.getFrameAfterJoint());
        unitJointTwistToPack.getAngularPart().scaleAdd(J_2, (FrameTuple3DReadOnly)j2UnitTwist.getAngularPart(), (FrameTuple3DReadOnly)unitJointTwistToPack.getAngularPart());
        unitJointTwistToPack.getLinearPart().scaleAdd(J_2, (FrameTuple3DReadOnly)j2UnitTwist.getLinearPart(), (FrameTuple3DReadOnly)unitJointTwistToPack.getLinearPart());
        unitJointTwistToPack.scale(1.0 / (J_1 + J_2));
        unitJointTwistToPack.setBodyFrame(joint.getFrameAfterJoint());
    }

    public static void updateBiasAcceleration(CrossFourBarJointReadOnly joint, TwistBasics deltaTwist, TwistBasics bodyTwist, SpatialAccelerationBasics jointBiasAcceleration) {
        double c_2;
        double c_1;
        RevoluteJointReadOnly joint2;
        RevoluteJointReadOnly joint1;
        DMatrix loopConvectiveTerm = joint.getLoopConvectiveTerm();
        if (joint.getFrameBeforeJoint() == joint.getJointA().getFrameBeforeJoint()) {
            joint1 = joint.getJointA();
            joint2 = joint.getJointD();
            c_1 = loopConvectiveTerm.get(0, 0);
            c_2 = loopConvectiveTerm.get(3, 0);
        } else {
            joint1 = joint.getJointB();
            joint2 = joint.getJointC();
            c_1 = loopConvectiveTerm.get(1, 0);
            c_2 = loopConvectiveTerm.get(2, 0);
        }
        SpatialAccelerationReadOnly jUnitAccel = joint.getUnitJointAcceleration();
        SpatialAccelerationReadOnly j1UnitAccel = joint1.getUnitJointAcceleration();
        SpatialAccelerationReadOnly j2UnitAccel = joint2.getUnitJointAcceleration();
        joint2.getFrameAfterJoint().getTwistRelativeToOther(joint1.getFrameAfterJoint(), deltaTwist);
        joint2.getFrameBeforeJoint().getTwistRelativeToOther(joint1.getFrameBeforeJoint(), bodyTwist);
        deltaTwist.changeFrame(joint2.getFrameAfterJoint());
        bodyTwist.changeFrame(joint2.getFrameAfterJoint());
        jointBiasAcceleration.setIncludingFrame(j1UnitAccel);
        jointBiasAcceleration.scale(c_1);
        jointBiasAcceleration.setBodyFrame(joint2.getFrameBeforeJoint());
        jointBiasAcceleration.changeFrame(joint2.getFrameAfterJoint(), deltaTwist, bodyTwist);
        FixedFrameVector3DBasics jointBiasAngularAcceleration = jointBiasAcceleration.getAngularPart();
        FixedFrameVector3DBasics jointBiasLinearAcceleration = jointBiasAcceleration.getLinearPart();
        jointBiasAngularAcceleration.scaleAdd(c_2, (FrameTuple3DReadOnly)j2UnitAccel.getAngularPart(), (FrameTuple3DReadOnly)jointBiasAngularAcceleration);
        jointBiasLinearAcceleration.scaleAdd(c_2, (FrameTuple3DReadOnly)j2UnitAccel.getLinearPart(), (FrameTuple3DReadOnly)jointBiasLinearAcceleration);
        jointBiasAngularAcceleration.scaleAdd(-(c_1 + c_2), (FrameTuple3DReadOnly)jUnitAccel.getAngularPart(), (FrameTuple3DReadOnly)jointBiasAngularAcceleration);
        jointBiasLinearAcceleration.scaleAdd(-(c_1 + c_2), (FrameTuple3DReadOnly)jUnitAccel.getLinearPart(), (FrameTuple3DReadOnly)jointBiasLinearAcceleration);
        jointBiasAcceleration.setBodyFrame(joint.getFrameAfterJoint());
    }

    public FourBarKinematicLoopFunction getFourBarFunction() {
        return this.fourBarFunction;
    }

    @Override
    public RevoluteJointBasics getActuatedJoint() {
        return this.fourBarFunction.getActuatedJoint();
    }

    @Override
    public RevoluteJointBasics getJointA() {
        return this.fourBarFunction.getJointA();
    }

    @Override
    public RevoluteJointBasics getJointB() {
        return this.fourBarFunction.getJointB();
    }

    @Override
    public RevoluteJointBasics getJointC() {
        return this.fourBarFunction.getJointC();
    }

    @Override
    public RevoluteJointBasics getJointD() {
        return this.fourBarFunction.getJointD();
    }

    @Override
    public int getActuatedJointIndex() {
        return this.fourBarFunction.getActuatedJointIndex();
    }

    public DMatrixRMaj getLoopJacobian() {
        return this.fourBarFunction.getLoopJacobian();
    }

    public DMatrixRMaj getLoopConvectiveTerm() {
        return this.fourBarFunction.getLoopConvectiveTerm();
    }

    public CrossFourBarJointIKSolver getIKSolver() {
        return this.ikSolver;
    }

    @Override
    public MovingReferenceFrame getFrameBeforeJoint() {
        return this.beforeJointFrame;
    }

    @Override
    public MovingReferenceFrame getFrameAfterJoint() {
        return this.afterJointFrame;
    }

    @Override
    public RigidBodyBasics getPredecessor() {
        return this.predecessor;
    }

    @Override
    public RigidBodyBasics getSuccessor() {
        return this.successor;
    }

    @Override
    public MovingReferenceFrame getLoopClosureFrame() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameId() {
        return this.nameId;
    }

    @Override
    public void setupLoopClosure(RigidBodyBasics successor, RigidBodyTransformReadOnly transformFromSuccessorParentJoint) {
        throw new UnsupportedOperationException("Loop closure using a four bar joint has not been implemented.");
    }

    @Override
    public double getTau() {
        DMatrixRMaj loopJacobian = this.fourBarFunction.getLoopJacobian();
        this.fourBarFunction.updateEffort();
        if (this.getActuatedJoint() == this.getJointA() || this.getActuatedJoint() == this.getJointD()) {
            return this.getActuatedJoint().getTau() / (loopJacobian.get(0) + loopJacobian.get(3));
        }
        return this.getActuatedJoint().getTau() / (loopJacobian.get(1) + loopJacobian.get(2));
    }

    @Override
    public TwistReadOnly getUnitJointTwist() {
        return this.unitJointTwist;
    }

    @Override
    public TwistReadOnly getUnitSuccessorTwist() {
        return this.unitSuccessorTwist;
    }

    @Override
    public TwistReadOnly getUnitPredecessorTwist() {
        return this.unitPredecessorTwist;
    }

    @Override
    public SpatialAccelerationReadOnly getUnitJointAcceleration() {
        return this.unitJointAcceleration;
    }

    @Override
    public SpatialAccelerationReadOnly getUnitSuccessorAcceleration() {
        return this.unitSuccessorAcceleration;
    }

    @Override
    public SpatialAccelerationReadOnly getUnitPredecessorAcceleration() {
        return this.unitPredecessorAcceleration;
    }

    @Override
    public void getJointConfiguration(RigidBodyTransform jointConfigurationToPack) {
        this.afterJointFrame.getTransformToDesiredFrame(jointConfigurationToPack, this.beforeJointFrame);
    }

    @Override
    public TwistReadOnly getJointTwist() {
        return this.jointTwist;
    }

    @Override
    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }

    @Override
    public SpatialAccelerationReadOnly getJointAcceleration() {
        return this.jointAcceleration;
    }

    @Override
    public SpatialAccelerationReadOnly getJointBiasAcceleration() {
        return this.jointBiasAcceleration;
    }

    @Override
    public SpatialAccelerationReadOnly getSuccessorBiasAcceleration() {
        return this.successorBiasAcceleration;
    }

    @Override
    public void getPredecessorAcceleration(SpatialAccelerationBasics accelerationToPack) {
        throw new UnsupportedOperationException("Implement me!");
    }

    @Override
    public SpatialAccelerationReadOnly getPredecessorBiasAcceleration() {
        throw new UnsupportedOperationException("Implement me!");
    }

    @Override
    public WrenchReadOnly getJointWrench() {
        return this.jointWrench;
    }

    @Override
    public void setJointOrientation(Orientation3DReadOnly jointOrientation) {
        jointOrientation.getRotationVector((Vector3DBasics)this.rotationVector);
        this.setQ(this.rotationVector.dot((Vector3DReadOnly)this.getJointAxis()));
    }

    @Override
    public double computeActuatedJointQ(double q) {
        return this.ikSolver.solve(q, this.fourBarFunction.getActuatedVertex());
    }

    @Override
    public double computeActuatedJointQd(double qd) {
        this.fourBarFunction.updateState(false, false);
        DMatrixRMaj loopJacobian = this.fourBarFunction.getLoopJacobian();
        return qd / (loopJacobian.get(0) + loopJacobian.get(3));
    }

    @Override
    public double computeActuatedJointQdd(double qdd) {
        this.fourBarFunction.updateState(false, false);
        DMatrixRMaj loopJacobian = this.fourBarFunction.getLoopJacobian();
        DMatrixRMaj loopConvectiveTerm = this.fourBarFunction.getLoopConvectiveTerm();
        qdd = qdd - loopConvectiveTerm.get(0) - loopConvectiveTerm.get(3);
        double qdd_actuated = qdd / (loopJacobian.get(0) + loopJacobian.get(3));
        return qdd_actuated;
    }

    @Override
    public double computeActuatedJointTau(double tau) {
        DMatrixRMaj loopJacobian = this.fourBarFunction.getLoopJacobian();
        if (this.getActuatedJoint() == this.getJointA() || this.getActuatedJoint() == this.getJointD()) {
            return (loopJacobian.get(0) + loopJacobian.get(3)) * tau;
        }
        return (loopJacobian.get(1) + loopJacobian.get(2)) * tau;
    }

    @Override
    public void setJointLimitLower(double jointLimitLower) {
        this.jointLimitLower = jointLimitLower;
    }

    @Override
    public void setJointLimitUpper(double jointLimitUpper) {
        this.jointLimitUpper = jointLimitUpper;
    }

    @Override
    public void setVelocityLimitLower(double velocityLimitLower) {
        this.velocityLimitLower = velocityLimitLower;
    }

    @Override
    public void setVelocityLimitUpper(double velocityLimitUpper) {
        this.velocityLimitUpper = velocityLimitUpper;
    }

    @Override
    public void setEffortLimitLower(double effortLimitLower) {
        this.effortLimitLower = effortLimitLower;
    }

    @Override
    public void setEffortLimitUpper(double effortLimitUpper) {
        this.effortLimitUpper = effortLimitUpper;
    }

    @Override
    public double getJointLimitLower() {
        return Math.max(CrossFourBarJointBasics.super.getJointLimitLower(), this.jointLimitLower);
    }

    @Override
    public double getJointLimitUpper() {
        return Math.min(CrossFourBarJointBasics.super.getJointLimitUpper(), this.jointLimitUpper);
    }

    @Override
    public double getVelocityLimitLower() {
        return Math.max(CrossFourBarJointBasics.super.getVelocityLimitLower(), this.velocityLimitLower);
    }

    @Override
    public double getVelocityLimitUpper() {
        return Math.min(CrossFourBarJointBasics.super.getVelocityLimitUpper(), this.velocityLimitUpper);
    }

    @Override
    public double getEffortLimitLower() {
        return Math.max(CrossFourBarJointBasics.super.getEffortLimitLower(), this.effortLimitLower);
    }

    @Override
    public double getEffortLimitUpper() {
        return Math.min(CrossFourBarJointBasics.super.getEffortLimitUpper(), this.effortLimitUpper);
    }

    public String toString() {
        String qAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQ());
        String qdAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQd());
        String qddAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQdd());
        String tauAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getTau());
        return this.getClass().getSimpleName() + " " + this.getName() + ", q: " + qAsString + ", qd: " + qdAsString + ", qdd: " + qddAsString + ", tau: " + tauAsString;
    }

    public int hashCode() {
        return this.nameId.hashCode();
    }

    public static CrossFourBarJoint cloneCrossFourBarJoint(CrossFourBarJointReadOnly original, ReferenceFrame stationaryFrame, String cloneSuffix) {
        RigidBodyReadOnly originalPredecessor = original.getPredecessor();
        RigidBody clonePredecessor = new RigidBody(originalPredecessor.getName() + cloneSuffix, stationaryFrame);
        return CrossFourBarJoint.cloneCrossFourBarJoint(original, clonePredecessor, cloneSuffix);
    }

    public static CrossFourBarJoint cloneCrossFourBarJoint(CrossFourBarJointReadOnly original, RigidBodyBasics clonePredecessor, String cloneSuffix) {
        return (CrossFourBarJoint)MultiBodySystemFactories.DEFAULT_JOINT_BUILDER.cloneCrossFourBarJoint(original, cloneSuffix, clonePredecessor);
    }
}

