/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.algorithms.GeometricJacobianCalculator;
import us.ihmc.mecano.algorithms.SpatialAccelerationCalculator;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.PrismaticJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class GeometricJacobianCalculatorTest {
    private static final int ITERATIONS = 1000;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Test
    public void testNoPathFromBaseToEndEffector() {
        Random random = new Random(34635L);
        List chain1 = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)20);
        List chain2 = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)20);
        RigidBodyBasics bodyOnChain1 = ((JointBasics)chain1.get(random.nextInt(chain1.size()))).getSuccessor();
        RigidBodyBasics bodyOnChain2 = ((JointBasics)chain2.get(random.nextInt(chain2.size()))).getSuccessor();
        GeometricJacobianCalculator calculator = new GeometricJacobianCalculator();
        Assertions.assertThrows(IllegalArgumentException.class, () -> calculator.setKinematicChain((RigidBodyReadOnly)bodyOnChain1, (RigidBodyReadOnly)bodyOnChain2));
    }

    @Test
    public void testBasicFeatures() throws Exception {
        Random random = new Random(435435L);
        GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
        this.verifyThatHasBeenCleared(jacobianCalculator);
        int numberOfJoints = 10;
        List joints = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
        RigidBodyBasics base = ((Joint)joints.get(0)).getPredecessor();
        RigidBodyBasics endEffector = ((Joint)joints.get(numberOfJoints - 1)).getSuccessor();
        jacobianCalculator.setKinematicChain((RigidBodyReadOnly)base, (RigidBodyReadOnly)endEffector);
        DMatrixRMaj jacobianMatrix = new DMatrixRMaj(jacobianCalculator.getJacobianMatrix());
        Assertions.assertEquals((int)6, (int)jacobianMatrix.getNumRows());
        Assertions.assertEquals((int)numberOfJoints, (int)jacobianMatrix.getNumCols());
        DMatrixRMaj convectiveTerm = new DMatrixRMaj(jacobianCalculator.getConvectiveTermMatrix());
        Assertions.assertEquals((int)6, (int)convectiveTerm.getNumRows());
        Assertions.assertEquals((int)1, (int)convectiveTerm.getNumCols());
        jacobianCalculator.clear();
        this.verifyThatHasBeenCleared(jacobianCalculator);
        jacobianCalculator.setKinematicChain((JointReadOnly[])joints.toArray(new Joint[0]));
        Assertions.assertTrue((base == jacobianCalculator.getBase() ? 1 : 0) != 0);
        Assertions.assertTrue((endEffector == jacobianCalculator.getEndEffector() ? 1 : 0) != 0);
        jacobianMatrix = new DMatrixRMaj(jacobianCalculator.getJacobianMatrix());
        Assertions.assertEquals((int)6, (int)jacobianMatrix.getNumRows());
        Assertions.assertEquals((int)numberOfJoints, (int)jacobianMatrix.getNumCols());
        convectiveTerm = new DMatrixRMaj(jacobianCalculator.getConvectiveTermMatrix());
        Assertions.assertEquals((int)6, (int)convectiveTerm.getNumRows());
        Assertions.assertEquals((int)1, (int)convectiveTerm.getNumCols());
        jacobianCalculator.clear();
        this.verifyThatHasBeenCleared(jacobianCalculator);
    }

    public void verifyThatHasBeenCleared(GeometricJacobianCalculator jacobianCalculator) {
        Assertions.assertNull((Object)jacobianCalculator.getBase());
        Assertions.assertNull((Object)jacobianCalculator.getEndEffector());
        Assertions.assertNull((Object)jacobianCalculator.getJacobianFrame());
        Assertions.assertTrue((boolean)jacobianCalculator.getJointsFromBaseToEndEffector().isEmpty());
        Assertions.assertEquals((int)-1, (int)jacobianCalculator.getNumberOfDegreesOfFreedom());
        try {
            jacobianCalculator.getJacobianMatrix();
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            jacobianCalculator.getConvectiveTerm();
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testAgainstTwistCalculatorChainRobot() throws Exception {
        Random random = new Random(4324342L);
        int numberOfJoints = random.nextInt(100);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((Joint)joints.get(0)).getSuccessor());
        GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
        for (int i = 0; i < 1000; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody.updateFramesRecursively();
            int randomEndEffectorIndex = random.nextInt(numberOfJoints);
            RigidBodyBasics randomEndEffector = ((Joint)joints.get(randomEndEffectorIndex)).getSuccessor();
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)randomEndEffector);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-12);
            RigidBodyBasics randomBase = ((Joint)joints.get(random.nextInt(randomEndEffectorIndex + 1))).getPredecessor();
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-12);
            RigidBodyTransform transformToParent = new RigidBodyTransform();
            transformToParent.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0));
            ReferenceFrame fixedInEndEffector = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)("fixedFrame" + i), (ReferenceFrame)randomEndEffector.getBodyFixedFrame(), (RigidBodyTransformReadOnly)transformToParent);
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)randomEndEffector);
            jacobianCalculator.setJacobianFrame(fixedInEndEffector);
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-12);
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector);
            jacobianCalculator.setJacobianFrame(fixedInEndEffector);
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-12);
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((JointReadOnly[])MultiBodySystemTools.createJointPath((RigidBodyBasics)rootBody, (RigidBodyBasics)randomEndEffector));
            Assertions.assertTrue((rootBody == jacobianCalculator.getBase() ? 1 : 0) != 0);
            Assertions.assertTrue((randomEndEffector == jacobianCalculator.getEndEffector() ? 1 : 0) != 0);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-12);
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((JointReadOnly[])MultiBodySystemTools.createJointPath((RigidBodyBasics)randomBase, (RigidBodyBasics)randomEndEffector));
            Assertions.assertTrue((randomBase == jacobianCalculator.getBase() ? 1 : 0) != 0);
            Assertions.assertTrue((randomEndEffector == jacobianCalculator.getEndEffector() ? 1 : 0) != 0);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-12);
        }
    }

    @Test
    public void testConvectiveTerm() throws Exception {
        int i;
        Random random = new Random(345345L);
        int numberOfJoints = 100;
        List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
        GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
        for (i = 0; i < 1000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)joints.get(0)).getPredecessor());
            rootBody.updateFramesRecursively();
            SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)rootBody, worldFrame, true, false);
            spatialAccelerationCalculator.reset();
            int randomEndEffectorIndex = random.nextInt(numberOfJoints);
            RigidBodyBasics randomEndEffector = ((JointBasics)joints.get(randomEndEffectorIndex)).getSuccessor();
            RigidBodyBasics randomBase = ((JointBasics)joints.get(random.nextInt(randomEndEffectorIndex + 1))).getPredecessor();
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            SpatialAcceleration actualConvectiveTerm = new SpatialAcceleration((SpatialMotionReadOnly)jacobianCalculator.getConvectiveTerm());
            SpatialAccelerationReadOnly expectedConvectiveTerm = spatialAccelerationCalculator.getRelativeAcceleration((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector);
            MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedConvectiveTerm, (SpatialAccelerationReadOnly)actualConvectiveTerm, (double)1.0E-11);
            GeometricJacobianCalculatorTest.assertJacobianRateConsistency(jacobianCalculator, 1.0E-11);
        }
        for (i = 0; i < 1000; ++i) {
            for (RigidBodyBasics stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            RigidBodyBasics body = ((JointBasics)joints.get(0)).getPredecessor();
            RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)body);
            rootBody.updateFramesRecursively();
            SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)rootBody, worldFrame, true, false);
            spatialAccelerationCalculator.reset();
            int randomEndEffectorIndex = random.nextInt(numberOfJoints);
            RigidBodyBasics randomEndEffector = ((JointBasics)joints.get(randomEndEffectorIndex)).getSuccessor();
            RigidBodyBasics randomBase = ((JointBasics)joints.get(random.nextInt(randomEndEffectorIndex + 1))).getPredecessor();
            RigidBodyTransform transformToParent = new RigidBodyTransform();
            transformToParent.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0));
            ReferenceFrame fixedInEndEffector = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)("fixedFrame" + i), (ReferenceFrame)randomEndEffector.getBodyFixedFrame(), (RigidBodyTransformReadOnly)transformToParent);
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector);
            jacobianCalculator.setJacobianFrame(fixedInEndEffector);
            SpatialAcceleration actualConvectiveTerm = new SpatialAcceleration((SpatialMotionReadOnly)jacobianCalculator.getConvectiveTerm());
            SpatialAcceleration expectedConvectiveTerm = new SpatialAcceleration((SpatialMotionReadOnly)spatialAccelerationCalculator.getRelativeAcceleration((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector));
            expectedConvectiveTerm.changeFrame(fixedInEndEffector);
            MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedConvectiveTerm, (SpatialAccelerationReadOnly)actualConvectiveTerm, (double)1.0E-11);
            GeometricJacobianCalculatorTest.assertJacobianRateConsistency(jacobianCalculator, 1.0E-11);
        }
    }

    @Test
    public void testAgainstSpatialAccelerationCalculatorChainRobot() throws Exception {
        Random random = new Random(4324342L);
        int numberOfJoints = random.nextInt(100);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((Joint)joints.get(0)).getSuccessor());
        GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
        for (int i = 0; i < 1000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            rootBody.updateFramesRecursively();
            int randomEndEffectorIndex = random.nextInt(numberOfJoints);
            RigidBodyBasics randomEndEffector = ((Joint)joints.get(randomEndEffectorIndex)).getSuccessor();
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)randomEndEffector);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-10);
            RigidBodyBasics randomBase = ((Joint)joints.get(random.nextInt(randomEndEffectorIndex + 1))).getPredecessor();
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-10);
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((JointReadOnly[])MultiBodySystemTools.createJointPath((RigidBodyBasics)rootBody, (RigidBodyBasics)randomEndEffector));
            Assertions.assertTrue((rootBody == jacobianCalculator.getBase() ? 1 : 0) != 0);
            Assertions.assertTrue((randomEndEffector == jacobianCalculator.getEndEffector() ? 1 : 0) != 0);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-10);
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((JointReadOnly[])MultiBodySystemTools.createJointPath((RigidBodyBasics)randomBase, (RigidBodyBasics)randomEndEffector));
            Assertions.assertTrue((randomBase == jacobianCalculator.getBase() ? 1 : 0) != 0);
            Assertions.assertTrue((randomEndEffector == jacobianCalculator.getEndEffector() ? 1 : 0) != 0);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-10);
        }
    }

    @Test
    public void testAgainstTwistCalculatorFloatingJointRobot() throws Exception {
        Random random = new Random(4324342L);
        int numberOfJoints = random.nextInt(100);
        List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)joints.get(0)).getSuccessor());
        GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
        for (int i = 0; i < 1000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            rootBody.updateFramesRecursively();
            int randomEndEffectorIndex = random.nextInt(numberOfJoints);
            RigidBodyBasics randomEndEffector = ((JointBasics)joints.get(randomEndEffectorIndex)).getSuccessor();
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)randomEndEffector);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-12);
            RigidBodyBasics randomBase = ((JointBasics)joints.get(random.nextInt(randomEndEffectorIndex + 1))).getPredecessor();
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-12);
        }
    }

    @Test
    public void testAgainstSpatialAccelerationCalculatorFloatingJointRobot() throws Exception {
        Random random = new Random(4324342L);
        int numberOfJoints = random.nextInt(100);
        List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)joints.get(0)).getSuccessor());
        GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
        for (int i = 0; i < 1000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            rootBody.updateFramesRecursively();
            int randomEndEffectorIndex = random.nextInt(numberOfJoints);
            RigidBodyBasics randomEndEffector = ((JointBasics)joints.get(randomEndEffectorIndex)).getSuccessor();
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)randomEndEffector);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-10);
            RigidBodyBasics randomBase = ((JointBasics)joints.get(random.nextInt(randomEndEffectorIndex + 1))).getPredecessor();
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomEndEffector.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)randomBase, (RigidBodyReadOnly)randomEndEffector, jacobianCalculator, 1.0E-10);
        }
    }

    @Test
    public void testJacobianBetweenTwoEndEffectors() {
        RigidBodyBasics endEffector2;
        RigidBodyBasics endEffector1;
        int i;
        Random random = new Random(1266545L);
        int numberOfJoints = 50;
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((Joint)joints.get(0)).getSuccessor());
        GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
        for (int i2 = 0; i2 < 1000; ++i2) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            rootBody.updateFramesRecursively();
            int randomEndEffectorIndex = random.nextInt(numberOfJoints);
            RigidBodyBasics randomEndEffector = ((Joint)joints.get(randomEndEffectorIndex)).getSuccessor();
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)randomEndEffector, (RigidBodyReadOnly)rootBody);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)rootBody.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)randomEndEffector, (RigidBodyReadOnly)rootBody, jacobianCalculator, 1.0E-12);
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)randomEndEffector, (RigidBodyReadOnly)rootBody, jacobianCalculator, 1.0E-10);
            RigidBodyBasics randomBase = ((Joint)joints.get(random.nextInt(randomEndEffectorIndex + 1))).getPredecessor();
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)randomEndEffector, (RigidBodyReadOnly)randomBase);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomBase.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)randomEndEffector, (RigidBodyReadOnly)randomBase, jacobianCalculator, 1.0E-12);
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)randomEndEffector, (RigidBodyReadOnly)randomBase, jacobianCalculator, 1.0E-10);
            if (MultiBodySystemTools.computeDistance((RigidBodyReadOnly)randomEndEffector, (RigidBodyReadOnly)rootBody) > 1) {
                jacobianCalculator.clear();
                jacobianCalculator.setKinematicChain((JointReadOnly[])MultiBodySystemTools.createJointPath((RigidBodyBasics)randomEndEffector, (RigidBodyBasics)rootBody));
                Assertions.assertTrue((jacobianCalculator.getBase() == randomEndEffector ? 1 : 0) != 0);
                Assertions.assertTrue((jacobianCalculator.getEndEffector() == rootBody ? 1 : 0) != 0);
                jacobianCalculator.setJacobianFrame((ReferenceFrame)rootBody.getBodyFixedFrame());
                GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)randomEndEffector, (RigidBodyReadOnly)rootBody, jacobianCalculator, 1.0E-12);
                GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)randomEndEffector, (RigidBodyReadOnly)rootBody, jacobianCalculator, 1.0E-10);
            }
            if (MultiBodySystemTools.computeDistance((RigidBodyReadOnly)randomEndEffector, (RigidBodyReadOnly)randomBase) <= 1) continue;
            jacobianCalculator.clear();
            jacobianCalculator.setKinematicChain((JointReadOnly[])MultiBodySystemTools.createJointPath((RigidBodyBasics)randomEndEffector, (RigidBodyBasics)randomBase));
            Assertions.assertTrue((jacobianCalculator.getBase() == randomEndEffector ? 1 : 0) != 0);
            Assertions.assertTrue((jacobianCalculator.getEndEffector() == randomBase ? 1 : 0) != 0);
            jacobianCalculator.setJacobianFrame((ReferenceFrame)randomBase.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)randomEndEffector, (RigidBodyReadOnly)randomBase, jacobianCalculator, 1.0E-12);
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)randomEndEffector, (RigidBodyReadOnly)randomBase, jacobianCalculator, 1.0E-10);
        }
        numberOfJoints = 50;
        joints = MultiBodySystemRandomTools.nextPrismaticJointTree((Random)random, (int)numberOfJoints);
        rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((PrismaticJoint)joints.get(0)).getPredecessor());
        List<RigidBodyBasics> endEffectors = Arrays.asList(MultiBodySystemTools.collectSubtreeEndEffectors((RigidBodyBasics)rootBody));
        GeometricJacobianCalculator jacobianCalculator2 = new GeometricJacobianCalculator();
        for (i = 0; i < 1000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            rootBody.updateFramesRecursively();
            int endEffector1Index = random.nextInt(endEffectors.size());
            int endEffector2Index = random.nextInt(endEffectors.size());
            while (endEffector2Index == endEffector1Index) {
                endEffector2Index = random.nextInt(endEffectors.size());
            }
            endEffector1 = endEffectors.get(endEffector1Index);
            endEffector2 = endEffectors.get(endEffector2Index);
            jacobianCalculator2.clear();
            jacobianCalculator2.setKinematicChain((RigidBodyReadOnly)endEffector1, (RigidBodyReadOnly)endEffector2);
            jacobianCalculator2.setJacobianFrame((ReferenceFrame)endEffector2.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)endEffector1, (RigidBodyReadOnly)endEffector2, jacobianCalculator2, 1.0E-12);
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)endEffector1, (RigidBodyReadOnly)endEffector2, jacobianCalculator2, 1.0E-10);
            if (MultiBodySystemTools.computeDistance((RigidBodyReadOnly)endEffector1, (RigidBodyReadOnly)endEffector2) <= 1) continue;
            jacobianCalculator2.clear();
            jacobianCalculator2.setKinematicChain((JointReadOnly[])MultiBodySystemTools.createJointPath((RigidBodyBasics)endEffector1, (RigidBodyBasics)endEffector2));
            Assertions.assertTrue((endEffector1 == jacobianCalculator2.getBase() ? 1 : 0) != 0);
            Assertions.assertTrue((endEffector2 == jacobianCalculator2.getEndEffector() ? 1 : 0) != 0);
            jacobianCalculator2.setJacobianFrame((ReferenceFrame)endEffector2.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)endEffector1, (RigidBodyReadOnly)endEffector2, jacobianCalculator2, 1.0E-12);
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)endEffector1, (RigidBodyReadOnly)endEffector2, jacobianCalculator2, 1.0E-10);
        }
        numberOfJoints = 50;
        joints = MultiBodySystemRandomTools.nextJointTree((Random)random, (int)numberOfJoints);
        rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)joints.get(0)).getPredecessor());
        endEffectors = Arrays.asList(MultiBodySystemTools.collectSubtreeEndEffectors((RigidBodyBasics)rootBody));
        jacobianCalculator2 = new GeometricJacobianCalculator();
        for (i = 0; i < 1000; ++i) {
            for (JointStateType stateToRandomize : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)stateToRandomize, (Iterable)joints);
            }
            rootBody.updateFramesRecursively();
            int endEffector1Index = random.nextInt(endEffectors.size());
            int endEffector2Index = random.nextInt(endEffectors.size());
            while (endEffector2Index == endEffector1Index) {
                endEffector2Index = random.nextInt(endEffectors.size());
            }
            endEffector1 = endEffectors.get(endEffector1Index);
            endEffector2 = endEffectors.get(endEffector2Index);
            jacobianCalculator2.clear();
            jacobianCalculator2.setKinematicChain((RigidBodyReadOnly)endEffector1, (RigidBodyReadOnly)endEffector2);
            jacobianCalculator2.setJacobianFrame((ReferenceFrame)endEffector2.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)endEffector1, (RigidBodyReadOnly)endEffector2, jacobianCalculator2, 1.0E-12);
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)endEffector1, (RigidBodyReadOnly)endEffector2, jacobianCalculator2, 1.0E-10);
            if (MultiBodySystemTools.computeDistance((RigidBodyReadOnly)endEffector1, (RigidBodyReadOnly)endEffector2) <= 1) continue;
            jacobianCalculator2.clear();
            jacobianCalculator2.setKinematicChain((JointReadOnly[])MultiBodySystemTools.createJointPath((RigidBodyBasics)endEffector1, (RigidBodyBasics)endEffector2));
            Assertions.assertTrue((endEffector1 == jacobianCalculator2.getBase() ? 1 : 0) != 0);
            Assertions.assertTrue((endEffector2 == jacobianCalculator2.getEndEffector() ? 1 : 0) != 0);
            jacobianCalculator2.setJacobianFrame((ReferenceFrame)endEffector2.getBodyFixedFrame());
            GeometricJacobianCalculatorTest.compareJacobianTwistAgainstTwistCalculator((RigidBodyReadOnly)endEffector1, (RigidBodyReadOnly)endEffector2, jacobianCalculator2, 1.0E-12);
            GeometricJacobianCalculatorTest.compareJacobianAccelerationAgainstSpatialAccelerationCalculator((RigidBodyReadOnly)endEffector1, (RigidBodyReadOnly)endEffector2, jacobianCalculator2, 1.0E-10);
        }
    }

    @Test
    public void testJacobianRateMatrix() {
        DMatrixRMaj expectedConvectiveTerm;
        DMatrixRMaj actualConvectiveTerm;
        DMatrixRMaj jointVelocities;
        DMatrixRMaj actualJacobianRateMatrix;
        DMatrixRMaj expectedJacobianRateMatrix;
        RigidBodyBasics endEffector;
        RigidBodyBasics rootBody;
        List joints;
        int numberOfJoints;
        int i;
        Random random = new Random(4324342L);
        GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(100) + 2;
            joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((OneDoFJoint)joints.get(0)).getSuccessor());
            endEffector = ((OneDoFJoint)joints.get(numberOfJoints - 1)).getSuccessor();
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)endEffector);
            expectedJacobianRateMatrix = GeometricJacobianCalculatorTest.computeJacobianRateFD(joints, jacobianCalculator, 1.0E-6);
            actualJacobianRateMatrix = jacobianCalculator.getJacobianRateMatrix();
            MecanoTestTools.assertDMatrixEquals((String)("Iteration: " + i), (DMatrix)expectedJacobianRateMatrix, (DMatrix)actualJacobianRateMatrix, (double)1.0E-7);
            jointVelocities = new DMatrixRMaj(numberOfJoints, 1);
            actualConvectiveTerm = new DMatrixRMaj(6, 1);
            MultiBodySystemTools.extractJointsState((List)joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
            CommonOps_DDRM.mult((DMatrix1Row)actualJacobianRateMatrix, (DMatrix1Row)jointVelocities, (DMatrix1Row)actualConvectiveTerm);
            expectedConvectiveTerm = jacobianCalculator.getConvectiveTermMatrix();
            MecanoTestTools.assertDMatrixEquals((String)("Iteration: " + i), (DMatrix)expectedConvectiveTerm, (DMatrix)actualConvectiveTerm, (double)1.0E-11);
        }
        for (i = 0; i < 1000; ++i) {
            numberOfJoints = random.nextInt(10) + 2;
            joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((JointBasics)joints.get(0)).getSuccessor());
            endEffector = ((JointBasics)joints.get(numberOfJoints - 1)).getSuccessor();
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
            jacobianCalculator.setKinematicChain((RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)endEffector);
            expectedJacobianRateMatrix = GeometricJacobianCalculatorTest.computeJacobianRateFD(joints, jacobianCalculator, 1.0E-6);
            actualJacobianRateMatrix = jacobianCalculator.getJacobianRateMatrix();
            MecanoTestTools.assertDMatrixEquals((String)("Iteration: " + i), (DMatrix)expectedJacobianRateMatrix, (DMatrix)actualJacobianRateMatrix, (double)1.0E-5);
            jointVelocities = new DMatrixRMaj(jacobianCalculator.getNumberOfDegreesOfFreedom(), 1);
            actualConvectiveTerm = new DMatrixRMaj(6, 1);
            MultiBodySystemTools.extractJointsState((List)joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
            CommonOps_DDRM.mult((DMatrix1Row)actualJacobianRateMatrix, (DMatrix1Row)jointVelocities, (DMatrix1Row)actualConvectiveTerm);
            expectedConvectiveTerm = jacobianCalculator.getConvectiveTermMatrix();
            MecanoTestTools.assertDMatrixEquals((String)("Iteration: " + i), (DMatrix)expectedConvectiveTerm, (DMatrix)actualConvectiveTerm, (double)1.0E-11);
        }
    }

    private static DMatrixRMaj computeJacobianRateFD(List<? extends JointBasics> joints, GeometricJacobianCalculator calculator, double dt) {
        int size = joints.stream().mapToInt(JointReadOnly::getConfigurationMatrixSize).sum();
        DMatrixRMaj q = new DMatrixRMaj(size, 1);
        MultiBodySystemTools.extractJointsState(joints, (JointStateType)JointStateType.CONFIGURATION, (DMatrix)q);
        new MultiBodySystemStateIntegrator(-0.5 * dt).integrateFromVelocity(joints);
        ((RigidBodyBasics)calculator.getBase()).updateFramesRecursively();
        calculator.reset();
        DMatrixRMaj jacobianCurrent = new DMatrixRMaj(calculator.getJacobianMatrix());
        new MultiBodySystemStateIntegrator(dt).integrateFromVelocity(joints);
        ((RigidBodyBasics)calculator.getBase()).updateFramesRecursively();
        calculator.reset();
        DMatrixRMaj jacobianNext = new DMatrixRMaj(calculator.getJacobianMatrix());
        DMatrixRMaj jacobianRate = new DMatrixRMaj(6, calculator.getNumberOfDegreesOfFreedom());
        CommonOps_DDRM.subtract((DMatrixD1)jacobianNext, (DMatrixD1)jacobianCurrent, (DMatrixD1)jacobianRate);
        CommonOps_DDRM.scale((double)(1.0 / dt), (DMatrixD1)jacobianRate);
        MultiBodySystemTools.insertJointsState(joints, (JointStateType)JointStateType.CONFIGURATION, (DMatrix)q);
        ((RigidBodyBasics)calculator.getBase()).updateFramesRecursively();
        calculator.reset();
        return jacobianRate;
    }

    public static void compareJacobianTwistAgainstTwistCalculator(RigidBodyReadOnly base, RigidBodyReadOnly endEffector, GeometricJacobianCalculator jacobianCalculator, double epsilon) throws AssertionError {
        Twist expectedTwist = new Twist();
        Twist actualTwist = new Twist();
        DMatrixRMaj jointVelocitiesMatrix = new DMatrixRMaj(jacobianCalculator.getNumberOfDegreesOfFreedom(), 1);
        MultiBodySystemTools.extractJointsState((List)jacobianCalculator.getJointsFromBaseToEndEffector(), (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocitiesMatrix);
        endEffector.getBodyFixedFrame().getTwistRelativeToOther((ReferenceFrame)base.getBodyFixedFrame(), (TwistBasics)expectedTwist);
        expectedTwist.changeFrame(jacobianCalculator.getJacobianFrame());
        jacobianCalculator.getEndEffectorTwist((DMatrix1Row)jointVelocitiesMatrix, (TwistBasics)actualTwist);
        MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)epsilon);
    }

    public static void compareJacobianAccelerationAgainstSpatialAccelerationCalculator(RigidBodyReadOnly base, RigidBodyReadOnly endEffector, GeometricJacobianCalculator jacobianCalculator, double epsilon) throws AssertionError {
        SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator(base, worldFrame);
        spatialAccelerationCalculator.reset();
        SpatialAcceleration actualAcceleration = new SpatialAcceleration();
        DMatrixRMaj jointDesiredAccelerationsMatrix = new DMatrixRMaj(jacobianCalculator.getNumberOfDegreesOfFreedom(), 1);
        MultiBodySystemTools.extractJointsState((List)jacobianCalculator.getJointsFromBaseToEndEffector(), (JointStateType)JointStateType.ACCELERATION, (DMatrix)jointDesiredAccelerationsMatrix);
        SpatialAccelerationReadOnly expectedAcceleration = spatialAccelerationCalculator.getRelativeAcceleration(base, endEffector);
        jacobianCalculator.getEndEffectorAcceleration((DMatrix1Row)jointDesiredAccelerationsMatrix, (SpatialAccelerationBasics)actualAcceleration);
        MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedAcceleration, (SpatialAccelerationReadOnly)actualAcceleration, (double)epsilon);
    }

    public static void assertJacobianRateConsistency(GeometricJacobianCalculator jacobianCalculator, double epsilon) {
        DMatrixRMaj jointVelocities = new DMatrixRMaj(jacobianCalculator.getNumberOfDegreesOfFreedom(), 1);
        MultiBodySystemTools.extractJointsState((List)jacobianCalculator.getJointsFromBaseToEndEffector(), (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
        DMatrixRMaj actualConvectiveTerm = new DMatrixRMaj(6, 1);
        CommonOps_DDRM.mult((DMatrix1Row)jacobianCalculator.getJacobianRateMatrix(), (DMatrix1Row)jointVelocities, (DMatrix1Row)actualConvectiveTerm);
        MecanoTestTools.assertDMatrixEquals((DMatrix)actualConvectiveTerm, (DMatrix)jacobianCalculator.getConvectiveTermMatrix(), (double)epsilon);
    }
}

