/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.fourBar;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.fourBar.CrossFourBarJointIKBinarySolver;
import us.ihmc.mecano.fourBar.FourBar;
import us.ihmc.mecano.fourBar.FourBarAngle;
import us.ihmc.mecano.fourBar.FourBarEdge;
import us.ihmc.mecano.fourBar.FourBarVertex;

public class CrossFourBarJointIKBinarySolverTest {
    private static final int ITERATIONS = 50000;
    private static final double EPSILON = 1.0E-7;

    @Test
    public void test() {
        Random random = new Random(4534L);
        FourBar fourBar = new FourBar();
        CrossFourBarJointIKBinarySolver defaultSolver = new CrossFourBarJointIKBinarySolver(9.999999999999999E-6);
        defaultSolver.setUseNaiveMethod(false);
        CrossFourBarJointIKBinarySolver naiveSolver = new CrossFourBarJointIKBinarySolver(9.999999999999999E-6);
        naiveSolver.setUseNaiveMethod(true);
        long defaultMethodTotalTimeNano = 0L;
        long naiveMethodTotalTimeNano = 0L;
        for (int i = 0; i < 50000; ++i) {
            List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)5.0, (int)4);
            int flippedIndex = random.nextInt(4);
            Collections.swap(vertices, flippedIndex, (flippedIndex + 1) % 4);
            Point2D A = (Point2D)vertices.get(0);
            Point2D B = (Point2D)vertices.get(1);
            Point2D C = (Point2D)vertices.get(2);
            Point2D D = (Point2D)vertices.get(3);
            fourBar.setup((Point2DReadOnly)A, (Point2DReadOnly)B, (Point2DReadOnly)C, (Point2DReadOnly)D);
            FourBarAngle source = FourBarAngle.values[random.nextInt(4)];
            FourBarVertex sourceVertex = fourBar.getVertex(source);
            double expectedAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)sourceVertex.getMinAngle(), (double)sourceVertex.getMaxAngle());
            fourBar.update(source, expectedAngle);
            FourBarEdge nonFlippedEdge = fourBar.getEdgeAB();
            while (nonFlippedEdge.isCrossing() || nonFlippedEdge.isFlipped()) {
                nonFlippedEdge = nonFlippedEdge.getNext();
            }
            double theta = nonFlippedEdge.getEnd().getAngle() + nonFlippedEdge.getEnd().getNextVertex().getAngle();
            long start = System.nanoTime();
            double actualAngle = defaultSolver.solve(theta, sourceVertex);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-7, (String)("Iteration: " + i));
            long end = System.nanoTime();
            defaultMethodTotalTimeNano += end - start;
            start = System.nanoTime();
            actualAngle = naiveSolver.solve(theta, sourceVertex);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-7, (String)("Iteration: " + i));
            end = System.nanoTime();
            naiveMethodTotalTimeNano += end - start;
        }
        LogTools.info((String)("Default method average solve time: " + (double)(defaultMethodTotalTimeNano / 50000L) / 1000000.0 + "millisec"));
        LogTools.info((String)("Naive method average solve time: " + (double)(naiveMethodTotalTimeNano / 50000L) / 1000000.0 + "millisec"));
    }
}

