/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.Random;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.mecano.algorithms.CompositeRigidBodyMassMatrixCalculator;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;

public class CoriolisMatrixFactorizationTest {
    private static final int ITERATIONS = 500;
    private static final double EPSILON = 1.0E-4;
    private static final double DT = 1.0E-7;
    private static final int MAX_JOINTS = 20;

    @Test
    public void testCoriolisMatrixFactorization() {
        Random random = new Random(329023L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(20);
            MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain robot = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, numberOfJoints);
            RigidBody elevator = robot.getElevator();
            MultiBodySystemBasics multiBodySystemInput = MultiBodySystemBasics.toMultiBodySystemBasics((RigidBodyBasics)elevator);
            robot.nextState(random, new JointStateType[]{JointStateType.CONFIGURATION, JointStateType.VELOCITY, JointStateType.ACCELERATION});
            CompositeRigidBodyMassMatrixCalculator massMatrixCalculator = new CompositeRigidBodyMassMatrixCalculator((MultiBodySystemReadOnly)multiBodySystemInput);
            massMatrixCalculator.setEnableCoriolisMatrixCalculation(true);
            DMatrixRMaj massMatrix0 = new DMatrixRMaj(0);
            DMatrixRMaj massMatrix1 = new DMatrixRMaj(0);
            DMatrixRMaj massMatrixDot = new DMatrixRMaj(0);
            massMatrixCalculator.reset();
            massMatrix0.set((DMatrixD1)massMatrixCalculator.getMassMatrix());
            MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(1.0E-7);
            integrator.integrateFromVelocitySubtree((RigidBodyBasics)elevator);
            robot.getElevator().updateFramesRecursively();
            massMatrixCalculator.reset();
            massMatrix1.set((DMatrixD1)massMatrixCalculator.getMassMatrix());
            CommonOps_DDRM.subtract((DMatrixD1)massMatrix1, (DMatrixD1)massMatrix0, (DMatrixD1)massMatrixDot);
            CommonOps_DDRM.scale((double)1.0E7, (DMatrixD1)massMatrixDot);
            DMatrixRMaj coriolisMatrix = new DMatrixRMaj(0);
            DMatrixRMaj coriolisMatrixTranspose = new DMatrixRMaj(0);
            DMatrixRMaj coriolisSum = new DMatrixRMaj(0);
            coriolisMatrix.set((DMatrixD1)massMatrixCalculator.getCoriolisMatrix());
            coriolisMatrixTranspose.set((DMatrixD1)coriolisMatrix);
            CommonOps_DDRM.transpose((DMatrixRMaj)coriolisMatrixTranspose);
            CommonOps_DDRM.add((DMatrixD1)coriolisMatrix, (DMatrixD1)coriolisMatrixTranspose, (DMatrixD1)coriolisSum);
            DMatrixRMaj error = new DMatrixRMaj(0);
            CommonOps_DDRM.subtract((DMatrixD1)coriolisSum, (DMatrixD1)massMatrixDot, (DMatrixD1)error);
            for (int j = 0; j < error.getNumElements(); ++j) {
                Assertions.assertTrue((Math.abs(error.get(j)) < 1.0E-4 ? 1 : 0) != 0, (String)("Invalid factorization found for serial chain with " + numberOfJoints + " one dof joints. Error term of " + error.get(j)));
            }
        }
    }
}

