/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.spatial;

import java.util.Random;
import org.ejml.EjmlUnitTests;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.WrenchTest;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionTest;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MecanoTools;

public class TwistTest
extends SpatialMotionTest<Twist> {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Override
    public Twist createSpatialMotionVector(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        return new Twist(bodyFrame, baseFrame, expressedInFrame, angularPart, linearPart);
    }

    @Override
    public Twist createSpatialMotionVector(ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame, DMatrixRMaj matrix) {
        return new Twist(bodyFrame, baseFrame, expressedInFrame, (DMatrix)matrix);
    }

    @Test
    public void testConstructionAndGettersAndSetters() {
        Vector3D angularVelocity = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Vector3D linearVelocity = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Twist twist = new Twist(this.frameB, this.frameA, this.frameC, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity);
        double epsilon = 1.0E-14;
        FixedFrameVector3DBasics angularVelocity2 = twist.getAngularPart();
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)angularVelocity, (Tuple3DReadOnly)angularVelocity2, (double)epsilon);
        FixedFrameVector3DBasics linearVelocity2 = twist.getLinearPart();
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)linearVelocity, (Tuple3DReadOnly)linearVelocity2, (double)epsilon);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)angularVelocity, (Tuple3DReadOnly)angularVelocity2, (double)epsilon);
        Vector3D angularVelocity3 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        twist.getAngularPart().set((Tuple3DReadOnly)angularVelocity3);
        Vector3D linearVelocity3 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        twist.getLinearPart().set((Tuple3DReadOnly)linearVelocity3);
        FixedFrameVector3DBasics angularVelocity4 = twist.getAngularPart();
        FixedFrameVector3DBasics linearVelocity4 = twist.getLinearPart();
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)angularVelocity3, (Tuple3DReadOnly)angularVelocity4, (double)epsilon);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)linearVelocity3, (Tuple3DReadOnly)linearVelocity4, (double)epsilon);
    }

    @Test
    public void testDefaultConstructor() {
        Twist twist = new Twist();
        Assertions.assertNull((Object)twist.getBaseFrame());
        Assertions.assertNull((Object)twist.getBodyFrame());
        Assertions.assertNull((Object)twist.getReferenceFrame());
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(), (Tuple3DReadOnly)twist.getAngularPart(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(), (Tuple3DReadOnly)twist.getLinearPart(), (double)0.0);
    }

    @Test
    public void testConstructUsingArray() {
        double[] array = new double[6];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.random.nextDouble();
        }
        Twist twist = new Twist(this.frameC, this.frameD, this.frameA, array);
        DMatrixRMaj matrixBack = new DMatrixRMaj(6, 1);
        twist.get((DMatrix)matrixBack);
        double[] arrayBack = matrixBack.getData();
        Assertions.assertArrayEquals((double[])array, (double[])arrayBack);
    }

    @Test
    public void testConstructUsingArrayTooSmall() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double[] array = new double[5];
            new Twist(this.frameC, this.frameD, this.frameA, array);
        });
    }

    @Test
    public void testCopyConstructor() {
        DMatrixRMaj inputMatrix = RandomMatrices_DDRM.rectangle((int)6, (int)1, (Random)this.random);
        Twist twist = new Twist(this.frameC, this.frameD, this.frameA, (DMatrix)inputMatrix);
        Twist twistCopy = new Twist((SpatialMotionReadOnly)twist);
        DMatrixRMaj twistMatrix = new DMatrixRMaj(6, 1);
        twist.get((DMatrix)twistMatrix);
        DMatrixRMaj twistCopyMatrix = new DMatrixRMaj(6, 1);
        twistCopy.get((DMatrix)twistCopyMatrix);
        EjmlUnitTests.assertEquals((DMatrix)twistMatrix, (DMatrix)twistCopyMatrix, (double)0.0);
        Assertions.assertEquals((Object)twist.getBodyFrame(), (Object)twistCopy.getBodyFrame());
        Assertions.assertEquals((Object)twist.getReferenceFrame(), (Object)twistCopy.getReferenceFrame());
        Assertions.assertEquals((Object)twist.getBaseFrame(), (Object)twistCopy.getBaseFrame());
        inputMatrix = RandomMatrices_DDRM.rectangle((int)6, (int)1, (Random)this.random);
        twist.setIncludingFrame(this.frameD, this.frameA, this.frameC, (DMatrix)inputMatrix);
        twist.get((DMatrix)twistMatrix);
        twistCopy.get((DMatrix)twistCopyMatrix);
        for (int i = 0; i < twistMatrix.getNumElements(); ++i) {
            if (twistMatrix.get(i) != twistCopyMatrix.get(i)) continue;
            Assertions.fail();
        }
        Assertions.assertNotSame((Object)twist.getBodyFrame(), (Object)twistCopy.getBodyFrame());
        Assertions.assertNotSame((Object)twist.getReferenceFrame(), (Object)twistCopy.getReferenceFrame());
        Assertions.assertNotSame((Object)twist.getBaseFrame(), (Object)twistCopy.getBaseFrame());
    }

    @Test
    public void testDotProduct() {
        WrenchTest.testDotProduct(this.frameA, this.frameB, this.frameC);
    }

    @Test
    public void testDotProductNotAllowed1() {
        Assertions.assertThrows(RuntimeException.class, () -> WrenchTest.testDotProductNotAllowed1(this.frameA, this.frameB, this.frameC));
    }

    @Test
    public void testDotProductNotAllowed2() {
        Assertions.assertThrows(RuntimeException.class, () -> WrenchTest.testDotProductNotAllowed2(this.frameA, this.frameB, this.frameC));
    }

    @Test
    public void testAddExpressedInDifferentFrames() {
        Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
            Twist twist1 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameC, (Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)new Vector3D());
            Twist twist2 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameA, (Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)new Vector3D());
            twist1.add((TwistReadOnly)twist2);
        });
    }

    @Test
    public void testAddNotRelative() {
        Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> {
            Twist twist1 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameC, (Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)new Vector3D());
            Twist twist2 = this.createSpatialMotionVector(this.frameB, this.frameA, this.frameC, (Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)new Vector3D());
            twist1.add((TwistReadOnly)twist2);
        });
    }

    @Test
    public void testAdd() {
        Vector3D angularVelocity1 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Vector3D linearVelocity1 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Twist twist1 = new Twist(this.frameB, this.frameA, this.frameD, (Vector3DReadOnly)angularVelocity1, (Vector3DReadOnly)linearVelocity1);
        Vector3D angularVelocity2 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Vector3D linearVelocity2 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Twist twist2 = new Twist(this.frameC, this.frameB, this.frameD, (Vector3DReadOnly)angularVelocity2, (Vector3DReadOnly)linearVelocity2);
        twist1.add((TwistReadOnly)twist2);
        Assertions.assertEquals((Object)this.frameD, (Object)twist1.getReferenceFrame());
        Assertions.assertEquals((Object)this.frameA, (Object)twist1.getBaseFrame());
        Assertions.assertEquals((Object)this.frameC, (Object)twist1.getBodyFrame());
        angularVelocity1.add((Tuple3DReadOnly)angularVelocity2);
        linearVelocity1.add((Tuple3DReadOnly)linearVelocity2);
        double epsilon = 1.0E-14;
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)angularVelocity1, (Tuple3DReadOnly)twist1.getAngularPart(), (double)epsilon);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)linearVelocity1, (Tuple3DReadOnly)twist1.getLinearPart(), (double)epsilon);
        twist1 = new Twist(this.frameB, this.frameA, this.frameD, (Vector3DReadOnly)angularVelocity1, (Vector3DReadOnly)linearVelocity1);
        twist2 = new Twist(this.frameC, this.frameB, this.frameD, (Vector3DReadOnly)angularVelocity2, (Vector3DReadOnly)linearVelocity2);
        try {
            twist2.add((TwistReadOnly)twist1);
            throw new RuntimeException("Should not be able to add in this direction");
        }
        catch (Exception exception) {
            twist1 = new Twist(this.frameB, this.frameA, this.frameD, (Vector3DReadOnly)angularVelocity1, (Vector3DReadOnly)linearVelocity1);
            try {
                twist1.add((TwistReadOnly)twist1);
                throw new RuntimeException("Should not be able to add in this direction");
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    @Test
    public void testSub() {
        Random random = new Random(3454L);
        Twist twist1 = new Twist(this.frameB, this.frameA, this.frameD, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        Twist twist2 = new Twist(this.frameC, this.frameB, this.frameD, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        Twist twist3 = new Twist((SpatialMotionReadOnly)twist1);
        twist3.add((TwistReadOnly)twist2);
        double epsilon = 1.0E-15;
        Twist twist2Back = new Twist((SpatialMotionReadOnly)twist3);
        twist2Back.sub((TwistReadOnly)twist1);
        MecanoTestTools.assertTwistEquals((TwistReadOnly)twist2, (TwistReadOnly)twist2Back, (double)epsilon);
        Twist twist1Back = new Twist((SpatialMotionReadOnly)twist3);
        twist1Back.sub((TwistReadOnly)twist2);
        MecanoTestTools.assertTwistEquals((TwistReadOnly)twist1, (TwistReadOnly)twist1Back, (double)epsilon);
    }

    @Test
    public void testSubWrongExpressedInFrame() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            Twist twist1 = new Twist(this.frameB, this.frameA, this.frameD);
            Twist twist2 = new Twist(this.frameB, this.frameC, this.frameC);
            twist1.sub((TwistReadOnly)twist2);
        });
    }

    @Test
    public void testSubFramesDontMatchUp() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            Twist twist1 = new Twist(this.frameD, this.frameA, this.frameC);
            Twist twist2 = new Twist(this.frameB, this.frameC, this.frameC);
            twist1.sub((TwistReadOnly)twist2);
        });
    }

    @Test
    public void testChangeFrame() {
        int nTests = 100;
        for (int i = 0; i < nTests; ++i) {
            Vector3D angularVelocity1 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
            Vector3D linearVelocity1 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
            Twist twist1 = new Twist(this.frameB, this.frameA, this.frameA, (Vector3DReadOnly)angularVelocity1, (Vector3DReadOnly)linearVelocity1);
            DMatrixRMaj twist1TildeInA = TwistTest.toTildeForm(twist1);
            RigidBodyTransform transformFromAToC = this.frameA.getTransformToDesiredFrame(this.frameC);
            DMatrixRMaj transformFromAToCMatrix = new DMatrixRMaj(4, 4);
            transformFromAToC.get((DMatrix)transformFromAToCMatrix);
            DMatrixRMaj transformFromAToCMatrixInv = new DMatrixRMaj(transformFromAToCMatrix);
            CommonOps_DDRM.invert((DMatrixRMaj)transformFromAToCMatrixInv);
            DMatrixRMaj twist1TildeInC = new DMatrixRMaj(transformFromAToCMatrix);
            DMatrixRMaj temp = new DMatrixRMaj(transformFromAToCMatrix);
            CommonOps_DDRM.mult((DMatrix1Row)twist1TildeInC, (DMatrix1Row)twist1TildeInA, (DMatrix1Row)temp);
            CommonOps_DDRM.mult((DMatrix1Row)temp, (DMatrix1Row)transformFromAToCMatrixInv, (DMatrix1Row)twist1TildeInC);
            Vector3D omega1InC = new Vector3D();
            Vector3D v1InC = new Vector3D();
            TwistTest.fromTildeForm(twist1TildeInC, omega1InC, v1InC);
            twist1.changeFrame(this.frameC);
            Assertions.assertEquals((Object)this.frameC, (Object)twist1.getReferenceFrame());
            FixedFrameVector3DBasics omega1InC2 = twist1.getAngularPart();
            FixedFrameVector3DBasics v1InC2 = twist1.getLinearPart();
            double epsilon = 1.0E-8;
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)omega1InC, (Tuple3DReadOnly)omega1InC2, (double)epsilon);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)v1InC, (Tuple3DReadOnly)v1InC2, (double)epsilon);
        }
    }

    @Test
    public void testChangeFrameSameFrame() {
        Vector3D angularVelocity1 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Vector3D linearVelocity1 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Twist twist1 = new Twist(this.frameB, this.frameA, this.frameA, (Vector3DReadOnly)angularVelocity1, (Vector3DReadOnly)linearVelocity1);
        Twist twist2 = new Twist((SpatialMotionReadOnly)twist1);
        twist1.changeFrame(twist1.getReferenceFrame());
        DMatrixRMaj twist1Matrix = new DMatrixRMaj(6, 1);
        twist1.get((DMatrix)twist1Matrix);
        DMatrixRMaj twist2Matrix = new DMatrixRMaj(6, 1);
        twist2.get((DMatrix)twist2Matrix);
        EjmlUnitTests.assertEquals((DMatrix)twist1Matrix, (DMatrix)twist2Matrix, (double)0.0);
        Assertions.assertEquals((Object)twist1.getBodyFrame(), (Object)twist2.getBodyFrame());
        Assertions.assertEquals((Object)twist1.getReferenceFrame(), (Object)twist2.getReferenceFrame());
        Assertions.assertEquals((Object)twist1.getBaseFrame(), (Object)twist2.getBaseFrame());
    }

    @Test
    public void testGetMatrix() {
        Vector3D angularVelocity1 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Vector3D linearVelocity1 = new Vector3D(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble());
        Twist twist1 = new Twist(this.frameB, this.frameA, this.frameA, (Vector3DReadOnly)angularVelocity1, (Vector3DReadOnly)linearVelocity1);
        DMatrixRMaj twistMatrix = new DMatrixRMaj(6, 1);
        twist1.get((DMatrix)twistMatrix);
        double epsilon = 1.0E-14;
        Assertions.assertEquals((double)angularVelocity1.getX(), (double)twistMatrix.get(0, 0), (double)epsilon);
        Assertions.assertEquals((double)angularVelocity1.getY(), (double)twistMatrix.get(1, 0), (double)epsilon);
        Assertions.assertEquals((double)angularVelocity1.getZ(), (double)twistMatrix.get(2, 0), (double)epsilon);
        Assertions.assertEquals((double)linearVelocity1.getX(), (double)twistMatrix.get(3, 0), (double)epsilon);
        Assertions.assertEquals((double)linearVelocity1.getY(), (double)twistMatrix.get(4, 0), (double)epsilon);
        Assertions.assertEquals((double)linearVelocity1.getZ(), (double)twistMatrix.get(5, 0), (double)epsilon);
    }

    @Test
    public void testGetLinearVelocityOfPointFixedInBodyFrameComputedInDifferentFrames() throws Exception {
        Random random = new Random(4354L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
            ReferenceFrame baseFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"baseFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            ReferenceFrame bodyFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"bodyFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            Vector3D linearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            Vector3D angularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            Twist twist = new Twist(bodyFrame, baseFrame, bodyFrame, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)linearVelocity);
            FramePoint3D pointFixedInBodyFrame = new FramePoint3D(bodyFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0));
            FrameVector3D bodyFixedPointLinearVelocityInBody = new FrameVector3D();
            FrameVector3D bodyFixedPointLinearVelocityInBase = new FrameVector3D();
            pointFixedInBodyFrame.changeFrame(bodyFrame);
            twist.changeFrame(bodyFrame);
            twist.getLinearVelocityAt((FramePoint3DReadOnly)pointFixedInBodyFrame, (FrameVector3DBasics)bodyFixedPointLinearVelocityInBody);
            pointFixedInBodyFrame.changeFrame(baseFrame);
            twist.changeFrame(baseFrame);
            twist.getLinearVelocityAt((FramePoint3DReadOnly)pointFixedInBodyFrame, (FrameVector3DBasics)bodyFixedPointLinearVelocityInBase);
            bodyFixedPointLinearVelocityInBody.changeFrame(baseFrame);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)bodyFixedPointLinearVelocityInBase, (Tuple3DReadOnly)bodyFixedPointLinearVelocityInBody, (double)1.0E-12);
        }
    }

    @Test
    public void testGetLinearVelocityAt() {
        Random random = new Random(4788L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame expressedInFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame bodyFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame frameAtObserverPosition = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Twist twist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)bodyFrame, (ReferenceFrame)ReferenceFrame.getWorldFrame(), (ReferenceFrame)expressedInFrame);
            FramePoint3D observerPosition = new FramePoint3D(frameAtObserverPosition);
            observerPosition.changeFrame(expressedInFrame);
            FrameVector3D actualLinearVelocity = new FrameVector3D();
            twist.getLinearVelocityAt((FramePoint3DReadOnly)observerPosition, (FrameVector3DBasics)actualLinearVelocity);
            FrameVector3D expectedLinearVelocity = new FrameVector3D();
            twist.changeFrame(frameAtObserverPosition);
            expectedLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)twist.getLinearPart());
            expectedLinearVelocity.changeFrame(expressedInFrame);
            EuclidFrameTestTools.assertFrameTuple3DEquals((FrameTuple3DReadOnly)expectedLinearVelocity, (FrameTuple3DReadOnly)actualLinearVelocity, (double)1.0E-12);
            Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> twist.getLinearVelocityAt((FramePoint3DReadOnly)new FramePoint3D(EuclidFrameRandomTools.nextReferenceFrame((Random)random)), (FrameVector3DBasics)new FrameVector3D()));
        }
    }

    private static DMatrixRMaj toTildeForm(Twist twist) {
        FixedFrameVector3DBasics angularVelocity = twist.getAngularPart();
        FixedFrameVector3DBasics linearVelocity = twist.getLinearPart();
        DMatrixRMaj ret = new DMatrixRMaj(4, 4);
        MecanoTools.toTildeForm((Tuple3DReadOnly)angularVelocity, (int)0, (int)0, (DMatrix)ret);
        ret.set(0, 3, linearVelocity.getX());
        ret.set(1, 3, linearVelocity.getY());
        ret.set(2, 3, linearVelocity.getZ());
        return ret;
    }

    private static void fromTildeForm(DMatrixRMaj twistTilde, Vector3D angularVelocityToPack, Vector3D linearVelocityToPack) {
        linearVelocityToPack.set(twistTilde.get(0, 3), twistTilde.get(1, 3), twistTilde.get(2, 3));
        angularVelocityToPack.set(twistTilde.get(2, 1), twistTilde.get(0, 2), twistTilde.get(1, 0));
    }
}

