/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.mecano.algorithms.CompositeRigidBodyMassMatrixCalculator;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.algorithms.InverseDynamicsCalculator;
import us.ihmc.mecano.algorithms.SpatialAccelerationCalculator;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class ForwardDynamicsCalculatorTest {
    private static final int ITERATIONS = 500;
    private static final double ONE_DOF_JOINT_EPSILON = 8.0E-12;
    private static final double FLOATING_JOINT_EPSILON = 4.0E-11;
    private static final double ALL_JOINT_EPSILON = 1.0E-4;

    @Test
    public void testPrismaticJointChain() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextPrismaticJointChain((Random)random, (int)numberOfJoints);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstSpatialAccelerationCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
        }
    }

    @Test
    public void testPrismaticJointTree() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextPrismaticJointTree((Random)random, (int)numberOfJoints);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstSpatialAccelerationCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
        }
    }

    @Test
    public void testRevoluteJointChain() throws Exception {
        Random random = new Random(2654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 1.6E-11);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, 0, joints, 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 1.6E-11);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 1.6E-11);
            ForwardDynamicsCalculatorTest.compareAgainstSpatialAccelerationCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
        }
    }

    @Test
    public void testRevoluteJointTree() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextRevoluteJointTree((Random)random, (int)numberOfJoints);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 1.6E-11);
            ForwardDynamicsCalculatorTest.compareAgainstSpatialAccelerationCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
        }
    }

    @Test
    public void testOneDoFJointChain() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstSpatialAccelerationCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
        }
    }

    @Test
    public void testOneDoFJointTree() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)numberOfJoints);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 8.0E-12);
            ForwardDynamicsCalculatorTest.compareAgainstSpatialAccelerationCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 8.0E-12);
        }
    }

    @Test
    public void testFloatingRevoluteJointChain() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(40) + 1;
            List joints = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, numberOfJoints).getJoints();
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 4.0E-11);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, 4.0E-11);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 4.0E-11);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 4.0E-11);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 8.0E-11);
            ForwardDynamicsCalculatorTest.compareAgainstSpatialAccelerationCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 4.0E-11);
        }
    }

    @Test
    public void testJointChain() throws Exception {
        Random random = new Random(21654L);
        for (int i = 0; i < 500; ++i) {
            int numberOfJoints = random.nextInt(40) + 1;
            List joints = MultiBodySystemRandomTools.nextJointChain((Random)random, (int)numberOfJoints);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.emptyList(), 1.0E-4);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, 1.0E-4);
            ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, i, joints, Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 1.0E-4);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 1.0E-4);
            ForwardDynamicsCalculatorTest.compareAgainstInverseDynamicsCalculator(random, i, joints, Collections.emptyMap(), Collections.singletonList(joints.get(random.nextInt(numberOfJoints))), 1.0E-4);
            ForwardDynamicsCalculatorTest.compareAgainstSpatialAccelerationCalculator(random, i, joints, ForwardDynamicsCalculatorTest.nextExternalWrenches(random, joints), Collections.emptyList(), 1.0E-4);
        }
    }

    private static void compareAgainstInverseDynamicsCalculator(Random random, int iteration, List<? extends JointBasics> joints, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.ACCELERATION, joints);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator(multiBodySystemInput);
        inverseDynamicsCalculator.setGravitionalAcceleration(gravity);
        ForwardDynamicsCalculator forwardDynamicsCalculator = new ForwardDynamicsCalculator(multiBodySystemInput);
        forwardDynamicsCalculator.setGravitionalAcceleration(gravity);
        int numberOfDoFs = joints.stream().mapToInt(JointReadOnly::getDegreesOfFreedom).sum();
        DMatrixRMaj qdd_expected = new DMatrixRMaj(numberOfDoFs, 1);
        int index = 0;
        for (JointBasics jointBasics : joints) {
            jointBasics.getJointAcceleration(index, (DMatrix)qdd_expected);
            index += jointBasics.getDegreesOfFreedom();
        }
        externalWrenches.forEach((arg_0, arg_1) -> ((InverseDynamicsCalculator)inverseDynamicsCalculator).setExternalWrench(arg_0, arg_1));
        inverseDynamicsCalculator.compute();
        inverseDynamicsCalculator.writeComputedJointWrenches(joints);
        externalWrenches.forEach((arg_0, arg_1) -> ((ForwardDynamicsCalculator)forwardDynamicsCalculator).setExternalWrench(arg_0, arg_1));
        forwardDynamicsCalculator.compute();
        joints.forEach(arg_0 -> ((ForwardDynamicsCalculator)forwardDynamicsCalculator).writeComputedJointAcceleration(arg_0));
        DMatrixRMaj qdd_actual = new DMatrixRMaj(numberOfDoFs, 1);
        index = 0;
        for (JointBasics jointBasics : joints) {
            jointBasics.getJointAcceleration(index, (DMatrix)qdd_actual);
            index += jointBasics.getDegreesOfFreedom();
        }
        boolean bl = MatrixFeatures_DDRM.isEquals((DMatrixD1)qdd_expected, (DMatrixD1)qdd_actual, (double)epsilon);
        if (!bl) {
            System.out.println("iteration: " + iteration);
            double d = 0.0;
            DMatrixRMaj output = new DMatrixRMaj(numberOfDoFs, 3);
            for (int row = 0; row < numberOfDoFs; ++row) {
                output.set(row, 0, qdd_expected.get(row, 0));
                output.set(row, 1, qdd_actual.get(row, 0));
                double error = qdd_expected.get(row, 0) - qdd_actual.get(row, 0);
                output.set(row, 2, error);
                d = Math.max(d, Math.abs(error));
            }
            output.print(EuclidCoreIOTools.getStringFormat((int)9, (int)6));
            System.out.println("Max error: " + d);
        }
        Assertions.assertTrue((boolean)bl);
        List list = rootBody.subtreeList();
        for (RigidBodyReadOnly rigidBody : list) {
            SpatialAccelerationReadOnly expectedAccelerationOfBody = inverseDynamicsCalculator.getAccelerationProvider().getAccelerationOfBody(rigidBody);
            if (expectedAccelerationOfBody == null) {
                Assertions.assertNull((Object)forwardDynamicsCalculator.getAccelerationProvider().getAccelerationOfBody(rigidBody));
                continue;
            }
            SpatialAcceleration actualAccelerationOfBody = new SpatialAcceleration((SpatialMotionReadOnly)forwardDynamicsCalculator.getAccelerationProvider().getAccelerationOfBody(rigidBody));
            actualAccelerationOfBody.changeFrame(expectedAccelerationOfBody.getReferenceFrame());
            MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedAccelerationOfBody, (SpatialAccelerationReadOnly)actualAccelerationOfBody, (double)epsilon);
            for (int i = 0; i < 5; ++i) {
                RigidBodyBasics otherRigidBody = (RigidBodyBasics)list.get(random.nextInt(list.size()));
                SpatialAccelerationReadOnly expectedRelativeAcceleration = inverseDynamicsCalculator.getAccelerationProvider().getRelativeAcceleration(rigidBody, (RigidBodyReadOnly)otherRigidBody);
                if (expectedAccelerationOfBody == null) {
                    Assertions.assertNull((Object)forwardDynamicsCalculator.getAccelerationProvider().getRelativeAcceleration((RigidBodyReadOnly)otherRigidBody, rigidBody));
                    continue;
                }
                SpatialAccelerationReadOnly actualRelativeAcceleration = forwardDynamicsCalculator.getAccelerationProvider().getRelativeAcceleration(rigidBody, (RigidBodyReadOnly)otherRigidBody);
                MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedRelativeAcceleration, (SpatialAccelerationReadOnly)actualRelativeAcceleration, (double)epsilon);
            }
        }
    }

    private static void compareAgainstCompositeRigidBodyMassMatrixCalculator(Random random, int iteration, List<? extends JointBasics> joints, double epsilon) {
        ForwardDynamicsCalculatorTest.compareAgainstCompositeRigidBodyMassMatrixCalculator(random, iteration, joints, Collections.emptyList(), epsilon);
    }

    private static void compareAgainstCompositeRigidBodyMassMatrixCalculator(Random random, int iteration, List<? extends JointBasics> joints, List<? extends JointBasics> jointsToIgnore, double epsilon) {
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.ACCELERATION, joints);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        rootBody.updateFramesRecursively();
        MultiBodySystemBasics input = MultiBodySystemBasics.toMultiBodySystemBasics((RigidBodyBasics)rootBody, jointsToIgnore);
        int numberOfDoFs = MultiBodySystemTools.computeDegreesOfFreedom((List)input.getJointsToConsider());
        DMatrixRMaj qdd_expected = new DMatrixRMaj(numberOfDoFs, 1);
        int index = 0;
        for (JointBasics joint : input.getJointsToConsider()) {
            joint.getJointAcceleration(index, (DMatrix)qdd_expected);
            joint.setJointAccelerationToZero();
            index += joint.getDegreesOfFreedom();
        }
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        InverseDynamicsCalculator inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)input);
        inverseDynamicsCalculator.setGravitionalAcceleration(gravity);
        CompositeRigidBodyMassMatrixCalculator massMatrixCalculator = new CompositeRigidBodyMassMatrixCalculator((MultiBodySystemReadOnly)input);
        inverseDynamicsCalculator.compute();
        massMatrixCalculator.reset();
        inverseDynamicsCalculator.writeComputedJointWrenches(joints);
        DMatrixRMaj massMatrix = massMatrixCalculator.getMassMatrix();
        DMatrixRMaj biasMatrix = new DMatrixRMaj(numberOfDoFs, 1);
        index = 0;
        for (Object joint : input.getJointsToConsider()) {
            joint.getJointTau(index, (DMatrix)biasMatrix);
            index += joint.getDegreesOfFreedom();
        }
        DMatrixRMaj tauMatrix = new DMatrixRMaj(numberOfDoFs, 1);
        CommonOps_DDRM.mult((DMatrix1Row)massMatrix, (DMatrix1Row)qdd_expected, (DMatrix1Row)tauMatrix);
        CommonOps_DDRM.addEquals((DMatrixD1)tauMatrix, (DMatrixD1)biasMatrix);
        index = 0;
        for (JointBasics joint : input.getJointsToConsider()) {
            joint.setJointTau(index, (DMatrix)tauMatrix);
            index += joint.getDegreesOfFreedom();
        }
        ForwardDynamicsCalculator forwardDynamicsCalculator = new ForwardDynamicsCalculator((MultiBodySystemReadOnly)input);
        forwardDynamicsCalculator.setGravitionalAcceleration(gravity);
        forwardDynamicsCalculator.compute();
        DMatrixRMaj qdd_actual = forwardDynamicsCalculator.getJointAccelerationMatrix();
        boolean areEqual = MatrixFeatures_DDRM.isEquals((DMatrixD1)qdd_expected, (DMatrixD1)qdd_actual, (double)epsilon);
        if (!areEqual) {
            System.out.println("iteration: " + iteration);
            double maxError = 0.0;
            DMatrixRMaj output = new DMatrixRMaj(numberOfDoFs, 3);
            for (int row = 0; row < numberOfDoFs; ++row) {
                output.set(row, 0, qdd_expected.get(row, 0));
                output.set(row, 1, qdd_actual.get(row, 0));
                double error = qdd_expected.get(row, 0) - qdd_actual.get(row, 0);
                output.set(row, 2, error);
                maxError = Math.max(maxError, Math.abs(error));
            }
            output.print(EuclidCoreIOTools.getStringFormat((int)9, (int)6));
            System.out.println("Max error: " + maxError);
        }
        Assertions.assertTrue((boolean)areEqual);
    }

    private static void compareAgainstSpatialAccelerationCalculator(Random random, int iteration, List<? extends JointBasics> joints, Map<RigidBodyReadOnly, WrenchReadOnly> externalWrenches, List<? extends JointReadOnly> jointsToIgnore, double epsilon) {
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.ACCELERATION, joints);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joints.get(0).getPredecessor());
        MultiBodySystemReadOnly multiBodySystemInput = MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody, jointsToIgnore);
        rootBody.updateFramesRecursively();
        double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)-1.0);
        ForwardDynamicsCalculator forwardDynamicsCalculator = new ForwardDynamicsCalculator(multiBodySystemInput);
        forwardDynamicsCalculator.setGravitionalAcceleration(gravity);
        externalWrenches.forEach((arg_0, arg_1) -> ((ForwardDynamicsCalculator)forwardDynamicsCalculator).setExternalWrench(arg_0, arg_1));
        forwardDynamicsCalculator.compute();
        joints.forEach(arg_0 -> ((ForwardDynamicsCalculator)forwardDynamicsCalculator).writeComputedJointAcceleration(arg_0));
        RigidBodyAccelerationProvider fwdDynAccelerationProvider = forwardDynamicsCalculator.getAccelerationProvider();
        RigidBodyAccelerationProvider fwdDynZeroVelocityAccelerationProvider = forwardDynamicsCalculator.getAccelerationProvider(false);
        Assertions.assertTrue((boolean)fwdDynAccelerationProvider.areAccelerationsConsidered());
        Assertions.assertTrue((boolean)fwdDynAccelerationProvider.areVelocitiesConsidered());
        Assertions.assertTrue((boolean)fwdDynZeroVelocityAccelerationProvider.areAccelerationsConsidered());
        Assertions.assertFalse((boolean)fwdDynZeroVelocityAccelerationProvider.areVelocitiesConsidered());
        SpatialAccelerationCalculator accelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)rootBody, multiBodySystemInput.getInertialFrame());
        SpatialAccelerationCalculator zeroVelocityAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)rootBody, multiBodySystemInput.getInertialFrame(), false);
        accelerationCalculator.setGravitionalAcceleration(gravity);
        zeroVelocityAccelerationCalculator.setGravitionalAcceleration(gravity);
        List allRigidBodies = rootBody.subtreeList();
        for (RigidBodyReadOnly rigidBody : allRigidBodies) {
            SpatialAccelerationReadOnly expectedAccelerationOfBody = accelerationCalculator.getAccelerationOfBody(rigidBody);
            SpatialAccelerationReadOnly expectedZeroVelocityAccelerationOfBody = zeroVelocityAccelerationCalculator.getAccelerationOfBody(rigidBody);
            if (expectedAccelerationOfBody == null) {
                Assertions.assertNull((Object)fwdDynAccelerationProvider.getAccelerationOfBody(rigidBody));
                Assertions.assertNull((Object)fwdDynZeroVelocityAccelerationProvider.getAccelerationOfBody(rigidBody));
                continue;
            }
            SpatialAcceleration actualAccelerationOfBody = new SpatialAcceleration((SpatialMotionReadOnly)fwdDynAccelerationProvider.getAccelerationOfBody(rigidBody));
            MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedAccelerationOfBody, (SpatialAccelerationReadOnly)actualAccelerationOfBody, (double)(Math.max(1.0, expectedAccelerationOfBody.length()) * epsilon));
            SpatialAcceleration actualZeroVelocityAccelerationOfBody = new SpatialAcceleration((SpatialMotionReadOnly)fwdDynZeroVelocityAccelerationProvider.getAccelerationOfBody(rigidBody));
            MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedZeroVelocityAccelerationOfBody, (SpatialAccelerationReadOnly)actualZeroVelocityAccelerationOfBody, (double)(Math.max(1.0, expectedZeroVelocityAccelerationOfBody.length()) * epsilon));
            for (int i = 0; i < 5; ++i) {
                RigidBodyBasics otherRigidBody = (RigidBodyBasics)allRigidBodies.get(random.nextInt(allRigidBodies.size()));
                SpatialAccelerationReadOnly expectedRelativeAcceleration = accelerationCalculator.getRelativeAcceleration(rigidBody, (RigidBodyReadOnly)otherRigidBody);
                SpatialAccelerationReadOnly expectedRelativeZeroVelocityAcceleration = zeroVelocityAccelerationCalculator.getRelativeAcceleration(rigidBody, (RigidBodyReadOnly)otherRigidBody);
                if (expectedAccelerationOfBody == null) {
                    Assertions.assertNull((Object)fwdDynAccelerationProvider.getRelativeAcceleration((RigidBodyReadOnly)otherRigidBody, rigidBody));
                    Assertions.assertNull((Object)fwdDynZeroVelocityAccelerationProvider.getRelativeAcceleration((RigidBodyReadOnly)otherRigidBody, rigidBody));
                    continue;
                }
                SpatialAccelerationReadOnly actualRelativeAcceleration = fwdDynAccelerationProvider.getRelativeAcceleration(rigidBody, (RigidBodyReadOnly)otherRigidBody);
                MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedRelativeAcceleration, (SpatialAccelerationReadOnly)actualRelativeAcceleration, (double)(Math.max(1.0, expectedRelativeAcceleration.length()) * epsilon));
                SpatialAccelerationReadOnly actualRelativeZeroVelocityAcceleration = fwdDynZeroVelocityAccelerationProvider.getRelativeAcceleration(rigidBody, (RigidBodyReadOnly)otherRigidBody);
                MecanoTestTools.assertSpatialAccelerationEquals((SpatialAccelerationReadOnly)expectedRelativeZeroVelocityAcceleration, (SpatialAccelerationReadOnly)actualRelativeZeroVelocityAcceleration, (double)(Math.max(1.0, expectedRelativeZeroVelocityAcceleration.length()) * epsilon));
            }
        }
    }

    public static Map<RigidBodyReadOnly, WrenchReadOnly> nextExternalWrenches(Random random, List<? extends JointReadOnly> joints) {
        return joints.stream().filter(j -> random.nextBoolean()).map(j -> j.getSuccessor()).collect(Collectors.toMap(b -> b, b -> MecanoRandomTools.nextWrench((Random)random, (ReferenceFrame)b.getBodyFixedFrame(), (ReferenceFrame)b.getBodyFixedFrame())));
    }
}

