/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.tools;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.tools.MomentOfInertiaFactory;

public class MomentOfInertiaFactoryTest {
    private static final int ITERATIONS = 1000;
    private static final int MAX_VALUE = 10;

    @Test
    public void testSolidCylinder() throws Exception {
        Random random = new Random(130375L);
        String type = "Solid Cylinder";
        for (int i = 0; i < 1000; ++i) {
            double randomMass = random.nextDouble();
            double randomRadius = random.nextDouble();
            double randomHeight = random.nextDouble();
            Vector3DReadOnly randomAxisOfCylinder = (Vector3DReadOnly)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])Axis3D.values);
            Matrix3D momentOfInertia = MomentOfInertiaFactory.solidCylinder((double)randomMass, (double)randomRadius, (double)randomHeight, (Vector3DReadOnly)randomAxisOfCylinder);
            MomentOfInertiaFactoryTest.assertGeneralInertiaProperties((Matrix3DReadOnly)momentOfInertia, type);
            MomentOfInertiaFactoryTest.assertThrowSolidCylinderNegativeValue(randomMass, -1.0 * randomRadius, randomHeight, randomAxisOfCylinder, type + " :negative radius did not throw Illegal Argument Exception");
            MomentOfInertiaFactoryTest.assertThrowSolidCylinderNegativeValue(randomMass, randomRadius, -1.0 * randomHeight, randomAxisOfCylinder, type + " :negative height did not throw Illegal Argument Exception");
            MomentOfInertiaFactoryTest.assertThrowSolidCylinderNegativeValue(-1.0 * randomMass, randomRadius, randomHeight, randomAxisOfCylinder, type + " :negative mass did not throw Illegal Argument Exception");
        }
    }

    @Test
    public void testSolidEllipsoid() throws Exception {
        double randomMass;
        int i;
        Random random = new Random(175521L);
        String type = "Solid Ellipsoid";
        for (i = 0; i < 1000; ++i) {
            randomMass = random.nextDouble();
            double randomXRadius = random.nextDouble();
            double randomYRadius = random.nextDouble();
            double randomZRadius = random.nextDouble();
            Matrix3D momentOfInertia = MomentOfInertiaFactory.solidEllipsoid((double)randomMass, (double)randomXRadius, (double)randomYRadius, (double)randomZRadius);
            Assertions.assertEquals((double)momentOfInertia.getM00(), (double)(0.2 * randomMass * (randomYRadius * randomYRadius + randomZRadius * randomZRadius)));
            Assertions.assertEquals((double)momentOfInertia.getM11(), (double)(0.2 * randomMass * (randomZRadius * randomZRadius + randomXRadius * randomXRadius)));
            Assertions.assertEquals((double)momentOfInertia.getM22(), (double)(0.2 * randomMass * (randomXRadius * randomXRadius + randomYRadius * randomYRadius)));
            MomentOfInertiaFactoryTest.assertGeneralInertiaProperties((Matrix3DReadOnly)momentOfInertia, type);
            MomentOfInertiaFactoryTest.assertThrowSolidEllipsoidNegativeValues(randomMass, -1.0 * randomXRadius, randomYRadius, randomZRadius, type + " :negative X radius did not throw Illegal Argument Exception");
            MomentOfInertiaFactoryTest.assertThrowSolidEllipsoidNegativeValues(randomMass, randomXRadius, -1.0 * randomYRadius, randomZRadius, type + " :negative Y radius did not throw Illegal Argument Exception");
            MomentOfInertiaFactoryTest.assertThrowSolidEllipsoidNegativeValues(randomMass, randomXRadius, randomYRadius, -1.0 * randomZRadius, type + " :negative Z radius did not throw Illegal Argument Exception");
            MomentOfInertiaFactoryTest.assertThrowSolidEllipsoidNegativeValues(-1.0 * randomMass, randomXRadius, randomYRadius, randomZRadius, type + " :negative mass did not throw Illegal Argument Exception");
        }
        for (i = 0; i < 1000; ++i) {
            randomMass = random.nextDouble();
            Vector3D randomRadii = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            Matrix3D momentOfInertia = MomentOfInertiaFactory.solidEllipsoid((double)randomMass, (Tuple3DReadOnly)randomRadii);
            Assertions.assertEquals((double)momentOfInertia.getM00(), (double)(0.2 * randomMass * (randomRadii.getY() * randomRadii.getY() + randomRadii.getZ() * randomRadii.getZ())));
            Assertions.assertEquals((double)momentOfInertia.getM11(), (double)(0.2 * randomMass * (randomRadii.getZ() * randomRadii.getZ() + randomRadii.getX() * randomRadii.getX())));
            Assertions.assertEquals((double)momentOfInertia.getM22(), (double)(0.2 * randomMass * (randomRadii.getX() * randomRadii.getX() + randomRadii.getY() * randomRadii.getY())));
            MomentOfInertiaFactoryTest.assertGeneralInertiaProperties((Matrix3DReadOnly)momentOfInertia, type);
            MomentOfInertiaFactoryTest.assertThrowSolidEllipsoidNegativeValues(-1.0 * randomMass, (Vector3DReadOnly)randomRadii, type + " :negative mass did not throw Illegal Argument Exception");
            Vector3D negRadii = new Vector3D(-1.0 * randomRadii.getX(), randomRadii.getY(), randomRadii.getZ());
            MomentOfInertiaFactoryTest.assertThrowSolidEllipsoidNegativeValues(randomMass, (Vector3DReadOnly)negRadii, type + " :negative X radii did not throw Illegal Argument Exception");
            negRadii = new Vector3D(randomRadii.getX(), -1.0 * randomRadii.getY(), randomRadii.getZ());
            MomentOfInertiaFactoryTest.assertThrowSolidEllipsoidNegativeValues(randomMass, (Vector3DReadOnly)negRadii, type + " :negative Y radii did not throw Illegal Argument Exception");
            negRadii = new Vector3D(randomRadii.getX(), randomRadii.getY(), -1.0 * randomRadii.getZ());
            MomentOfInertiaFactoryTest.assertThrowSolidEllipsoidNegativeValues(randomMass, (Vector3DReadOnly)negRadii, type + " :negative Y radii did not throw Illegal Argument Exception");
        }
    }

    @Test
    public void testSolidSphere() throws Exception {
        Random random = new Random(130125L);
        String type = "Solid Sphere";
        for (int i = 0; i < 1000; ++i) {
            double randomMass = random.nextDouble();
            double randomRadius = random.nextDouble();
            Matrix3D momentOfInertia = MomentOfInertiaFactory.solidSphere((double)randomMass, (double)randomRadius);
            Assertions.assertEquals((double)momentOfInertia.getM00(), (double)(0.4 * randomMass * randomRadius * randomRadius));
            Assertions.assertTrue((momentOfInertia.getM00() == momentOfInertia.getM11() && momentOfInertia.getM00() == momentOfInertia.getM22() ? 1 : 0) != 0);
            MomentOfInertiaFactoryTest.assertGeneralInertiaProperties((Matrix3DReadOnly)momentOfInertia, type);
            MomentOfInertiaFactoryTest.assertThrowSolidSphereNegativeValues(randomMass, -1.0 * randomRadius, type + " :negative radius did not throw Illegal Argument Exception");
            MomentOfInertiaFactoryTest.assertThrowSolidSphereNegativeValues(-1.0 * randomMass, randomRadius, type + " :negative mass did not throw Illegal Argument Exception");
        }
    }

    @Test
    public void testSolidBox() throws Exception {
        double randomMass;
        int i;
        Random random = new Random(160355L);
        String type = "Solid Box";
        for (i = 0; i < 1000; ++i) {
            randomMass = random.nextDouble();
            double randomXSize = random.nextDouble();
            double randomYSize = random.nextDouble();
            double randomZSize = random.nextDouble();
            Matrix3D momentOfInertia = MomentOfInertiaFactory.solidBox((double)randomMass, (double)randomXSize, (double)randomYSize, (double)randomZSize);
            Assertions.assertEquals((double)momentOfInertia.getM00(), (double)(randomMass / 12.0 * (randomYSize * randomYSize + randomZSize * randomZSize)));
            Assertions.assertEquals((double)momentOfInertia.getM11(), (double)(randomMass / 12.0 * (randomZSize * randomZSize + randomXSize * randomXSize)));
            Assertions.assertEquals((double)momentOfInertia.getM22(), (double)(randomMass / 12.0 * (randomXSize * randomXSize + randomYSize * randomYSize)));
            MomentOfInertiaFactoryTest.assertGeneralInertiaProperties((Matrix3DReadOnly)momentOfInertia, type);
            MomentOfInertiaFactoryTest.assertThrowSolidBoxNegativeValues(randomMass, -1.0 * randomXSize, randomYSize, randomZSize, type + " :negative X radus did not throw Illegal Argument Exception");
            MomentOfInertiaFactoryTest.assertThrowSolidBoxNegativeValues(randomMass, randomXSize, -1.0 * randomYSize, randomZSize, type + " :negative Y radus did not throw Illegal Argument Exception");
            MomentOfInertiaFactoryTest.assertThrowSolidBoxNegativeValues(randomMass, randomXSize, randomYSize, -1.0 * randomZSize, type + " :negative Z radus did not throw Illegal Argument Exception");
            MomentOfInertiaFactoryTest.assertThrowSolidBoxNegativeValues(-1.0 * randomMass, randomXSize, randomYSize, randomZSize, type + " :negative mass did not throw Illegal Argument Exception");
        }
        for (i = 0; i < 1000; ++i) {
            randomMass = random.nextDouble();
            Vector3D randomRadii = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            Matrix3D momentOfInertia = MomentOfInertiaFactory.solidBox((double)randomMass, (Tuple3DReadOnly)randomRadii);
            Assertions.assertEquals((double)momentOfInertia.getM00(), (double)(randomMass / 12.0 * (randomRadii.getY() * randomRadii.getY() + randomRadii.getZ() * randomRadii.getZ())));
            Assertions.assertEquals((double)momentOfInertia.getM11(), (double)(randomMass / 12.0 * (randomRadii.getZ() * randomRadii.getZ() + randomRadii.getX() * randomRadii.getX())));
            Assertions.assertEquals((double)momentOfInertia.getM22(), (double)(randomMass / 12.0 * (randomRadii.getX() * randomRadii.getX() + randomRadii.getY() * randomRadii.getY())));
            MomentOfInertiaFactoryTest.assertGeneralInertiaProperties((Matrix3DReadOnly)momentOfInertia, type);
            MomentOfInertiaFactoryTest.assertThrowSolidBoxNegativeValues(-1.0 * randomMass, (Vector3DReadOnly)randomRadii, type + " :negative mass did not throw Illegal Argument Exception");
            Vector3D negRadii = new Vector3D(-1.0 * randomRadii.getX(), randomRadii.getY(), randomRadii.getZ());
            MomentOfInertiaFactoryTest.assertThrowSolidBoxNegativeValues(randomMass, (Vector3DReadOnly)negRadii, type + " :negative X radii did not throw Illegal Argument Exception");
            negRadii = new Vector3D(randomRadii.getX(), -1.0 * randomRadii.getY(), randomRadii.getZ());
            MomentOfInertiaFactoryTest.assertThrowSolidBoxNegativeValues(randomMass, (Vector3DReadOnly)negRadii, type + " :negative Y radii did not throw Illegal Argument Exception");
            negRadii = new Vector3D(randomRadii.getX(), randomRadii.getY(), -1.0 * randomRadii.getZ());
            MomentOfInertiaFactoryTest.assertThrowSolidBoxNegativeValues(randomMass, (Vector3DReadOnly)negRadii, type + " :negative Z radii did not throw Illegal Argument Exception");
        }
    }

    @Test
    public void testFromMassAndRadiiOfGyration() throws Exception {
        Random random = new Random(12745L);
        String type = "From Mass and Radii of Gyration";
        for (int i = 0; i < 1000; ++i) {
            double randomMass = random.nextDouble();
            double randomRadiusOfGyrationX = random.nextDouble();
            double randomRadiusOfGyrationY = random.nextDouble();
            double randomRadiusOfGyrationZ = random.nextDouble();
            Matrix3D momentOfInertia = MomentOfInertiaFactory.fromMassAndRadiiOfGyration((double)randomMass, (double)randomRadiusOfGyrationX, (double)randomRadiusOfGyrationY, (double)randomRadiusOfGyrationZ);
            Assertions.assertEquals((double)momentOfInertia.getM00(), (double)(randomMass * (randomRadiusOfGyrationY * randomRadiusOfGyrationY + randomRadiusOfGyrationZ * randomRadiusOfGyrationZ)));
            Assertions.assertEquals((double)momentOfInertia.getM11(), (double)(randomMass * (randomRadiusOfGyrationZ * randomRadiusOfGyrationZ + randomRadiusOfGyrationX * randomRadiusOfGyrationX)));
            Assertions.assertEquals((double)momentOfInertia.getM22(), (double)(randomMass * (randomRadiusOfGyrationX * randomRadiusOfGyrationX + randomRadiusOfGyrationY * randomRadiusOfGyrationY)));
            MomentOfInertiaFactoryTest.assertGeneralInertiaProperties((Matrix3DReadOnly)momentOfInertia, type);
            MomentOfInertiaFactoryTest.assertThrowFromMassAndRadiiOfGyrationNegativeValues(randomMass, -1.0 * randomRadiusOfGyrationX, randomRadiusOfGyrationY, randomRadiusOfGyrationZ, type + " :negative X Radius of Gyration did not throw Illegal Argument Exception");
            MomentOfInertiaFactoryTest.assertThrowFromMassAndRadiiOfGyrationNegativeValues(randomMass, randomRadiusOfGyrationX, -1.0 * randomRadiusOfGyrationY, randomRadiusOfGyrationZ, type + " :negative Y Radius of Gyration did not throw Illegal Argument Exception");
            MomentOfInertiaFactoryTest.assertThrowFromMassAndRadiiOfGyrationNegativeValues(randomMass, randomRadiusOfGyrationX, randomRadiusOfGyrationY, -1.0 * randomRadiusOfGyrationZ, type + " :negative Z Radius of Gyration did not throw Illegal Argument Exception");
            MomentOfInertiaFactoryTest.assertThrowFromMassAndRadiiOfGyrationNegativeValues(-1.0 * randomMass, randomRadiusOfGyrationX, randomRadiusOfGyrationY, randomRadiusOfGyrationZ, type + " :negative mass did not throw Illegal Argument Exception");
        }
    }

    private static void assertGeneralInertiaProperties(Matrix3DReadOnly momentOfInertia, String type) {
        Assertions.assertTrue((momentOfInertia.getM00() + momentOfInertia.getM11() >= momentOfInertia.getM22() ? 1 : 0) != 0, (String)(type + " :General Inertia Property failed: M00 + M11 is not greater than or equal to M22."));
        Assertions.assertTrue((momentOfInertia.getM22() + momentOfInertia.getM00() >= momentOfInertia.getM11() ? 1 : 0) != 0, (String)(type + " :General Inertia Property failed: M22 + M00 is not greater than or equal to M11."));
        Assertions.assertTrue((momentOfInertia.getM11() + momentOfInertia.getM22() >= momentOfInertia.getM00() ? 1 : 0) != 0, (String)(type + " :General Inertia Property failed: M11 + M22 is not greater than or equal to M00."));
        Assertions.assertTrue((momentOfInertia.getM00() >= 0.0 && momentOfInertia.getM11() >= 0.0 && momentOfInertia.getM22() >= 0.0 ? 1 : 0) != 0, (String)(type + " :General Inertia Property failed: M00 or M11 or M22 is negative."));
        Assertions.assertTrue((momentOfInertia.getM01() == 0.0 && momentOfInertia.getM02() == 0.0 && momentOfInertia.getM10() == 0.0 && momentOfInertia.getM12() == 0.0 && momentOfInertia.getM20() == 0.0 && momentOfInertia.getM21() == 0.0 ? 1 : 0) != 0, (String)(type + " :One of the following values is not zero - M01, M02, M10, M12, M20, or M21"));
    }

    private static void assertThrowSolidCylinderNegativeValue(double randomMass, double randomRadius, double randomHeight, Vector3DReadOnly randomAxisOfCylinder, String errorMessage) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> MomentOfInertiaFactory.solidCylinder((double)randomMass, (double)randomRadius, (double)randomHeight, (Vector3DReadOnly)randomAxisOfCylinder), (String)errorMessage);
    }

    private static void assertThrowSolidEllipsoidNegativeValues(double randomMass, double randomXRadius, double randomYRadius, double randomZRadius, String errorMessage) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> MomentOfInertiaFactory.solidEllipsoid((double)randomMass, (double)randomXRadius, (double)randomYRadius, (double)randomZRadius), (String)errorMessage);
    }

    private static void assertThrowSolidEllipsoidNegativeValues(double randomMass, Vector3DReadOnly randomRadii, String errorMessage) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> MomentOfInertiaFactory.solidEllipsoid((double)randomMass, (Tuple3DReadOnly)randomRadii), (String)errorMessage);
    }

    private static void assertThrowSolidSphereNegativeValues(double randomMass, double randomRadius, String errorMessage) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> MomentOfInertiaFactory.solidSphere((double)randomMass, (double)randomRadius), (String)errorMessage);
    }

    private static void assertThrowSolidBoxNegativeValues(double randomMass, Vector3DReadOnly randomRadii, String errorMessage) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> MomentOfInertiaFactory.solidBox((double)randomMass, (Tuple3DReadOnly)randomRadii), (String)errorMessage);
    }

    private static void assertThrowSolidBoxNegativeValues(double randomMass, double randomXSize, double randomYSize, double randomZSize, String errorMessage) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> MomentOfInertiaFactory.solidBox((double)randomMass, (double)randomXSize, (double)randomYSize, (double)randomZSize), (String)errorMessage);
    }

    private static void assertThrowFromMassAndRadiiOfGyrationNegativeValues(double randomMass, double randomRadiusOfGyrationX, double randomRadiusOfGyrationY, double randomRadiusOfGyrationZ, String errorMessage) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> MomentOfInertiaFactory.fromMassAndRadiiOfGyration((double)randomMass, (double)randomRadiusOfGyrationX, (double)randomRadiusOfGyrationY, (double)randomRadiusOfGyrationZ), (String)errorMessage);
    }
}

