/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.mecano.algorithms;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.algorithms.FactorizedBodyInertia;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;

public class FactorizedBodyInertiaTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testSetFromInertiaAndTwist() {
        Random random = new Random(4366L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        for (int i = 0; i < 1000; ++i) {
            SpatialInertia spatialInertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)worldFrame, (ReferenceFrame)worldFrame);
            Twist bodyTwist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)worldFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)worldFrame);
            Wrench expectedWrench = new Wrench(worldFrame, worldFrame);
            spatialInertia.computeDynamicWrench(null, (TwistReadOnly)bodyTwist, (WrenchBasics)expectedWrench);
            FactorizedBodyInertia factorizedBodyInertia = new FactorizedBodyInertia(worldFrame);
            factorizedBodyInertia.setIncludingFrame((SpatialInertiaReadOnly)spatialInertia, (TwistReadOnly)bodyTwist);
            Wrench actualWrench = new Wrench(worldFrame, worldFrame);
            factorizedBodyInertia.getAngularInertia().transform((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DBasics)actualWrench.getAngularPart());
            factorizedBodyInertia.getTopRightInertia().addTransform((Tuple3DReadOnly)bodyTwist.getLinearPart(), (Tuple3DBasics)actualWrench.getAngularPart());
            factorizedBodyInertia.getLinearInertia().transform((Tuple3DReadOnly)bodyTwist.getLinearPart(), (Tuple3DBasics)actualWrench.getLinearPart());
            factorizedBodyInertia.getBottomLeftInertia().addTransform((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DBasics)actualWrench.getLinearPart());
            MecanoTestTools.assertWrenchEquals((WrenchReadOnly)expectedWrench, (WrenchReadOnly)actualWrench, (double)1.0E-12);
        }
    }

    @Test
    public void testApplyTransform() {
        Random random = new Random(4578L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            SpatialInertia spatialInertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)worldFrame, (ReferenceFrame)worldFrame);
            Twist bodyTwist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)worldFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)worldFrame);
            Wrench expectedWrench = new Wrench(worldFrame, worldFrame);
            spatialInertia.computeDynamicWrench(null, (TwistReadOnly)bodyTwist, (WrenchBasics)expectedWrench);
            expectedWrench.applyTransform((RigidBodyTransformReadOnly)transform);
            FactorizedBodyInertia factorizedBodyInertia = new FactorizedBodyInertia(worldFrame);
            factorizedBodyInertia.setIncludingFrame((SpatialInertiaReadOnly)spatialInertia, (TwistReadOnly)bodyTwist);
            factorizedBodyInertia.applyTransform(transform);
            bodyTwist.applyTransform((RigidBodyTransformReadOnly)transform);
            Wrench actualWrench = new Wrench(worldFrame, worldFrame);
            factorizedBodyInertia.getAngularInertia().transform((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DBasics)actualWrench.getAngularPart());
            factorizedBodyInertia.getTopRightInertia().addTransform((Tuple3DReadOnly)bodyTwist.getLinearPart(), (Tuple3DBasics)actualWrench.getAngularPart());
            factorizedBodyInertia.getLinearInertia().transform((Tuple3DReadOnly)bodyTwist.getLinearPart(), (Tuple3DBasics)actualWrench.getLinearPart());
            factorizedBodyInertia.getBottomLeftInertia().addTransform((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DBasics)actualWrench.getLinearPart());
            MecanoTestTools.assertWrenchEquals((WrenchReadOnly)expectedWrench, (WrenchReadOnly)actualWrench, (double)1.0E-12);
        }
    }

    @Test
    public void testApplyInverseTransform() {
        Random random = new Random(4578L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            SpatialInertia spatialInertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)worldFrame, (ReferenceFrame)worldFrame);
            Twist bodyTwist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)worldFrame, (ReferenceFrame)worldFrame, (ReferenceFrame)worldFrame);
            Wrench expectedWrench = new Wrench(worldFrame, worldFrame);
            spatialInertia.computeDynamicWrench(null, (TwistReadOnly)bodyTwist, (WrenchBasics)expectedWrench);
            expectedWrench.applyInverseTransform((RigidBodyTransformReadOnly)transform);
            FactorizedBodyInertia factorizedBodyInertia = new FactorizedBodyInertia(worldFrame);
            factorizedBodyInertia.setIncludingFrame((SpatialInertiaReadOnly)spatialInertia, (TwistReadOnly)bodyTwist);
            factorizedBodyInertia.applyInverseTransform(transform);
            bodyTwist.applyInverseTransform((RigidBodyTransformReadOnly)transform);
            Wrench actualWrench = new Wrench(worldFrame, worldFrame);
            factorizedBodyInertia.getAngularInertia().transform((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DBasics)actualWrench.getAngularPart());
            factorizedBodyInertia.getTopRightInertia().addTransform((Tuple3DReadOnly)bodyTwist.getLinearPart(), (Tuple3DBasics)actualWrench.getAngularPart());
            factorizedBodyInertia.getLinearInertia().transform((Tuple3DReadOnly)bodyTwist.getLinearPart(), (Tuple3DBasics)actualWrench.getLinearPart());
            factorizedBodyInertia.getBottomLeftInertia().addTransform((Tuple3DReadOnly)bodyTwist.getAngularPart(), (Tuple3DBasics)actualWrench.getLinearPart());
            MecanoTestTools.assertWrenchEquals((WrenchReadOnly)expectedWrench, (WrenchReadOnly)actualWrench, (double)1.0E-12);
        }
    }

    @Test
    public void testTransform() {
        Random random = new Random(6457645L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
            FactorizedBodyInertia factorizedBodyInertia = FactorizedBodyInertiaTest.nextFactorizedBodyInertia(random, worldFrame);
            SpatialVector vectorOriginal = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)worldFrame);
            SpatialVector expectedVectorTransformed = new SpatialVector();
            SpatialVector actualVectorTransformed = new SpatialVector();
            DMatrixRMaj factorizedBodyInertia_ejml = new DMatrixRMaj(6, 6);
            DMatrixRMaj vectorOriginal_ejml = new DMatrixRMaj(6, 1);
            DMatrixRMaj expectedVectorTransformed_ejml = new DMatrixRMaj(6, 1);
            factorizedBodyInertia.get((DMatrix)factorizedBodyInertia_ejml);
            vectorOriginal.get((DMatrix)vectorOriginal_ejml);
            CommonOps_DDRM.mult((DMatrix1Row)factorizedBodyInertia_ejml, (DMatrix1Row)vectorOriginal_ejml, (DMatrix1Row)expectedVectorTransformed_ejml);
            expectedVectorTransformed.set((DMatrix)expectedVectorTransformed_ejml);
            factorizedBodyInertia.transform((SpatialVectorReadOnly)vectorOriginal, (SpatialVectorBasics)actualVectorTransformed);
            MecanoTestTools.assertSpatialVectorEquals((SpatialVectorReadOnly)expectedVectorTransformed, (SpatialVectorReadOnly)actualVectorTransformed, (double)1.0E-12);
        }
    }

    @Test
    public void testAddTransform() {
        Random random = new Random(6457645L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
            FactorizedBodyInertia factorizedBodyInertia = FactorizedBodyInertiaTest.nextFactorizedBodyInertia(random, worldFrame);
            SpatialVector vectorOriginal = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)worldFrame);
            SpatialVector expectedVectorTransformed = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)worldFrame);
            SpatialVector actualVectorTransformed = new SpatialVector((SpatialVectorReadOnly)expectedVectorTransformed);
            DMatrixRMaj factorizedBodyInertia_ejml = new DMatrixRMaj(6, 6);
            DMatrixRMaj vectorOriginal_ejml = new DMatrixRMaj(6, 1);
            DMatrixRMaj expectedVectorTransformed_ejml = new DMatrixRMaj(6, 1);
            factorizedBodyInertia.get((DMatrix)factorizedBodyInertia_ejml);
            vectorOriginal.get((DMatrix)vectorOriginal_ejml);
            CommonOps_DDRM.mult((DMatrix1Row)factorizedBodyInertia_ejml, (DMatrix1Row)vectorOriginal_ejml, (DMatrix1Row)expectedVectorTransformed_ejml);
            expectedVectorTransformed.add((DMatrix)expectedVectorTransformed_ejml);
            factorizedBodyInertia.addTransform((SpatialVectorReadOnly)vectorOriginal, (SpatialVectorBasics)actualVectorTransformed);
            MecanoTestTools.assertSpatialVectorEquals((SpatialVectorReadOnly)expectedVectorTransformed, (SpatialVectorReadOnly)actualVectorTransformed, (double)1.0E-12);
        }
    }

    @Test
    public void testTransposeTransform() {
        Random random = new Random(6457645L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
            FactorizedBodyInertia factorizedBodyInertia = FactorizedBodyInertiaTest.nextFactorizedBodyInertia(random, worldFrame);
            SpatialVector vectorOriginal = MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)worldFrame);
            SpatialVector expectedVectorTransformed = new SpatialVector();
            SpatialVector actualVectorTransformed = new SpatialVector();
            DMatrixRMaj factorizedBodyInertia_ejml = new DMatrixRMaj(6, 6);
            DMatrixRMaj vectorOriginal_ejml = new DMatrixRMaj(6, 1);
            DMatrixRMaj expectedVectorTransformed_ejml = new DMatrixRMaj(6, 1);
            factorizedBodyInertia.get((DMatrix)factorizedBodyInertia_ejml);
            vectorOriginal.get((DMatrix)vectorOriginal_ejml);
            CommonOps_DDRM.multTransA((DMatrix1Row)factorizedBodyInertia_ejml, (DMatrix1Row)vectorOriginal_ejml, (DMatrix1Row)expectedVectorTransformed_ejml);
            expectedVectorTransformed.set((DMatrix)expectedVectorTransformed_ejml);
            factorizedBodyInertia.transposeTransform((SpatialVectorReadOnly)vectorOriginal, (SpatialVectorBasics)actualVectorTransformed);
            MecanoTestTools.assertSpatialVectorEquals((SpatialVectorReadOnly)expectedVectorTransformed, (SpatialVectorReadOnly)actualVectorTransformed, (double)1.0E-12);
        }
    }

    private static FactorizedBodyInertia nextFactorizedBodyInertia(Random random, ReferenceFrame expressedInFrame) {
        SpatialInertia spatialInertia = MecanoRandomTools.nextSpatialInertia((Random)random, (ReferenceFrame)expressedInFrame, (ReferenceFrame)expressedInFrame);
        Twist bodyTwist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)expressedInFrame, (ReferenceFrame)expressedInFrame, (ReferenceFrame)expressedInFrame);
        FactorizedBodyInertia next = new FactorizedBodyInertia();
        next.setIncludingFrame((SpatialInertiaReadOnly)spatialInertia, (TwistReadOnly)bodyTwist);
        return next;
    }
}

