/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.log;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.log.LogTools;

public class LogToolsTest {
    @Test
    public void testBasicLogMessage() {
        LogTools.error((String)"Hello there");
        LogTools.warn((String)"Hello there");
        LogTools.info((String)"Hello there");
        LogTools.debug((String)"Hello there");
        LogTools.trace((String)"Hello there");
        LogTools.log((Level)Level.ERROR, (String)"Hello there");
        LogTools.log((Level)Level.WARN, (String)"Hello there");
        LogTools.log((Level)Level.INFO, (String)"Hello there");
        LogTools.log((Level)Level.DEBUG, (String)"Hello there");
        LogTools.log((Level)Level.TRACE, (String)"Hello there");
        LogTools.error((int)1, (Object)"Hello there");
        LogTools.warn((int)1, (Object)"Hello there");
        LogTools.info((int)1, (Object)"Hello there");
        LogTools.debug((int)1, (Object)"Hello there");
        LogTools.trace((int)1, (Object)"Hello there");
    }

    @Test
    public void testBracketReplacement() {
        System.out.println(String.format("One: {}, Two: {}", 1, 2));
        System.out.println(new ParameterizedMessage("One: {}, Two: {}", (Object)1, (Object)2).getFormattedMessage());
        System.out.println(new ParameterizedMessageFactory().newMessage("One: {}, Two: {}", (Object)1, (Object)2).getFormattedMessage());
    }

    @Test
    public void testManyLogMessages() {
        for (int j = 0; j < 3; ++j) {
            int i;
            for (i = 0; i < 50; ++i) {
                LogTools.error((String)"Hello there");
            }
            for (i = 0; i < 50; ++i) {
                LogTools.warn((String)"Hello there");
            }
            for (i = 0; i < 50; ++i) {
                LogTools.info((String)"Hello there");
            }
        }
    }

    @Test
    public void testPassingNull() {
        Assertions.assertDoesNotThrow(() -> {
            LogTools.error((String)null);
            LogTools.warn((String)null);
            LogTools.info((String)null);
            LogTools.debug((String)null);
            LogTools.trace((String)null);
        });
    }
}

