/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.gltf;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.animation.SpatialTrack;
import com.jme3.animation.Track;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.CameraControl;
import com.jme3.scene.control.Control;
import com.jme3.scene.plugins.gltf.BinDataKey;
import com.jme3.scene.plugins.gltf.CustomContentManager;
import com.jme3.scene.plugins.gltf.GltfUtils;
import com.jme3.scene.plugins.gltf.MaterialAdapter;
import com.jme3.scene.plugins.gltf.PBRMetalRoughMaterialAdapter;
import com.jme3.scene.plugins.gltf.TrackData;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.IntMap;
import com.jme3.util.mikktspace.MikktspaceTangentGenerator;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

public class GltfLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(GltfLoader.class.getName());
    private Map<String, Object[]> dataCache = new HashMap<String, Object[]>();
    private JsonArray scenes;
    private JsonArray nodes;
    private JsonArray meshes;
    private JsonArray accessors;
    private JsonArray bufferViews;
    private JsonArray buffers;
    private JsonArray materials;
    private JsonArray textures;
    private JsonArray images;
    private JsonArray samplers;
    private JsonArray animations;
    private JsonArray skins;
    private JsonArray cameras;
    private Material defaultMat;
    private AssetInfo info;
    private JsonObject docRoot;
    private Node rootNode;
    private FloatArrayPopulator floatArrayPopulator = new FloatArrayPopulator();
    private Vector3fArrayPopulator vector3fArrayPopulator = new Vector3fArrayPopulator();
    private QuaternionArrayPopulator quaternionArrayPopulator = new QuaternionArrayPopulator();
    private Matrix4fArrayPopulator matrix4fArrayPopulator = new Matrix4fArrayPopulator();
    private static Map<String, MaterialAdapter> defaultMaterialAdapters = new HashMap<String, MaterialAdapter>();
    private CustomContentManager customContentManager = new CustomContentManager();
    private boolean useNormalsFlag = false;
    private Quaternion tmpQuat = new Quaternion();
    private Transform tmpTransforms = new Transform();
    private Transform tmpTransforms2 = new Transform();
    private Matrix4f tmpMat = new Matrix4f();
    Map<SkinData, List<Spatial>> skinnedSpatials = new HashMap<SkinData, List<Spatial>>();
    IntMap<SkinBuffers> skinBuffers = new IntMap();

    public Object load(AssetInfo assetInfo) throws IOException {
        return this.loadFromStream(assetInfo, assetInfo.openStream());
    }

    protected Object loadFromStream(AssetInfo assetInfo, InputStream stream) throws IOException {
        try {
            String minVersion;
            this.dataCache.clear();
            this.info = assetInfo;
            this.rootNode = new Node();
            if (this.defaultMat == null) {
                this.defaultMat = new Material(assetInfo.getManager(), "Common/MatDefs/Light/PBRLighting.j3md");
                this.defaultMat.setColor("BaseColor", ColorRGBA.White);
                this.defaultMat.setFloat("Metallic", 0.0f);
                this.defaultMat.setFloat("Roughness", 1.0f);
            }
            this.docRoot = new JsonParser().parse(new JsonReader((Reader)new InputStreamReader(stream))).getAsJsonObject();
            JsonObject asset = this.docRoot.getAsJsonObject().get("asset").getAsJsonObject();
            String generator = GltfUtils.getAsString(asset, "generator");
            String version = GltfUtils.getAsString(asset, "version");
            if (!this.isSupported(version, minVersion = GltfUtils.getAsString(asset, "minVersion"))) {
                logger.log(Level.SEVERE, "Gltf Loader doesn't support this gltf version: " + version + (minVersion != null ? "/" + minVersion : ""));
            }
            this.scenes = this.docRoot.getAsJsonArray("scenes");
            this.nodes = this.docRoot.getAsJsonArray("nodes");
            this.meshes = this.docRoot.getAsJsonArray("meshes");
            this.accessors = this.docRoot.getAsJsonArray("accessors");
            this.bufferViews = this.docRoot.getAsJsonArray("bufferViews");
            this.buffers = this.docRoot.getAsJsonArray("buffers");
            this.materials = this.docRoot.getAsJsonArray("materials");
            this.textures = this.docRoot.getAsJsonArray("textures");
            this.images = this.docRoot.getAsJsonArray("images");
            this.samplers = this.docRoot.getAsJsonArray("samplers");
            this.animations = this.docRoot.getAsJsonArray("animations");
            this.skins = this.docRoot.getAsJsonArray("skins");
            this.cameras = this.docRoot.getAsJsonArray("cameras");
            this.customContentManager.init(this);
            this.readSkins();
            this.readCameras();
            JsonPrimitive defaultScene = this.docRoot.getAsJsonPrimitive("scene");
            this.readScenes(defaultScene, this.rootNode);
            this.rootNode = this.customContentManager.readExtensionAndExtras("root", (JsonElement)this.docRoot, this.rootNode);
            this.setupControls();
            if (this.rootNode.getChildren().size() == 1) {
                this.rootNode = (Node)this.rootNode.getChild(0);
            }
            if (this.rootNode.getName() == null) {
                this.rootNode.setName(assetInfo.getKey().getName());
            }
            Node node = this.rootNode;
            return node;
        }
        catch (Exception e) {
            throw new AssetLoadException("An error occurred loading " + assetInfo.getKey().getName(), (Throwable)e);
        }
        finally {
            stream.close();
        }
    }

    private void setDefaultParams(Material mat) {
        mat.setColor("BaseColor", ColorRGBA.White);
        mat.setFloat("Metallic", 0.0f);
        mat.setFloat("Roughness", 1.0f);
    }

    private boolean isSupported(String version, String minVersion) {
        return "2.0".equals(version);
    }

    public void readScenes(JsonPrimitive defaultScene, Node rootNode) throws IOException {
        if (this.scenes == null) {
            throw new AssetLoadException("Gltf files with no scene is not yet supported");
        }
        for (JsonElement scene : this.scenes) {
            Node sceneNode = new Node();
            sceneNode.setCullHint(Spatial.CullHint.Always);
            sceneNode.setName(GltfUtils.getAsString(scene.getAsJsonObject(), "name"));
            JsonArray sceneNodes = scene.getAsJsonObject().getAsJsonArray("nodes");
            sceneNode = this.customContentManager.readExtensionAndExtras("scene", scene, sceneNode);
            rootNode.attachChild((Spatial)sceneNode);
            for (JsonElement node : sceneNodes) {
                this.readChild((Spatial)sceneNode, node);
            }
        }
        if (this.animations != null) {
            for (int i = 0; i < this.animations.size(); ++i) {
                this.readAnimation(i);
            }
        }
        int activeChild = 0;
        if (defaultScene != null) {
            activeChild = defaultScene.getAsInt();
        }
        rootNode.getChild(activeChild).setCullHint(Spatial.CullHint.Inherit);
    }

    public Object readNode(int nodeIndex) throws IOException {
        Node node;
        Node spatial;
        Object obj = this.fetchFromCache("nodes", nodeIndex, Object.class);
        if (obj != null) {
            if (obj instanceof BoneWrapper) {
                return obj;
            }
            return ((Spatial)obj).clone();
        }
        JsonObject nodeData = this.nodes.get(nodeIndex).getAsJsonObject();
        JsonArray children = nodeData.getAsJsonArray("children");
        Integer meshIndex = GltfUtils.getAsInteger(nodeData, "mesh");
        if (meshIndex != null) {
            GltfUtils.assertNotNull(this.meshes, "Can't find any mesh data, yet a node references a mesh");
            Geometry[] primitives = this.readMeshPrimitives(meshIndex);
            if (primitives.length == 1 && children == null) {
                spatial = primitives[0];
            } else {
                node = new Node();
                for (Geometry primitive : primitives) {
                    node.attachChild((Spatial)primitive);
                }
                spatial = node;
            }
            spatial.setName(this.readMeshName(meshIndex));
        } else {
            Integer camIndex = GltfUtils.getAsInteger(nodeData, "camera");
            if (camIndex != null) {
                Camera cam = this.fetchFromCache("cameras", camIndex, Camera.class);
                CameraNode node2 = new CameraNode(null, cam);
                node2.setControlDir(CameraControl.ControlDirection.SpatialToCamera);
                spatial = node2;
            } else {
                spatial = node = new Node();
            }
        }
        Integer skinIndex = GltfUtils.getAsInteger(nodeData, "skin");
        if (skinIndex != null) {
            SkinData skinData = this.fetchFromCache("skins", skinIndex, SkinData.class);
            List<Spatial> spatials = this.skinnedSpatials.get(skinData);
            spatials.add((Spatial)spatial);
        }
        spatial.setLocalTransform(this.readTransforms(nodeData));
        if (spatial.getName() == null) {
            spatial.setName(GltfUtils.getAsString(nodeData.getAsJsonObject(), "name"));
        }
        spatial = (Spatial)this.customContentManager.readExtensionAndExtras("node", (JsonElement)nodeData, spatial);
        this.addToCache("nodes", nodeIndex, spatial, this.nodes.size());
        return spatial;
    }

    private void readChild(Spatial parent, JsonElement nodeIndex) throws IOException {
        Object loaded = this.readNode(nodeIndex.getAsInt());
        if (loaded instanceof Spatial) {
            Spatial spatial = (Spatial)loaded;
            ((Node)parent).attachChild(spatial);
            JsonObject nodeElem = this.nodes.get(nodeIndex.getAsInt()).getAsJsonObject();
            JsonArray children = nodeElem.getAsJsonArray("children");
            if (children != null) {
                for (JsonElement child : children) {
                    this.readChild(spatial, child);
                }
            }
        } else if (loaded instanceof BoneWrapper) {
            BoneWrapper bw = (BoneWrapper)loaded;
            bw.isRoot = true;
            SkinData skinData = this.fetchFromCache("skins", bw.skinIndex, SkinData.class);
            skinData.armatureTransforms = parent.getLocalTransform();
        }
    }

    public Transform readTransforms(JsonObject nodeData) {
        JsonArray scale;
        JsonArray rotation;
        Transform transform = new Transform();
        JsonArray matrix = nodeData.getAsJsonArray("matrix");
        if (matrix != null) {
            float[] tmpArray = new float[16];
            for (int i = 0; i < tmpArray.length; ++i) {
                tmpArray[i] = matrix.get(i).getAsFloat();
            }
            Matrix4f mat = new Matrix4f(tmpArray);
            transform.fromTransformMatrix(mat);
            return transform;
        }
        JsonArray translation = nodeData.getAsJsonArray("translation");
        if (translation != null) {
            transform.setTranslation(translation.get(0).getAsFloat(), translation.get(1).getAsFloat(), translation.get(2).getAsFloat());
        }
        if ((rotation = nodeData.getAsJsonArray("rotation")) != null) {
            transform.setRotation(new Quaternion(rotation.get(0).getAsFloat(), rotation.get(1).getAsFloat(), rotation.get(2).getAsFloat(), rotation.get(3).getAsFloat()));
        }
        if ((scale = nodeData.getAsJsonArray("scale")) != null) {
            transform.setScale(scale.get(0).getAsFloat(), scale.get(1).getAsFloat(), scale.get(2).getAsFloat());
        }
        return transform;
    }

    public Geometry[] readMeshPrimitives(int meshIndex) throws IOException {
        Geometry[] geomArray = (Geometry[])this.fetchFromCache("meshes", meshIndex, Object.class);
        if (geomArray != null) {
            Geometry[] geoms = new Geometry[geomArray.length];
            for (int i = 0; i < geoms.length; ++i) {
                geoms[i] = geomArray[i].clone(false);
            }
            return geoms;
        }
        JsonObject meshData = this.meshes.get(meshIndex).getAsJsonObject();
        JsonArray primitives = meshData.getAsJsonArray("primitives");
        GltfUtils.assertNotNull(primitives, "Can't find any primitives in mesh " + meshIndex);
        String name = GltfUtils.getAsString(meshData, "name");
        geomArray = new Geometry[primitives.size()];
        int index = 0;
        for (JsonElement primitive : primitives) {
            JsonObject meshObject = primitive.getAsJsonObject();
            Mesh mesh = new Mesh();
            Integer mode = GltfUtils.getAsInteger(meshObject, "mode");
            mesh.setMode(GltfUtils.getMeshMode(mode));
            Integer indices = GltfUtils.getAsInteger(meshObject, "indices");
            if (indices != null) {
                mesh.setBuffer(this.readAccessorData(indices, new VertexBufferPopulator(VertexBuffer.Type.Index)));
            }
            JsonObject attributes = meshObject.getAsJsonObject("attributes");
            GltfUtils.assertNotNull(attributes, "No attributes defined for mesh " + mesh);
            this.skinBuffers.clear();
            for (Map.Entry entry : attributes.entrySet()) {
                SkinBuffers buffs;
                String bufferType = (String)entry.getKey();
                if (bufferType.startsWith("JOINTS")) {
                    buffs = this.getSkinBuffers(bufferType);
                    SkinBuffers buffer = this.readAccessorData(((JsonElement)entry.getValue()).getAsInt(), new JointArrayPopulator());
                    buffs.joints = buffer.joints;
                    buffs.componentSize = buffer.componentSize;
                    continue;
                }
                if (bufferType.startsWith("WEIGHTS")) {
                    buffs = this.getSkinBuffers(bufferType);
                    buffs.weights = this.readAccessorData(((JsonElement)entry.getValue()).getAsInt(), new FloatArrayPopulator());
                    continue;
                }
                VertexBuffer vb = this.readAccessorData(((JsonElement)entry.getValue()).getAsInt(), new VertexBufferPopulator(GltfUtils.getVertexBufferType(bufferType)));
                if (vb == null) continue;
                mesh.setBuffer(vb);
            }
            GltfUtils.handleSkinningBuffers(mesh, this.skinBuffers);
            if (mesh.getBuffer(VertexBuffer.Type.BoneIndex) != null) {
                VertexBuffer weightsHW = new VertexBuffer(VertexBuffer.Type.HWBoneWeight);
                VertexBuffer indicesHW = new VertexBuffer(VertexBuffer.Type.HWBoneIndex);
                indicesHW.setUsage(VertexBuffer.Usage.CpuOnly);
                weightsHW.setUsage(VertexBuffer.Usage.CpuOnly);
                mesh.setBuffer(weightsHW);
                mesh.setBuffer(indicesHW);
                mesh.generateBindPose();
            }
            mesh = this.customContentManager.readExtensionAndExtras("primitive", (JsonElement)meshObject, mesh);
            Geometry geom = new Geometry(null, mesh);
            Integer materialIndex = GltfUtils.getAsInteger(meshObject, "material");
            if (materialIndex == null) {
                geom.setMaterial(this.defaultMat);
            } else {
                this.useNormalsFlag = false;
                geom.setMaterial(this.readMaterial(materialIndex));
                if (geom.getMaterial().getAdditionalRenderState().getBlendMode() == RenderState.BlendMode.Alpha) {
                    geom.setQueueBucket(RenderQueue.Bucket.Transparent);
                }
                if (this.useNormalsFlag && mesh.getBuffer(VertexBuffer.Type.Tangent) == null) {
                    MikktspaceTangentGenerator.generate((Spatial)geom);
                }
            }
            if (name != null) {
                geom.setName(name + (primitives.size() > 1 ? "_" + index : ""));
            }
            geom.updateModelBound();
            geomArray[index] = geom;
            ++index;
        }
        geomArray = this.customContentManager.readExtensionAndExtras("mesh", (JsonElement)meshData, geomArray);
        this.addToCache("meshes", meshIndex, geomArray, this.meshes.size());
        return geomArray;
    }

    private SkinBuffers getSkinBuffers(String bufferType) {
        int bufIndex = GltfUtils.getIndex(bufferType);
        SkinBuffers buffs = (SkinBuffers)this.skinBuffers.get(bufIndex);
        if (buffs == null) {
            buffs = new SkinBuffers();
            this.skinBuffers.put(bufIndex, (Object)buffs);
        }
        return buffs;
    }

    public <R> R readAccessorData(int accessorIndex, Populator<R> populator) throws IOException {
        GltfUtils.assertNotNull(this.accessors, "No accessor attribute in the gltf file");
        JsonObject accessor = this.accessors.get(accessorIndex).getAsJsonObject();
        Integer bufferViewIndex = GltfUtils.getAsInteger(accessor, "bufferView");
        int byteOffset = GltfUtils.getAsInteger(accessor, "byteOffset", 0);
        Integer componentType = GltfUtils.getAsInteger(accessor, "componentType");
        GltfUtils.assertNotNull(componentType, "No component type defined for accessor " + accessorIndex);
        Integer count = GltfUtils.getAsInteger(accessor, "count");
        GltfUtils.assertNotNull(count, "No count attribute defined for accessor " + accessorIndex);
        String type = GltfUtils.getAsString(accessor, "type");
        GltfUtils.assertNotNull(type, "No type attribute defined for accessor " + accessorIndex);
        boolean normalized = GltfUtils.getAsBoolean(accessor, "normalized", false);
        R data = populator.populate(bufferViewIndex, componentType, type, count, byteOffset, normalized);
        data = this.customContentManager.readExtensionAndExtras("accessor", (JsonElement)accessor, data);
        return data;
    }

    public Object readBuffer(Integer bufferViewIndex, int byteOffset, int count, Object store, int numComponents, VertexBuffer.Format format) throws IOException {
        JsonObject bufferView = this.bufferViews.get(bufferViewIndex.intValue()).getAsJsonObject();
        Integer bufferIndex = GltfUtils.getAsInteger(bufferView, "buffer");
        GltfUtils.assertNotNull(bufferIndex, "No buffer defined for bufferView " + bufferViewIndex);
        int bvByteOffset = GltfUtils.getAsInteger(bufferView, "byteOffset", 0);
        Integer byteLength = GltfUtils.getAsInteger(bufferView, "byteLength");
        GltfUtils.assertNotNull(byteLength, "No byte length defined for bufferView " + bufferViewIndex);
        int byteStride = GltfUtils.getAsInteger(bufferView, "byteStride", 0);
        byte[] data = this.readData(bufferIndex);
        data = this.customContentManager.readExtensionAndExtras("bufferView", (JsonElement)bufferView, data);
        if (store == null) {
            store = new byte[byteLength.intValue()];
        }
        if (count == -1) {
            count = byteLength;
        }
        GltfUtils.populateBuffer(store, data, count, byteOffset + bvByteOffset, byteStride, numComponents, format);
        return store;
    }

    public byte[] readData(int bufferIndex) throws IOException {
        GltfUtils.assertNotNull(this.buffers, "No buffer defined");
        JsonObject buffer = this.buffers.get(bufferIndex).getAsJsonObject();
        String uri = GltfUtils.getAsString(buffer, "uri");
        Integer bufferLength = GltfUtils.getAsInteger(buffer, "byteLength");
        GltfUtils.assertNotNull(bufferLength, "No byteLength defined for buffer " + bufferIndex);
        byte[] data = (byte[])this.fetchFromCache("buffers", bufferIndex, Object.class);
        if (data != null) {
            return data;
        }
        data = this.getBytes(bufferIndex, uri, bufferLength);
        data = this.customContentManager.readExtensionAndExtras("buffer", (JsonElement)buffer, data);
        this.addToCache("buffers", bufferIndex, data, this.buffers.size());
        return data;
    }

    protected byte[] getBytes(int bufferIndex, String uri, Integer bufferLength) throws IOException {
        byte[] data;
        if (uri != null) {
            if (uri.startsWith("data:")) {
                data = DatatypeConverter.parseBase64Binary((String)uri.substring(uri.indexOf(",") + 1));
            } else {
                if (!uri.endsWith(".bin")) {
                    throw new AssetLoadException("Cannot load " + uri + ", a .bin extension is required.");
                }
                BinDataKey key = new BinDataKey(this.info.getKey().getFolder() + uri);
                InputStream input = (InputStream)this.info.getManager().loadAsset((AssetKey)key);
                data = new byte[bufferLength.intValue()];
                DataInputStream dataStream = new DataInputStream(input);
                dataStream.readFully(data);
                dataStream.close();
            }
        } else {
            throw new AssetLoadException("Buffer " + bufferIndex + " has no uri");
        }
        return data;
    }

    public Material readMaterial(int materialIndex) throws IOException {
        GltfUtils.assertNotNull(this.materials, "There is no material defined yet a mesh references one");
        JsonObject matData = this.materials.get(materialIndex).getAsJsonObject();
        JsonObject pbrMat = matData.getAsJsonObject("pbrMetallicRoughness");
        MaterialAdapter adapter = null;
        if (pbrMat != null) {
            adapter = GltfUtils.getAdapterForMaterial(this.info, "pbrMetallicRoughness");
            if (adapter == null) {
                adapter = defaultMaterialAdapters.get("pbrMetallicRoughness");
            }
            adapter.init(this.info.getManager());
        }
        if ((adapter = this.customContentManager.readExtensionAndExtras("material", (JsonElement)matData, adapter)) == null) {
            logger.log(Level.WARNING, "Couldn't find any matching material definition for material " + materialIndex);
            adapter = defaultMaterialAdapters.get("pbrMetallicRoughness");
            adapter.init(this.info.getManager());
            this.setDefaultParams(adapter.getMaterial());
        }
        if (pbrMat != null) {
            adapter.setParam("baseColorFactor", GltfUtils.getAsColor(pbrMat, "baseColorFactor", ColorRGBA.White));
            adapter.setParam("metallicFactor", GltfUtils.getAsFloat(pbrMat, "metallicFactor", 1.0f));
            adapter.setParam("roughnessFactor", GltfUtils.getAsFloat(pbrMat, "roughnessFactor", 1.0f));
            adapter.setParam("baseColorTexture", this.readTexture(pbrMat.getAsJsonObject("baseColorTexture")));
            adapter.setParam("metallicRoughnessTexture", this.readTexture(pbrMat.getAsJsonObject("metallicRoughnessTexture")));
        }
        adapter.getMaterial().setName(GltfUtils.getAsString(matData, "name"));
        adapter.setParam("emissiveFactor", GltfUtils.getAsColor(matData, "emissiveFactor", ColorRGBA.Black));
        String alphaMode = GltfUtils.getAsString(matData, "alphaMode");
        adapter.setParam("alphaMode", alphaMode);
        if (alphaMode != null && alphaMode.equals("MASK")) {
            adapter.setParam("alphaCutoff", GltfUtils.getAsFloat(matData, "alphaCutoff"));
        }
        adapter.setParam("doubleSided", GltfUtils.getAsBoolean(matData, "doubleSided"));
        Texture2D normal = this.readTexture(matData.getAsJsonObject("normalTexture"));
        adapter.setParam("normalTexture", normal);
        if (normal != null) {
            this.useNormalsFlag = true;
        }
        adapter.setParam("occlusionTexture", this.readTexture(matData.getAsJsonObject("occlusionTexture")));
        adapter.setParam("emissiveTexture", this.readTexture(matData.getAsJsonObject("emissiveTexture")));
        return adapter.getMaterial();
    }

    public void readCameras() throws IOException {
        if (this.cameras == null) {
            return;
        }
        for (int i = 0; i < this.cameras.size(); ++i) {
            Float zfar;
            Float znear;
            Camera cam = new Camera(1, 1);
            JsonObject camObj = this.cameras.get(i).getAsJsonObject();
            String type = GltfUtils.getAsString(camObj, "type");
            GltfUtils.assertNotNull(type, "No type defined ofr camera");
            JsonObject camData = camObj.getAsJsonObject(type);
            if (type.equals("perspective")) {
                float aspectRatio = GltfUtils.getAsFloat(camData, "aspectRation", 1.0f).floatValue();
                Float yfov = GltfUtils.getAsFloat(camData, "yfov");
                GltfUtils.assertNotNull(yfov, "No yfov for perspective camera");
                znear = GltfUtils.getAsFloat(camData, "znear");
                GltfUtils.assertNotNull(znear, "No znear for perspective camere");
                zfar = GltfUtils.getAsFloat(camData, "zfar", znear.floatValue() * 1000.0f);
                cam.setFrustumPerspective(yfov.floatValue() * 57.295776f, aspectRatio, znear.floatValue(), zfar.floatValue());
                cam = this.customContentManager.readExtensionAndExtras("camera.perspective", (JsonElement)camData, cam);
            } else {
                Float xmag = GltfUtils.getAsFloat(camData, "xmag");
                GltfUtils.assertNotNull(xmag, "No xmag for orthographic camera");
                Float ymag = GltfUtils.getAsFloat(camData, "ymag");
                GltfUtils.assertNotNull(ymag, "No ymag for orthographic camera");
                znear = GltfUtils.getAsFloat(camData, "znear");
                GltfUtils.assertNotNull(znear, "No znear for orthographic camere");
                zfar = GltfUtils.getAsFloat(camData, "zfar", znear.floatValue() * 1000.0f);
                GltfUtils.assertNotNull(zfar, "No zfar for orthographic camera");
                cam.setParallelProjection(true);
                cam.setFrustum(znear.floatValue(), zfar.floatValue(), -xmag.floatValue(), xmag.floatValue(), ymag.floatValue(), -ymag.floatValue());
                cam = this.customContentManager.readExtensionAndExtras("camera.orthographic", (JsonElement)camData, cam);
            }
            cam = this.customContentManager.readExtensionAndExtras("camera", (JsonElement)camObj, cam);
            this.addToCache("cameras", i, cam, this.cameras.size());
        }
    }

    public Texture2D readTexture(JsonObject texture) throws IOException {
        return this.readTexture(texture, false);
    }

    public Texture2D readTexture(JsonObject texture, boolean flip) throws IOException {
        if (texture == null) {
            return null;
        }
        Integer textureIndex = GltfUtils.getAsInteger(texture, "index");
        GltfUtils.assertNotNull(textureIndex, "Texture as no index");
        GltfUtils.assertNotNull(this.textures, "There are no textures, yet one is referenced by a material");
        JsonObject textureData = this.textures.get(textureIndex.intValue()).getAsJsonObject();
        Integer sourceIndex = GltfUtils.getAsInteger(textureData, "source");
        Integer samplerIndex = GltfUtils.getAsInteger(textureData, "sampler");
        Texture2D texture2d = this.readImage(sourceIndex, flip);
        if (samplerIndex != null) {
            texture2d = this.readSampler(samplerIndex, texture2d);
        } else {
            texture2d.setWrap(Texture.WrapMode.Repeat);
        }
        texture2d = this.customContentManager.readExtensionAndExtras("texture", (JsonElement)texture, texture2d);
        return texture2d;
    }

    public Texture2D readImage(int sourceIndex, boolean flip) throws IOException {
        Texture2D result;
        if (this.images == null) {
            throw new AssetLoadException("No image defined");
        }
        JsonObject image = this.images.get(sourceIndex).getAsJsonObject();
        String uri = GltfUtils.getAsString(image, "uri");
        Integer bufferView = GltfUtils.getAsInteger(image, "bufferView");
        String mimeType = GltfUtils.getAsString(image, "mimeType");
        if (uri == null) {
            GltfUtils.assertNotNull(bufferView, "Image " + sourceIndex + " should either have an uri or a bufferView");
            GltfUtils.assertNotNull(mimeType, "Image " + sourceIndex + " should have a mimeType");
            byte[] data = (byte[])this.readBuffer(bufferView, 0, -1, null, 1, VertexBuffer.Format.Byte);
            String extension = mimeType.split("/")[1];
            TextureKey key = new TextureKey("image" + sourceIndex + "." + extension, flip);
            result = (Texture2D)this.info.getManager().loadAssetFromStream((AssetKey)key, (InputStream)new ByteArrayInputStream(data));
        } else if (uri.startsWith("data:")) {
            String[] uriInfo = uri.split(",");
            byte[] data = DatatypeConverter.parseBase64Binary((String)uriInfo[1]);
            String headerInfo = uriInfo[0].split(";")[0];
            String extension = headerInfo.split("/")[1];
            TextureKey key = new TextureKey("image" + sourceIndex + "." + extension, flip);
            result = (Texture2D)this.info.getManager().loadAssetFromStream((AssetKey)key, (InputStream)new ByteArrayInputStream(data));
        } else {
            TextureKey key = new TextureKey(this.info.getKey().getFolder() + uri, flip);
            Texture tex = this.info.getManager().loadTexture(key);
            result = (Texture2D)tex;
        }
        return result;
    }

    public void readAnimation(int animationIndex) throws IOException {
        JsonObject animation = this.animations.get(animationIndex).getAsJsonObject();
        JsonArray channels = animation.getAsJsonArray("channels");
        JsonArray samplers = animation.getAsJsonArray("samplers");
        String name = GltfUtils.getAsString(animation, "name");
        GltfUtils.assertNotNull(channels, "No channels for animation " + name);
        GltfUtils.assertNotNull(samplers, "No samplers for animation " + name);
        TrackData[] tracks = new TrackData[this.nodes.size()];
        for (JsonElement channel : channels) {
            JsonObject target = channel.getAsJsonObject().getAsJsonObject("target");
            Integer targetNode = GltfUtils.getAsInteger(target, "node");
            String targetPath = GltfUtils.getAsString(target, "path");
            if (targetNode == null) continue;
            GltfUtils.assertNotNull(targetPath, "No target path for channel");
            if (targetPath.equals("weight")) {
                logger.log(Level.WARNING, "Morph animation is not supported by JME yet, skipping animation");
                continue;
            }
            TrackData trackData = tracks[targetNode];
            if (trackData == null) {
                tracks[targetNode.intValue()] = trackData = new TrackData();
            }
            Integer samplerIndex = GltfUtils.getAsInteger(channel.getAsJsonObject(), "sampler");
            GltfUtils.assertNotNull(samplerIndex, "No animation sampler provided for channel");
            JsonObject sampler = samplers.get(samplerIndex.intValue()).getAsJsonObject();
            Integer timeIndex = GltfUtils.getAsInteger(sampler, "input");
            GltfUtils.assertNotNull(timeIndex, "No input accessor Provided for animation sampler");
            Integer dataIndex = GltfUtils.getAsInteger(sampler, "output");
            GltfUtils.assertNotNull(dataIndex, "No output accessor Provided for animation sampler");
            String interpolation = GltfUtils.getAsString(sampler, "interpolation");
            if (interpolation == null || !interpolation.equals("LINEAR")) {
                logger.log(Level.WARNING, "JME only supports linear interpolation for animations");
            }
            trackData = this.customContentManager.readExtensionAndExtras("animation.sampler", (JsonElement)sampler, trackData);
            float[] times = this.fetchFromCache("accessors", timeIndex, float[].class);
            if (times == null) {
                times = this.readAccessorData(timeIndex, this.floatArrayPopulator);
                this.addToCache("accessors", timeIndex, times, this.accessors.size());
            }
            if (targetPath.equals("translation")) {
                trackData.timeArrays.add(new TrackData.TimeData(times, TrackData.Type.Translation));
                Vector3f[] translations = this.readAccessorData(dataIndex, this.vector3fArrayPopulator);
                trackData.translations = translations;
            } else if (targetPath.equals("scale")) {
                trackData.timeArrays.add(new TrackData.TimeData(times, TrackData.Type.Scale));
                Vector3f[] scales = this.readAccessorData(dataIndex, this.vector3fArrayPopulator);
                trackData.scales = scales;
            } else if (targetPath.equals("rotation")) {
                trackData.timeArrays.add(new TrackData.TimeData(times, TrackData.Type.Rotation));
                Quaternion[] rotations = this.readAccessorData(dataIndex, this.quaternionArrayPopulator);
                trackData.rotations = rotations;
            } else {
                logger.log(Level.WARNING, "Morph animation is not supported");
                continue;
            }
            tracks[targetNode.intValue()] = this.customContentManager.readExtensionAndExtras("channel", channel, trackData);
        }
        if (name == null) {
            name = "anim_" + animationIndex;
        }
        ArrayList<Spatial> spatials = new ArrayList<Spatial>();
        Animation anim = new Animation();
        anim.setName(name);
        int skinIndex = -1;
        for (int i = 0; i < tracks.length; ++i) {
            SpatialTrack track;
            Object node;
            TrackData trackData = tracks[i];
            if (trackData == null || trackData.timeArrays.isEmpty()) continue;
            trackData.update();
            if (trackData.length.floatValue() > anim.getLength()) {
                anim.setLength(trackData.length.floatValue());
            }
            if ((node = this.fetchFromCache("nodes", i, Object.class)) instanceof Spatial) {
                Spatial s = (Spatial)node;
                spatials.add(s);
                track = new SpatialTrack(trackData.times, trackData.translations, trackData.rotations, trackData.scales);
                track.setTrackSpatial(s);
                anim.addTrack((Track)track);
                continue;
            }
            if (!(node instanceof BoneWrapper)) continue;
            BoneWrapper b = (BoneWrapper)node;
            b.update(trackData);
            track = new BoneTrack(b.boneIndex, trackData.times, trackData.translations, trackData.rotations, trackData.scales);
            anim.addTrack((Track)track);
            if (skinIndex == -1) {
                skinIndex = b.skinIndex;
                continue;
            }
            if (skinIndex == b.skinIndex) continue;
            throw new AssetLoadException("Animation " + animationIndex + " (" + name + ") applies to bones that are not from the same skin: skin " + skinIndex + ", bone " + b.bone.getName() + " from skin " + b.skinIndex);
        }
        anim = this.customContentManager.readExtensionAndExtras("animations", (JsonElement)animation, anim);
        if (skinIndex != -1) {
            SkinData skin = this.fetchFromCache("skins", skinIndex, SkinData.class);
            if (skin.animControl == null) {
                skin.animControl = new AnimControl(skin.skeletonControl.getSkeleton());
            }
            skin.animControl.addAnim(anim);
        }
        if (!spatials.isEmpty()) {
            if (skinIndex != -1) {
                SkinData skin = this.fetchFromCache("skins", skinIndex, SkinData.class);
                List<Spatial> spat = this.skinnedSpatials.get(skin);
                spat.addAll(spatials);
            } else {
                Spatial spatial = null;
                spatial = spatials.size() == 1 ? (Spatial)spatials.get(0) : GltfUtils.findCommonAncestor(spatials);
                AnimControl control = (AnimControl)spatial.getControl(AnimControl.class);
                if (control == null) {
                    control = new AnimControl();
                    spatial.addControl((Control)control);
                }
                control.addAnim(anim);
            }
        }
    }

    public Texture2D readSampler(int samplerIndex, Texture2D texture) throws IOException {
        if (this.samplers == null) {
            throw new AssetLoadException("No samplers defined");
        }
        JsonObject sampler = this.samplers.get(samplerIndex).getAsJsonObject();
        Texture.MagFilter magFilter = GltfUtils.getMagFilter(GltfUtils.getAsInteger(sampler, "magFilter"));
        Texture.MinFilter minFilter = GltfUtils.getMinFilter(GltfUtils.getAsInteger(sampler, "minFilter"));
        Texture.WrapMode wrapS = GltfUtils.getWrapMode(GltfUtils.getAsInteger(sampler, "wrapS"));
        Texture.WrapMode wrapT = GltfUtils.getWrapMode(GltfUtils.getAsInteger(sampler, "wrapT"));
        if (magFilter != null) {
            texture.setMagFilter(magFilter);
        }
        if (minFilter != null) {
            texture.setMinFilter(minFilter);
        }
        texture.setWrap(Texture.WrapAxis.S, wrapS);
        texture.setWrap(Texture.WrapAxis.T, wrapT);
        texture = this.customContentManager.readExtensionAndExtras("texture.sampler", (JsonElement)sampler, texture);
        return texture;
    }

    public void readSkins() throws IOException {
        if (this.skins == null) {
            return;
        }
        for (int index = 0; index < this.skins.size(); ++index) {
            int i;
            JsonObject skin = this.skins.get(index).getAsJsonObject();
            JsonArray joints = skin.getAsJsonArray("joints");
            GltfUtils.assertNotNull(joints, "No joints defined for skin");
            Integer matricesIndex = GltfUtils.getAsInteger(skin, "inverseBindMatrices");
            Matrix4f[] inverseBindMatrices = null;
            if (matricesIndex != null) {
                inverseBindMatrices = this.readAccessorData(matricesIndex, this.matrix4fArrayPopulator);
            } else {
                inverseBindMatrices = new Matrix4f[joints.size()];
                for (int i2 = 0; i2 < inverseBindMatrices.length; ++i2) {
                    inverseBindMatrices[i2] = new Matrix4f();
                }
            }
            Bone[] bones = new Bone[joints.size()];
            for (i = 0; i < joints.size(); ++i) {
                int boneIndex = joints.get(i).getAsInt();
                Matrix4f modelBindMatrix = inverseBindMatrices[i].invertLocal();
                bones[i] = this.readNodeAsBone(boneIndex, i, index, modelBindMatrix);
            }
            for (i = 0; i < joints.size(); ++i) {
                this.findChildren(joints.get(i).getAsInt());
            }
            Skeleton skeleton = new Skeleton(bones);
            for (Bone bone : skeleton.getRoots()) {
                BoneWrapper bw = this.findBoneWrapper(bone);
                this.computeBindTransforms(bw, skeleton);
            }
            if (GltfUtils.isKeepSkeletonPose(this.info)) {
                for (int i3 = 0; i3 < joints.size(); ++i3) {
                    this.applyPose(joints.get(i3).getAsInt());
                }
                skeleton.updateWorldVectors();
            }
            skeleton = this.customContentManager.readExtensionAndExtras("skin", (JsonElement)skin, skeleton);
            SkinData skinData = new SkinData();
            skinData.skeletonControl = new SkeletonControl(skeleton);
            this.addToCache("skins", index, skinData, this.nodes.size());
            this.skinnedSpatials.put(skinData, new ArrayList());
        }
    }

    private void applyPose(int index) {
        BoneWrapper bw = this.fetchFromCache("nodes", index, BoneWrapper.class);
        bw.bone.setUserControl(true);
        bw.bone.setLocalTranslation(bw.localTransform.getTranslation());
        bw.bone.setLocalRotation(bw.localTransform.getRotation());
        bw.bone.setLocalScale(bw.localTransform.getScale());
    }

    private void computeBindTransforms(BoneWrapper boneWrapper, Skeleton skeleton) {
        Bone bone = boneWrapper.bone;
        this.tmpTransforms.fromTransformMatrix(boneWrapper.modelBindMatrix);
        if (bone.getParent() != null) {
            this.tmpMat.setTranslation(bone.getParent().getModelSpacePosition());
            this.tmpMat.setRotationQuaternion(bone.getParent().getModelSpaceRotation());
            this.tmpMat.setScale(bone.getParent().getModelSpaceScale());
            this.tmpMat.invertLocal();
            this.tmpTransforms2.fromTransformMatrix(this.tmpMat);
            this.tmpTransforms.combineWithParent(this.tmpTransforms2);
        }
        bone.setBindTransforms(this.tmpTransforms.getTranslation(), this.tmpTransforms.getRotation(), this.tmpTransforms.getScale());
        skeleton.resetAndUpdate();
        skeleton.setBindingPose();
        for (Integer childIndex : boneWrapper.children) {
            BoneWrapper child = this.fetchFromCache("nodes", childIndex, BoneWrapper.class);
            this.computeBindTransforms(child, skeleton);
        }
    }

    private BoneWrapper findBoneWrapper(Bone bone) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            BoneWrapper bw = this.fetchFromCache("nodes", i, BoneWrapper.class);
            if (bw == null || bw.bone != bone) continue;
            return bw;
        }
        return null;
    }

    public Bone readNodeAsBone(int nodeIndex, int boneIndex, int skinIndex, Matrix4f modelBindMatrix) throws IOException {
        BoneWrapper boneWrapper = this.fetchFromCache("nodes", nodeIndex, BoneWrapper.class);
        if (boneWrapper != null) {
            return boneWrapper.bone;
        }
        JsonObject nodeData = this.nodes.get(nodeIndex).getAsJsonObject();
        String name = GltfUtils.getAsString(nodeData, "name");
        if (name == null) {
            name = "Bone_" + nodeIndex;
        }
        Bone bone = new Bone(name);
        Transform boneTransforms = null;
        boneTransforms = this.readTransforms(nodeData);
        this.addToCache("nodes", nodeIndex, new BoneWrapper(bone, boneIndex, skinIndex, modelBindMatrix, boneTransforms), this.nodes.size());
        return bone;
    }

    private void findChildren(int nodeIndex) throws IOException {
        BoneWrapper bw = this.fetchFromCache("nodes", nodeIndex, BoneWrapper.class);
        JsonObject nodeData = this.nodes.get(nodeIndex).getAsJsonObject();
        JsonArray children = nodeData.getAsJsonArray("children");
        if (children != null) {
            for (JsonElement child : children) {
                int childIndex = child.getAsInt();
                BoneWrapper cbw = this.fetchFromCache("nodes", childIndex, BoneWrapper.class);
                if (cbw != null) {
                    bw.bone.addChild(cbw.bone);
                    bw.children.add(childIndex);
                    continue;
                }
                Node n = new Node();
                this.readChild((Spatial)n, child);
                Spatial s = n.getChild(0);
                s.removeFromParent();
                bw.attachedSpatial = s;
            }
        }
    }

    private void setupControls() {
        for (SkinData skinData : this.skinnedSpatials.keySet()) {
            List<Spatial> spatials = this.skinnedSpatials.get(skinData);
            if (spatials.isEmpty()) continue;
            Spatial spatial = spatials.size() >= 1 ? GltfUtils.findCommonAncestor(spatials) : spatials.get(0);
            AnimControl animControl = (AnimControl)spatial.getControl(AnimControl.class);
            if (animControl != null) {
                for (String name : animControl.getAnimationNames()) {
                    Animation anim = animControl.getAnim(name);
                    skinData.animControl.addAnim(anim);
                }
                spatial.removeControl((Control)animControl);
            }
            if (skinData.animControl != null) {
                spatial.addControl((Control)skinData.animControl);
            }
            spatial.addControl((Control)skinData.skeletonControl);
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            BoneWrapper bw = this.fetchFromCache("nodes", i, BoneWrapper.class);
            if (bw == null || bw.attachedSpatial == null) continue;
            SkinData skinData = this.fetchFromCache("skins", bw.skinIndex, SkinData.class);
            skinData.skeletonControl.getAttachmentsNode(bw.bone.getName()).attachChild(bw.attachedSpatial);
        }
    }

    private String readMeshName(int meshIndex) {
        JsonObject meshData = this.meshes.get(meshIndex).getAsJsonObject();
        return GltfUtils.getAsString(meshData, "name");
    }

    public <T> T fetchFromCache(String name, int index, Class<T> type) {
        Object[] data = this.dataCache.get(name);
        if (data == null) {
            return null;
        }
        try {
            T ret = type.cast(data[index]);
            return ret;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public void addToCache(String name, int index, Object object, int maxLength) {
        Object[] data = this.dataCache.get(name);
        if (data == null) {
            data = new Object[maxLength];
            this.dataCache.put(name, data);
        }
        data[index] = object;
    }

    public AssetInfo getInfo() {
        return this.info;
    }

    public JsonObject getDocRoot() {
        return this.docRoot;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    static {
        defaultMaterialAdapters.put("pbrMetallicRoughness", new PBRMetalRoughMaterialAdapter());
    }

    private class JointArrayPopulator
    implements Populator<SkinBuffers> {
        private JointArrayPopulator() {
        }

        @Override
        public SkinBuffers populate(Integer bufferViewIndex, int componentType, String type, int count, int byteOffset, boolean normalized) throws IOException {
            int numComponents = GltfUtils.getNumberOfComponents(type);
            VertexBuffer.Format format = VertexBuffer.Format.Byte;
            if (componentType == 5123) {
                format = VertexBuffer.Format.Short;
            }
            int dataSize = numComponents * count;
            short[] data = new short[dataSize];
            if (bufferViewIndex == null) {
                GltfUtils.padBuffer(data, dataSize);
            } else {
                GltfLoader.this.readBuffer(bufferViewIndex, byteOffset, count, data, numComponents, format);
            }
            return new SkinBuffers(data, format.getComponentSize());
        }
    }

    private class Matrix4fArrayPopulator
    implements Populator<Matrix4f[]> {
        private Matrix4fArrayPopulator() {
        }

        @Override
        public Matrix4f[] populate(Integer bufferViewIndex, int componentType, String type, int count, int byteOffset, boolean normalized) throws IOException {
            int numComponents = GltfUtils.getNumberOfComponents(type);
            int dataSize = numComponents * count;
            Matrix4f[] data = new Matrix4f[count];
            if (bufferViewIndex == null) {
                GltfUtils.padBuffer(data, dataSize);
            } else {
                GltfLoader.this.readBuffer(bufferViewIndex, byteOffset, count, data, numComponents, GltfUtils.getVertexBufferFormat(componentType));
            }
            return data;
        }
    }

    private class QuaternionArrayPopulator
    implements Populator<Quaternion[]> {
        private QuaternionArrayPopulator() {
        }

        @Override
        public Quaternion[] populate(Integer bufferViewIndex, int componentType, String type, int count, int byteOffset, boolean normalized) throws IOException {
            int numComponents = GltfUtils.getNumberOfComponents(type);
            int dataSize = numComponents * count;
            Quaternion[] data = new Quaternion[count];
            if (bufferViewIndex == null) {
                GltfUtils.padBuffer(data, dataSize);
            } else {
                GltfLoader.this.readBuffer(bufferViewIndex, byteOffset, count, data, numComponents, GltfUtils.getVertexBufferFormat(componentType));
            }
            return data;
        }
    }

    private class Vector3fArrayPopulator
    implements Populator<Vector3f[]> {
        private Vector3fArrayPopulator() {
        }

        @Override
        public Vector3f[] populate(Integer bufferViewIndex, int componentType, String type, int count, int byteOffset, boolean normalized) throws IOException {
            int numComponents = GltfUtils.getNumberOfComponents(type);
            int dataSize = numComponents * count;
            Vector3f[] data = new Vector3f[count];
            if (bufferViewIndex == null) {
                GltfUtils.padBuffer(data, dataSize);
            } else {
                GltfLoader.this.readBuffer(bufferViewIndex, byteOffset, count, data, numComponents, GltfUtils.getVertexBufferFormat(componentType));
            }
            return data;
        }
    }

    private class FloatArrayPopulator
    implements Populator<float[]> {
        private FloatArrayPopulator() {
        }

        @Override
        public float[] populate(Integer bufferViewIndex, int componentType, String type, int count, int byteOffset, boolean normalized) throws IOException {
            int numComponents = GltfUtils.getNumberOfComponents(type);
            int dataSize = numComponents * count;
            float[] data = new float[dataSize];
            if (bufferViewIndex == null) {
                GltfUtils.padBuffer(data, dataSize);
            } else {
                GltfLoader.this.readBuffer(bufferViewIndex, byteOffset, count, data, numComponents, GltfUtils.getVertexBufferFormat(componentType));
            }
            return data;
        }
    }

    private class VertexBufferPopulator
    implements Populator<VertexBuffer> {
        VertexBuffer.Type bufferType;

        public VertexBufferPopulator(VertexBuffer.Type bufferType) {
            this.bufferType = bufferType;
        }

        @Override
        public VertexBuffer populate(Integer bufferViewIndex, int componentType, String type, int count, int byteOffset, boolean normalized) throws IOException {
            VertexBuffer.Format format;
            if (this.bufferType == null) {
                logger.log(Level.WARNING, "could not assign data to any VertexBuffer type for buffer view " + bufferViewIndex);
                return null;
            }
            VertexBuffer vb = new VertexBuffer(this.bufferType);
            VertexBuffer.Format originalFormat = format = GltfUtils.getVertexBufferFormat(componentType);
            if (normalized) {
                format = VertexBuffer.Format.Float;
            }
            int numComponents = GltfUtils.getNumberOfComponents(type);
            Buffer buff = VertexBuffer.createBuffer((VertexBuffer.Format)format, (int)numComponents, (int)count);
            int bufferSize = numComponents * count;
            if (bufferViewIndex == null) {
                GltfUtils.padBuffer(buff, bufferSize);
            } else {
                GltfLoader.this.readBuffer(bufferViewIndex, byteOffset, count, buff, numComponents, originalFormat);
            }
            if (this.bufferType == VertexBuffer.Type.Index) {
                numComponents = 3;
            }
            vb.setupData(VertexBuffer.Usage.Dynamic, numComponents, format, buff);
            return vb;
        }
    }

    private static interface Populator<T> {
        public T populate(Integer var1, int var2, String var3, int var4, int var5, boolean var6) throws IOException;
    }

    private class TextureData {
        byte[] data;

        private TextureData() {
        }
    }

    public static class SkinBuffers {
        short[] joints;
        float[] weights;
        int componentSize;

        public SkinBuffers(short[] joints, int componentSize) {
            this.joints = joints;
            this.componentSize = componentSize;
        }

        public SkinBuffers() {
        }
    }

    private class SkinData {
        SkeletonControl skeletonControl;
        AnimControl animControl;
        Transform armatureTransforms;

        private SkinData() {
        }
    }

    private class BoneWrapper {
        Bone bone;
        int boneIndex;
        int skinIndex;
        Transform localTransform;
        Matrix4f modelBindMatrix;
        boolean isRoot = false;
        boolean localUpdated = false;
        Spatial attachedSpatial;
        List<Integer> children = new ArrayList<Integer>();

        public BoneWrapper(Bone bone, int boneIndex, int skinIndex, Matrix4f modelBindMatrix, Transform localTransform) {
            this.bone = bone;
            this.boneIndex = boneIndex;
            this.skinIndex = skinIndex;
            this.modelBindMatrix = modelBindMatrix;
            this.localTransform = localTransform;
        }

        public void update(TrackData data) {
            Transform bindTransforms = new Transform(this.bone.getBindPosition(), this.bone.getBindRotation(), this.bone.getBindScale());
            SkinData skinData = GltfLoader.this.fetchFromCache("skins", this.skinIndex, SkinData.class);
            if (!this.localUpdated) {
                this.reverseBlendAnimTransforms(this.localTransform, bindTransforms);
                this.localUpdated = true;
            }
            for (int i = 0; i < data.getNbKeyFrames(); ++i) {
                Vector3f translation = this.getTranslation(data, bindTransforms, i);
                Quaternion rotation = this.getRotation(data, bindTransforms, i);
                Vector3f scale = this.getScale(data, bindTransforms, i);
                Transform t = new Transform(translation, rotation, scale);
                if (this.isRoot) {
                    t.combineWithParent(skinData.armatureTransforms);
                }
                this.reverseBlendAnimTransforms(t, bindTransforms);
                if (data.translations != null) {
                    data.translations[i] = t.getTranslation();
                }
                if (data.rotations != null) {
                    data.rotations[i] = t.getRotation();
                }
                if (data.scales == null) continue;
                data.scales[i] = t.getScale();
            }
            data.ensureTranslationRotations(this.localTransform);
        }

        private void reverseBlendAnimTransforms(Transform t, Transform bindTransforms) {
            t.getTranslation().subtractLocal(bindTransforms.getTranslation());
            t.getScale().divideLocal(bindTransforms.getScale());
            GltfLoader.this.tmpQuat.set(bindTransforms.getRotation()).inverseLocal().multLocal(t.getRotation());
            t.setRotation(GltfLoader.this.tmpQuat);
        }

        private Vector3f getTranslation(TrackData data, Transform bindTransforms, int i) {
            Vector3f translation = data.translations == null ? bindTransforms.getTranslation() : data.translations[i];
            return translation;
        }

        private Quaternion getRotation(TrackData data, Transform bindTransforms, int i) {
            Quaternion rotation = data.rotations == null ? bindTransforms.getRotation() : data.rotations[i];
            return rotation;
        }

        private Vector3f getScale(TrackData data, Transform bindTransforms, int i) {
            Vector3f scale = data.scales == null ? bindTransforms.getScale() : data.scales[i];
            return scale;
        }
    }

    public static class WeightData {
        float value;
        short index;
        int componentSize;

        public WeightData(float value, short index, int componentSize) {
            this.value = value;
            this.index = index;
            this.componentSize = componentSize;
        }
    }
}

