/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.anim;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.asset.AssetManager;
import com.jme3.scene.plugins.fbx.node.FbxNode;
import java.util.ArrayList;
import java.util.List;

public class FbxLimbNode
extends FbxNode {
    protected FbxNode skeletonHolder;
    protected Bone bone;

    public FbxLimbNode(AssetManager assetManager, String sceneFolderName) {
        super(assetManager, sceneFolderName);
    }

    private static void createBones(FbxNode skeletonHolderNode, FbxLimbNode limb, List<Bone> bones) {
        limb.skeletonHolder = skeletonHolderNode;
        Bone parentBone = limb.getJmeBone();
        bones.add(parentBone);
        for (FbxNode child : limb.children) {
            if (!(child instanceof FbxLimbNode)) continue;
            FbxLimbNode childLimb = (FbxLimbNode)child;
            FbxLimbNode.createBones(skeletonHolderNode, childLimb, bones);
            parentBone.addChild(childLimb.getJmeBone());
        }
    }

    public static Skeleton createSkeleton(FbxNode skeletonHolderNode) {
        if (skeletonHolderNode instanceof FbxLimbNode) {
            throw new UnsupportedOperationException("Limb nodes cannot be skeleton holders");
        }
        ArrayList<Bone> bones = new ArrayList<Bone>();
        for (FbxNode child : skeletonHolderNode.getChildren()) {
            if (!(child instanceof FbxLimbNode)) continue;
            FbxLimbNode.createBones(skeletonHolderNode, (FbxLimbNode)child, bones);
        }
        return new Skeleton(bones.toArray(new Bone[0]));
    }

    public FbxNode getSkeletonHolder() {
        return this.skeletonHolder;
    }

    public Bone getJmeBone() {
        if (this.bone == null) {
            this.bone = new Bone(this.name);
            this.bone.setBindTransforms(this.jmeLocalBindPose.getTranslation(), this.jmeLocalBindPose.getRotation(), this.jmeLocalBindPose.getScale());
        }
        return this.bone;
    }
}

