/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotDescription;

import java.util.List;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.robotDescription.JointDescription;

public class OneDoFJointDescription
extends JointDescription {
    private boolean containsLimitStops;
    private double qMin = Double.NEGATIVE_INFINITY;
    private double qMax = Double.POSITIVE_INFINITY;
    private double kLimit;
    private double bLimit;
    private double effortLimit = Double.POSITIVE_INFINITY;
    private double velocityLimit = Double.POSITIVE_INFINITY;
    private double velocityDamping;
    private double damping;
    private double stiction;
    private final Vector3D jointAxis = new Vector3D();

    public OneDoFJointDescription(String name, Tuple3DReadOnly offset, Vector3DReadOnly jointAxis) {
        super(name, offset);
        this.jointAxis.set((Tuple3DReadOnly)jointAxis);
    }

    public OneDoFJointDescription(OneDoFJointDescription other) {
        super(other);
        this.jointAxis.set(other.jointAxis);
        this.containsLimitStops = other.containsLimitStops;
        this.qMin = other.qMin;
        this.qMax = other.qMax;
        this.kLimit = other.kLimit;
        this.bLimit = other.bLimit;
        this.effortLimit = other.effortLimit;
        this.velocityLimit = other.velocityLimit;
        this.velocityDamping = other.velocityDamping;
        this.damping = other.damping;
        this.stiction = other.stiction;
    }

    public void setVelocityLimits(double velocityLimit, double velocityDamping) {
        this.velocityLimit = velocityLimit;
        this.velocityDamping = velocityDamping;
    }

    public void setDamping(double damping) {
        this.damping = damping;
    }

    public double getDamping() {
        return this.damping;
    }

    public double getStiction() {
        return this.stiction;
    }

    public double getVelocityLimit() {
        return this.velocityLimit;
    }

    public double getVelocityDamping() {
        return this.velocityDamping;
    }

    public void setStiction(double stiction) {
        this.stiction = stiction;
    }

    public void setLimitStops(double qMin, double qMax, double kLimit, double bLimit) {
        this.containsLimitStops = true;
        this.qMin = qMin;
        this.qMax = qMax;
        this.kLimit = kLimit;
        this.bLimit = bLimit;
    }

    public Vector3DReadOnly getJointAxis() {
        return this.jointAxis;
    }

    public void getJointAxis(Vector3DBasics jointAxisToPack) {
        jointAxisToPack.set((Tuple3DReadOnly)this.jointAxis);
    }

    public boolean containsLimitStops() {
        return this.containsLimitStops;
    }

    public double[] getLimitStopParameters() {
        return new double[]{this.qMin, this.qMax, this.kLimit, this.bLimit};
    }

    public double getLowerLimit() {
        return this.qMin;
    }

    public double getUpperLimit() {
        return this.qMax;
    }

    public void setEffortLimit(double effortLimit) {
        this.effortLimit = effortLimit;
    }

    public double getEffortLimit() {
        return this.effortLimit;
    }

    @Override
    public void scale(double factor, double massScalePower, List<String> ignoreInertiaScaleJointList) {
        double massScale = Math.pow(factor, massScalePower);
        this.damping = massScale * this.damping;
        this.kLimit = massScale * this.kLimit;
        this.bLimit = massScale * this.bLimit;
        this.velocityDamping = massScale * this.velocityDamping;
        super.scale(factor, massScalePower, ignoreInertiaScaleJointList);
    }

    @Override
    public OneDoFJointDescription copy() {
        return new OneDoFJointDescription(this);
    }
}

