/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotDescription;

import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.robotDescription.JointDescription;
import us.ihmc.robotics.robotDescription.LinkDescription;
import us.ihmc.robotics.robotDescription.RobotDescriptionNode;

public class LoopClosureConstraintDescription
implements RobotDescriptionNode {
    private String name;
    private JointDescription parentJoint;
    private final Vector3D offsetFromParentJoint = new Vector3D();
    private LinkDescription link;
    private final Vector3D offsetFromLinkParentJoint = new Vector3D();
    private final Matrix3D constraintForceSubSpace = LoopClosureConstraintDescription.identity();
    private final Matrix3D constraintMomentSubSpace = LoopClosureConstraintDescription.identity();
    private final Vector3D proportionalGains = new Vector3D(Double.NaN, Double.NaN, Double.NaN);
    private final Vector3D derivativeGains = new Vector3D(Double.NaN, Double.NaN, Double.NaN);

    public static Matrix3D identity() {
        Matrix3D identity = new Matrix3D();
        identity.setIdentity();
        return identity;
    }

    public static Matrix3D matrix3DOrthogonalToVector3D(Vector3DReadOnly vector3D) {
        Matrix3D orthogonalMatrix = new Matrix3D();
        LoopClosureConstraintDescription.matrix3DOrthogonalToVector3D(vector3D, (Matrix3DBasics)orthogonalMatrix);
        return orthogonalMatrix;
    }

    public static void matrix3DOrthogonalToVector3D(Vector3DReadOnly vector3D, Matrix3DBasics orthogonalMatrixToPack) {
        RotationMatrix R = new RotationMatrix();
        EuclidGeometryTools.orientation3DFromZUpToVector3D((Vector3DReadOnly)vector3D, (Orientation3DBasics)R);
        orthogonalMatrixToPack.setIdentity();
        orthogonalMatrixToPack.setM22(0.0);
        R.transform(orthogonalMatrixToPack);
    }

    public LoopClosureConstraintDescription(String name, Tuple3DReadOnly offsetFromParentJoint, Tuple3DReadOnly offsetFromLinkParentJoint) {
        this.name = name;
        this.offsetFromParentJoint.set(offsetFromParentJoint);
        this.offsetFromLinkParentJoint.set(offsetFromLinkParentJoint);
    }

    public LoopClosureConstraintDescription(LoopClosureConstraintDescription other) {
        this.name = other.name;
        this.offsetFromParentJoint.set(other.offsetFromParentJoint);
        this.offsetFromLinkParentJoint.set(other.offsetFromLinkParentJoint);
        this.constraintForceSubSpace.set(other.constraintForceSubSpace);
        this.constraintMomentSubSpace.set(other.constraintMomentSubSpace);
        this.proportionalGains.set(other.proportionalGains);
        this.derivativeGains.set(other.derivativeGains);
    }

    public LoopClosureConstraintDescription(String name, Tuple3DReadOnly offsetFromParentJoint, Tuple3DReadOnly offsetFromLinkParentJoint, Matrix3DReadOnly constraintForceSubSpace, Matrix3DReadOnly constraintMomentSubSpace) {
        this(name, offsetFromParentJoint, offsetFromLinkParentJoint);
        this.constraintForceSubSpace.set(constraintForceSubSpace);
        this.constraintMomentSubSpace.set(constraintMomentSubSpace);
    }

    public void setGains(double proportionalGain, double derivativeGain) {
        this.proportionalGains.set(proportionalGain, proportionalGain, proportionalGain);
        this.derivativeGains.set(derivativeGain, derivativeGain, derivativeGain);
    }

    public void setGains(Tuple3DReadOnly proportionalGains, Tuple3DReadOnly derivativeGains) {
        this.proportionalGains.set(proportionalGains);
        this.derivativeGains.set(derivativeGains);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setParentJoint(JointDescription parentJoint) {
        this.parentJoint = parentJoint;
    }

    public void setOffsetFromParentJoint(Tuple3DReadOnly offset) {
        this.offsetFromParentJoint.set(offset);
    }

    public JointDescription getParentJoint() {
        return this.parentJoint;
    }

    public Vector3DBasics getOffsetFromParentJoint() {
        return this.offsetFromParentJoint;
    }

    public Vector3DBasics getOffsetFromLinkParentJoint() {
        return this.offsetFromLinkParentJoint;
    }

    public LinkDescription getLink() {
        return this.link;
    }

    public void setLink(LinkDescription link) {
        this.link = link;
    }

    @Override
    public List<JointDescription> getChildrenJoints() {
        return Collections.emptyList();
    }

    public Matrix3DBasics getConstraintForceSubSpace() {
        return this.constraintForceSubSpace;
    }

    public Matrix3DBasics getConstraintMomentSubSpace() {
        return this.constraintMomentSubSpace;
    }

    public Vector3DBasics getProportionalGains() {
        return this.proportionalGains;
    }

    public Vector3DBasics getDerivativeGains() {
        return this.derivativeGains;
    }

    @Override
    public void scale(double factor, double massScalePower, List<String> ignoreInertiaScaleJointList) {
    }

    @Override
    public LoopClosureConstraintDescription copy() {
        return new LoopClosureConstraintDescription(this);
    }
}

