/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotDescription;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.robotics.robotDescription.CollisionMeshDescription;
import us.ihmc.robotics.robotDescription.InertiaTools;
import us.ihmc.robotics.robotDescription.LinkGraphicsDescription;

public class LinkDescription {
    private String name;
    private double mass;
    private final Vector3D centerOfMassOffset = new Vector3D();
    private final DMatrixRMaj momentOfInertia = new DMatrixRMaj(3, 3);
    private final Vector3D principalMomentsOfInertia = new Vector3D();
    private final RotationMatrix principalAxesRotation = new RotationMatrix();
    private LinkGraphicsDescription linkGraphics;
    private final List<CollisionMeshDescription> collisionMeshes = new ArrayList<CollisionMeshDescription>();

    public LinkDescription(String name) {
        this.name = name;
    }

    public LinkDescription(LinkDescription other) {
        this.name = other.name;
        this.mass = other.mass;
        this.centerOfMassOffset.set(other.centerOfMassOffset);
        this.momentOfInertia.set((DMatrixD1)other.momentOfInertia);
        this.principalMomentsOfInertia.set(other.principalMomentsOfInertia);
        this.principalAxesRotation.set(other.principalAxesRotation);
        this.linkGraphics = new LinkGraphicsDescription();
        this.linkGraphics.combine(other.linkGraphics);
        other.collisionMeshes.forEach(collisionMesh -> this.collisionMeshes.add(collisionMesh.copy()));
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LinkGraphicsDescription getLinkGraphics() {
        return this.linkGraphics;
    }

    public void setLinkGraphics(LinkGraphicsDescription linkGraphics) {
        this.linkGraphics = linkGraphics;
    }

    public List<CollisionMeshDescription> getCollisionMeshes() {
        return this.collisionMeshes;
    }

    public void addCollisionMesh(CollisionMeshDescription collisionMesh) {
        this.collisionMeshes.add(collisionMesh);
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        if (mass < 0.0) {
            throw new RuntimeException("mass < 0.0");
        }
        this.mass = mass;
    }

    public void getCenterOfMassOffset(Tuple3DBasics centerOfMassOffsetToPack) {
        centerOfMassOffsetToPack.set((Tuple3DReadOnly)this.centerOfMassOffset);
    }

    public Vector3D getCenterOfMassOffset() {
        return this.centerOfMassOffset;
    }

    public void setCenterOfMassOffset(Tuple3DReadOnly centerOfMassOffset) {
        this.centerOfMassOffset.set(centerOfMassOffset);
    }

    public void setCenterOfMassOffset(double xOffset, double yOffset, double zOffset) {
        this.centerOfMassOffset.set(xOffset, yOffset, zOffset);
    }

    public void setMomentOfInertia(DMatrix momentOfInertia) {
        this.momentOfInertia.set((Matrix)momentOfInertia);
    }

    public void setMomentOfInertia(Matrix3DReadOnly momentOfInertia) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.momentOfInertia.set(i, j, momentOfInertia.getElement(i, j));
            }
        }
    }

    public Matrix3D getMomentOfInertiaCopy() {
        Matrix3D momentOfInertia = new Matrix3D();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                momentOfInertia.setElement(i, j, this.momentOfInertia.get(i, j));
            }
        }
        return momentOfInertia;
    }

    public void setMassAndRadiiOfGyration(double mass, double radiusOfGyrationX, double radiusOfGyrationY, double radiusOfGyrationZ) {
        this.mass = mass;
        double Ixx = mass * (radiusOfGyrationY * radiusOfGyrationY + radiusOfGyrationZ * radiusOfGyrationZ);
        double Iyy = mass * (radiusOfGyrationX * radiusOfGyrationX + radiusOfGyrationZ * radiusOfGyrationZ);
        double Izz = mass * (radiusOfGyrationX * radiusOfGyrationX + radiusOfGyrationY * radiusOfGyrationY);
        this.setMomentOfInertia(Ixx, Iyy, Izz);
    }

    public void getMomentOfInertia(DMatrix momentOfInertiaToPack) {
        momentOfInertiaToPack.set((Matrix)this.momentOfInertia);
    }

    public DMatrixRMaj getMomentOfInertia() {
        return this.momentOfInertia;
    }

    public void setMomentOfInertia(double Ixx, double Iyy, double Izz) {
        this.momentOfInertia.zero();
        this.momentOfInertia.set(0, 0, Ixx);
        this.momentOfInertia.set(1, 1, Iyy);
        this.momentOfInertia.set(2, 2, Izz);
    }

    public void addEllipsoidFromMassProperties() {
        this.addEllipsoidFromMassProperties(null);
    }

    public void addCoordinateSystemToCOM(double length) {
        this.linkGraphics.identity();
        Vector3D comOffset = new Vector3D();
        this.getCenterOfMassOffset((Tuple3DBasics)comOffset);
        this.linkGraphics.translate(comOffset.getX(), comOffset.getY(), comOffset.getZ());
        this.linkGraphics.addCoordinateSystem(length);
        this.linkGraphics.identity();
    }

    public void addEllipsoidFromMassProperties2(AppearanceDefinition appearance) {
        this.computePrincipalMomentsOfInertia();
        Vector3D inertiaEllipsoidRadii = InertiaTools.getInertiaEllipsoidRadii(this.principalMomentsOfInertia, this.mass);
        ArrayList<Vector3D> inertiaEllipsoidAxes = new ArrayList<Vector3D>();
        Vector3D e1 = new Vector3D();
        this.principalAxesRotation.getColumn(0, (Tuple3DBasics)e1);
        e1.normalize();
        e1.scale(inertiaEllipsoidRadii.getX());
        inertiaEllipsoidAxes.add(e1);
        Vector3D e2 = new Vector3D();
        this.principalAxesRotation.getColumn(1, (Tuple3DBasics)e2);
        e2.normalize();
        e2.scale(inertiaEllipsoidRadii.getY());
        inertiaEllipsoidAxes.add(e2);
        Vector3D e3 = new Vector3D();
        this.principalAxesRotation.getColumn(2, (Tuple3DBasics)e3);
        e3.normalize();
        e3.scale(inertiaEllipsoidRadii.getZ());
        inertiaEllipsoidAxes.add(e3);
        Vector3D e4 = new Vector3D((Tuple3DReadOnly)e1);
        e4.negate();
        inertiaEllipsoidAxes.add(e4);
        Vector3D e5 = new Vector3D((Tuple3DReadOnly)e2);
        e5.negate();
        inertiaEllipsoidAxes.add(e5);
        Vector3D e6 = new Vector3D((Tuple3DReadOnly)e3);
        e6.negate();
        inertiaEllipsoidAxes.add(e6);
        double vertexSize = 0.01 * inertiaEllipsoidRadii.length();
        Vector3D comOffset = new Vector3D();
        this.getCenterOfMassOffset((Tuple3DBasics)comOffset);
        for (Vector3D vector : inertiaEllipsoidAxes) {
            this.linkGraphics.identity();
            this.linkGraphics.translate(comOffset.getX(), comOffset.getY(), comOffset.getZ());
            this.linkGraphics.translate((Tuple3DReadOnly)vector);
            this.linkGraphics.addCube(vertexSize, vertexSize, vertexSize, appearance);
        }
        ArrayList<Point3D> inertiaOctahedronVertices = new ArrayList<Point3D>();
        Point3D p1 = new Point3D((Tuple3DReadOnly)e1);
        inertiaOctahedronVertices.add(p1);
        Point3D p2 = new Point3D((Tuple3DReadOnly)e2);
        inertiaOctahedronVertices.add(p2);
        Point3D p3 = new Point3D((Tuple3DReadOnly)e4);
        inertiaOctahedronVertices.add(p3);
        Point3D p4 = new Point3D((Tuple3DReadOnly)e5);
        inertiaOctahedronVertices.add(p4);
        Point3D p5 = new Point3D((Tuple3DReadOnly)e3);
        inertiaOctahedronVertices.add(p5);
        Point3D p6 = new Point3D((Tuple3DReadOnly)e6);
        inertiaOctahedronVertices.add(p6);
        ArrayList<Point3D> face1 = new ArrayList<Point3D>();
        face1.add(p1);
        face1.add(p5);
        face1.add(p4);
        ArrayList<Point3D> face2 = new ArrayList<Point3D>();
        face2.add(p4);
        face2.add(p5);
        face2.add(p3);
        ArrayList<Point3D> face3 = new ArrayList<Point3D>();
        face3.add(p3);
        face3.add(p5);
        face3.add(p2);
        ArrayList<Point3D> face4 = new ArrayList<Point3D>();
        face4.add(p2);
        face4.add(p5);
        face4.add(p1);
        ArrayList<Point3D> face5 = new ArrayList<Point3D>();
        face5.add(p4);
        face5.add(p6);
        face5.add(p1);
        ArrayList<Point3D> face6 = new ArrayList<Point3D>();
        face6.add(p3);
        face6.add(p6);
        face6.add(p4);
        ArrayList<Point3D> face7 = new ArrayList<Point3D>();
        face7.add(p2);
        face7.add(p6);
        face7.add(p3);
        ArrayList<Point3D> face8 = new ArrayList<Point3D>();
        face8.add(p1);
        face8.add(p6);
        face8.add(p2);
        this.linkGraphics.identity();
        this.linkGraphics.translate(comOffset.getX(), comOffset.getY(), comOffset.getZ());
        this.linkGraphics.addPolygon(face1, appearance);
        this.linkGraphics.addPolygon(face2, appearance);
        this.linkGraphics.addPolygon(face3, appearance);
        this.linkGraphics.addPolygon(face4, appearance);
        this.linkGraphics.addPolygon(face5, appearance);
        this.linkGraphics.addPolygon(face6, appearance);
        this.linkGraphics.addPolygon(face7, appearance);
        this.linkGraphics.addPolygon(face8, appearance);
    }

    public void addEllipsoidFromMassProperties(AppearanceDefinition appearance) {
        this.computePrincipalMomentsOfInertia();
        Vector3D inertiaEllipsoidRadii = InertiaTools.getInertiaEllipsoidRadii(this.principalMomentsOfInertia, this.mass);
        if (appearance == null) {
            appearance = YoAppearance.Black();
        }
        Vector3D comOffset = new Vector3D();
        this.getCenterOfMassOffset((Tuple3DBasics)comOffset);
        this.linkGraphics.identity();
        this.linkGraphics.translate(comOffset.getX(), comOffset.getY(), comOffset.getZ());
        this.linkGraphics.rotate((Orientation3DReadOnly)this.principalAxesRotation);
        this.linkGraphics.addEllipsoid(inertiaEllipsoidRadii.getX(), inertiaEllipsoidRadii.getY(), inertiaEllipsoidRadii.getZ(), appearance);
        this.linkGraphics.identity();
    }

    public void addBoxFromMassProperties(AppearanceDefinition appearance) {
        Vector3D comOffset = new Vector3D();
        this.getCenterOfMassOffset((Tuple3DBasics)comOffset);
        if (this.mass <= 0.0 || this.momentOfInertia.get(0, 0) <= 0.0 || this.momentOfInertia.get(1, 1) <= 0.0 || this.momentOfInertia.get(2, 2) <= 0.0 || this.momentOfInertia.get(0, 0) + this.momentOfInertia.get(1, 1) <= this.momentOfInertia.get(2, 2) || this.momentOfInertia.get(1, 1) + this.momentOfInertia.get(2, 2) <= this.momentOfInertia.get(0, 0) || this.momentOfInertia.get(0, 0) + this.momentOfInertia.get(2, 2) <= this.momentOfInertia.get(1, 1)) {
            System.err.println(this.getName() + " has unrealistic inertia");
        } else {
            this.linkGraphics.identity();
            this.linkGraphics.translate(comOffset.getX(), comOffset.getY(), comOffset.getZ());
            double lx = Math.sqrt(6.0 * (this.momentOfInertia.get(2, 2) + this.momentOfInertia.get(1, 1) - this.momentOfInertia.get(0, 0)) / this.mass);
            double ly = Math.sqrt(6.0 * (this.momentOfInertia.get(2, 2) + this.momentOfInertia.get(0, 0) - this.momentOfInertia.get(1, 1)) / this.mass);
            double lz = Math.sqrt(6.0 * (this.momentOfInertia.get(0, 0) + this.momentOfInertia.get(1, 1) - this.momentOfInertia.get(2, 2)) / this.mass);
            this.linkGraphics.translate(0.0, 0.0, -lz / 2.0);
            this.linkGraphics.addCube(lx, ly, lz, appearance);
            this.linkGraphics.identity();
        }
    }

    public void computePrincipalMomentsOfInertia() {
        InertiaTools.computePrincipalMomentsOfInertia(this.momentOfInertia, this.principalAxesRotation, this.principalMomentsOfInertia);
    }

    public void scale(double factor, double massScalePower, boolean scaleInertia) {
        this.centerOfMassOffset.scale(factor);
        if (scaleInertia) {
            this.mass = Math.pow(factor, massScalePower) * this.mass;
            double inertiaScale = Math.pow(factor, massScalePower + 2.0);
            CommonOps_DDRM.scale((double)inertiaScale, (DMatrixD1)this.momentOfInertia);
            this.computePrincipalMomentsOfInertia();
        }
        if (this.linkGraphics != null) {
            this.linkGraphics.preScale(factor);
        }
        if (this.collisionMeshes != null) {
            for (int i = 0; i < this.collisionMeshes.size(); ++i) {
                this.collisionMeshes.get(i).scale(factor);
            }
        }
    }

    public LinkDescription copy() {
        return new LinkDescription(this);
    }

    public String toString() {
        return "Link: " + this.name;
    }
}

