/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotDescription;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.decomposition.svd.SvdImplicitQrDecompose_DDRM;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;

public class InertiaTools {
    public static Vector3D getInertiaEllipsoidRadii(Vector3D principalMomentsOfInertia, double mass) {
        double Ixx = principalMomentsOfInertia.getX();
        double Iyy = principalMomentsOfInertia.getY();
        double Izz = principalMomentsOfInertia.getZ();
        Vector3D ret = new Vector3D();
        ret.setX(Math.sqrt(2.5 * (Iyy + Izz - Ixx) / mass));
        ret.setY(Math.sqrt(2.5 * (Izz + Ixx - Iyy) / mass));
        ret.setZ(Math.sqrt(2.5 * (Ixx + Iyy - Izz) / mass));
        return ret;
    }

    public static Matrix3D rotate(RigidBodyTransform inertialFrameRotation, Matrix3D inertia) {
        RotationMatrix temp = new RotationMatrix();
        temp.set((RotationMatrixReadOnly)inertialFrameRotation.getRotation());
        return InertiaTools.rotate(temp, inertia);
    }

    public static Matrix3D rotate(RotationMatrix inertialFrameRotation, Matrix3D inertia) {
        Matrix3D result = new Matrix3D();
        result.set(inertia);
        inertialFrameRotation.transform((Matrix3DBasics)result);
        return result;
    }

    public static void computePrincipalMomentsOfInertia(Matrix3D Inertia, RotationMatrix principalAxesRotationToPack, Vector3D principalMomentsOfInertiaToPack) {
        DMatrixRMaj inertiaForSVD = new DMatrixRMaj(3, 3);
        Inertia.get((DMatrix)inertiaForSVD);
        InertiaTools.computePrincipalMomentsOfInertia(inertiaForSVD, principalAxesRotationToPack, principalMomentsOfInertiaToPack);
    }

    public static void computePrincipalMomentsOfInertia(DMatrixRMaj inertiaForSVD, RotationMatrix principalAxesRotationToPack, Vector3D principalMomentsOfInertiaToPack) {
        SvdImplicitQrDecompose_DDRM svd = new SvdImplicitQrDecompose_DDRM(true, false, true, false);
        svd.decompose((Matrix)inertiaForSVD);
        DMatrixRMaj W = (DMatrixRMaj)svd.getW(null);
        DMatrixRMaj V = (DMatrixRMaj)svd.getV(null, false);
        double determinant = CommonOps_DDRM.det((DMatrixRMaj)V);
        if (determinant < 0.0) {
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)V);
            determinant = -determinant;
        }
        if (Math.abs(determinant - 1.0) > 1.0E-5) {
            throw new RuntimeException("Problem in Link.addEllipsoidFromMassProperties(). Determinant should be 1.0");
        }
        principalMomentsOfInertiaToPack.set(W.get(0, 0), W.get(1, 1), W.get(2, 2));
        principalAxesRotationToPack.set((DMatrix)V);
    }
}

