/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotDescription;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.robotDescription.CollisionMasksHelper;
import us.ihmc.robotics.robotDescription.CollisionMeshDescription;

public class CollisionMasksHelperTest {
    @Test
    public void testCollisionMasksHelper() {
        CollisionMeshDescription objectOne = new CollisionMeshDescription();
        CollisionMeshDescription objectTwo = new CollisionMeshDescription();
        CollisionMeshDescription objectThree = new CollisionMeshDescription();
        CollisionMeshDescription objectFour = new CollisionMeshDescription();
        CollisionMeshDescription objectFive = new CollisionMeshDescription();
        CollisionMeshDescription objectSix = new CollisionMeshDescription();
        CollisionMasksHelper helper = new CollisionMasksHelper();
        Assert.assertEquals(1L, helper.getNextGroupBitMask());
        ArrayList<CollisionMeshDescription> groupOne = new ArrayList<CollisionMeshDescription>();
        groupOne.add(objectOne);
        groupOne.add(objectTwo);
        ArrayList<CollisionMeshDescription> groupTwo = new ArrayList<CollisionMeshDescription>();
        groupTwo.add(objectThree);
        groupTwo.add(objectFour);
        helper.addCollisionGroup("GroupOne", groupOne);
        helper.addCollisionGroup("GroupTwo", groupTwo);
        Assert.assertEquals(1L, objectOne.getCollisionGroup());
        Assert.assertEquals(1L, objectTwo.getCollisionGroup());
        Assert.assertEquals(2L, objectThree.getCollisionGroup());
        Assert.assertEquals(2L, objectFour.getCollisionGroup());
        Assert.assertEquals(0L, objectOne.getCollisionMask());
        Assert.assertEquals(0L, objectTwo.getCollisionMask());
        Assert.assertEquals(0L, objectThree.getCollisionMask());
        Assert.assertEquals(0L, objectFour.getCollisionMask());
        helper.setAsSelfCollidingGroup("GroupOne");
        Assert.assertEquals(1L, objectOne.getCollisionMask());
        Assert.assertEquals(1L, objectTwo.getCollisionMask());
        Assert.assertEquals(0L, objectThree.getCollisionMask());
        Assert.assertEquals(0L, objectFour.getCollisionMask());
        helper.setAsSelfCollidingGroup("GroupTwo");
        Assert.assertEquals(1L, objectOne.getCollisionMask());
        Assert.assertEquals(1L, objectTwo.getCollisionMask());
        Assert.assertEquals(2L, objectThree.getCollisionMask());
        Assert.assertEquals(2L, objectFour.getCollisionMask());
        helper.setAsNonSelfCollidingGroup("GroupTwo");
        Assert.assertEquals(1L, objectOne.getCollisionMask());
        Assert.assertEquals(1L, objectTwo.getCollisionMask());
        Assert.assertEquals(0L, objectThree.getCollisionMask());
        Assert.assertEquals(0L, objectFour.getCollisionMask());
        ArrayList<CollisionMeshDescription> groupThree = new ArrayList<CollisionMeshDescription>();
        groupThree.add(objectOne);
        groupThree.add(objectFour);
        helper.addCollisionGroup("GroupThree", groupThree);
        Assert.assertEquals(5L, objectOne.getCollisionGroup());
        Assert.assertEquals(1L, objectTwo.getCollisionGroup());
        Assert.assertEquals(2L, objectThree.getCollisionGroup());
        Assert.assertEquals(6L, objectFour.getCollisionGroup());
        ArrayList<CollisionMeshDescription> groupFour = new ArrayList<CollisionMeshDescription>();
        groupFour.add(objectFive);
        groupFour.add(objectSix);
        helper.addCollisionGroup("GroupFour", groupFour);
        Assert.assertEquals(8L, objectFive.getCollisionGroup());
        Assert.assertEquals(8L, objectFive.getCollisionGroup());
        ArrayList<CollisionMeshDescription> groupFive = new ArrayList<CollisionMeshDescription>();
        groupFive.add(objectSix);
        helper.addCollisionGroup("GroupFive", groupFive);
        Assert.assertEquals(32L, helper.getNextGroupBitMask());
        Assert.assertEquals(24L, objectSix.getCollisionGroup());
        Assert.assertEquals(groupOne, helper.getCollisionGroup("GroupOne"));
        Assert.assertEquals(groupTwo, helper.getCollisionGroup("GroupTwo"));
        Assert.assertEquals(groupThree, helper.getCollisionGroup("GroupThree"));
        Assert.assertEquals(groupFour, helper.getCollisionGroup("GroupFour"));
        Assert.assertEquals(groupFive, helper.getCollisionGroup("GroupFive"));
        helper.setToCollideWithGroup("GroupFour", "GroupTwo");
        Assert.assertEquals(8L, objectThree.getCollisionMask());
        Assert.assertEquals(8L, objectFour.getCollisionMask());
        Assert.assertEquals(2L, objectFive.getCollisionMask());
        Assert.assertEquals(2L, objectSix.getCollisionMask());
        helper.setAsSelfCollidingGroup("GroupFour");
        Assert.assertEquals(8L, objectThree.getCollisionMask());
        Assert.assertEquals(8L, objectFour.getCollisionMask());
        Assert.assertEquals(10L, objectFive.getCollisionMask());
        Assert.assertEquals(10L, objectSix.getCollisionMask());
        helper.setAsNonSelfCollidingGroup("GroupFour");
        Assert.assertEquals(8L, objectThree.getCollisionMask());
        Assert.assertEquals(8L, objectFour.getCollisionMask());
        Assert.assertEquals(2L, objectFive.getCollisionMask());
        Assert.assertEquals(2L, objectSix.getCollisionMask());
        helper.addToCollisionMasks("GroupFour", 96);
        Assert.assertEquals(98L, objectFive.getCollisionMask());
        Assert.assertEquals(98L, objectSix.getCollisionMask());
    }

    @Test
    public void testMaxNumberOfGroupsInCollisionMasksHelper() {
        CollisionMasksHelper helper = new CollisionMasksHelper();
        for (int i = 0; i < 32; ++i) {
            ArrayList group = new ArrayList();
            helper.addCollisionGroup("Group" + i, group);
        }
        ArrayList<CollisionMeshDescription> group32 = new ArrayList<CollisionMeshDescription>();
        CollisionMeshDescription object32 = new CollisionMeshDescription();
        group32.add(object32);
        try {
            helper.addCollisionGroup("Group32", group32);
            Assert.fail("Too many groups");
        }
        catch (Exception e) {
            Assert.assertEquals("Number of groups at maximum of 32!", e.getMessage());
        }
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(CollisionMasksHelper.class, CollisionMasksHelperTest.class);
    }
}

