/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.client.discovery;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.websocket.DataServerLocationBroadcast;

public class DataServerLocationBroadcastReceiver
extends DataServerLocationBroadcast {
    private final DataServerLocationFoundListener listener;
    private final ArrayList<Thread> threads = new ArrayList();
    private volatile boolean running;

    public DataServerLocationBroadcastReceiver(DataServerLocationFoundListener listener) throws IOException {
        List<MulticastSocket> sockets = DataServerLocationBroadcastReceiver.getSocketChannelList(55241);
        for (MulticastSocket socket : sockets) {
            this.threads.add(new Thread((Runnable)new DiscoveryEndpoint(socket), this.getClass().getSimpleName() + "DiscoveryEndpoint"));
        }
        this.listener = listener;
    }

    public void start() {
        this.running = true;
        for (Thread thread : this.threads) {
            thread.start();
        }
    }

    public void stop() {
        this.running = false;
    }

    public void join() {
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        new DataServerLocationBroadcastReceiver(new DataServerLocationFoundListener(){

            @Override
            public void addHost(String host, int port, boolean persistant) {
                System.out.println("Found " + host + ":" + port);
            }
        }).start();
    }

    private class DiscoveryEndpoint
    implements Runnable {
        private final MulticastSocket socket;
        private final ObjectMapper mapper = new ObjectMapper(new JsonFactory());

        public DiscoveryEndpoint(MulticastSocket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                InetAddress multicastAddress = InetAddress.getByName("239.255.24.1");
                this.socket.joinGroup(multicastAddress);
                this.socket.setSoTimeout(1000);
                byte[] receiveBuffer = new byte[1472];
                while (DataServerLocationBroadcastReceiver.this.running) {
                    DatagramPacket packet = new DatagramPacket(receiveBuffer, receiveBuffer.length);
                    try {
                        this.socket.receive(packet);
                        String message = new String(packet.getData(), packet.getOffset(), packet.getLength(), CharsetUtil.UTF_8);
                        try {
                            String host = packet.getAddress().getHostAddress();
                            int port = DataServerLocationBroadcastReceiver.parseMessage(message, this.mapper);
                            DataServerLocationBroadcastReceiver.this.listener.addHost(host, port, false);
                        }
                        catch (JsonParseException | JsonMappingException e) {
                            LogTools.warn((String)"Invalid message {}", (Object)e.getMessage());
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {}
                }
                this.socket.leaveGroup(multicastAddress);
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface DataServerLocationFoundListener {
        public void addHost(String var1, int var2, boolean var3);
    }
}

