/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.jointState;

import java.nio.DoubleBuffer;
import java.nio.LongBuffer;
import us.ihmc.robotDataLogger.JointType;
import us.ihmc.robotDataLogger.jointState.JointState;

public class OneDoFState
extends JointState {
    public static final int numberOfStateVariables = 2;
    private double q;
    private double qd;

    public OneDoFState(String name) {
        super(name, JointType.OneDoFJoint);
    }

    @Override
    public void update(DoubleBuffer buffer) {
        this.q = buffer.get();
        this.qd = buffer.get();
    }

    @Override
    public void update(LongBuffer buffer) {
        this.q = Double.longBitsToDouble(buffer.get());
        this.qd = Double.longBitsToDouble(buffer.get());
    }

    public double getQ() {
        return this.q;
    }

    public double getQd() {
        return this.qd;
    }

    @Override
    public void get(double[] array) {
        array[0] = this.q;
        array[1] = this.qd;
    }

    @Override
    public void get(LongBuffer buffer) {
        buffer.put(Double.doubleToLongBits(this.q));
        buffer.put(Double.doubleToLongBits(this.qd));
    }

    @Override
    public int getNumberOfStateVariables() {
        return 2;
    }
}

