/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.guiRecorder;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.JFrame;
import us.ihmc.codecs.generated.RGBPicture;
import us.ihmc.codecs.generated.YUVPicture;
import us.ihmc.codecs.screenCapture.ScreenCapture;
import us.ihmc.codecs.screenCapture.ScreenCaptureFactory;
import us.ihmc.codecs.yuv.JPEGEncoder;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.types.ByteBufferPubSubType;

public class GUICaptureStreamer {
    public static final String topicType = "us::ihmc::robotDataLogger::gui::screenshot";
    public static final String partition = "/us/ihmc/robotDataLogger/GuiStreamer";
    public static final int MAXIMUM_IMAGE_DATA_SIZE = 0x100000;
    private final Supplier<Rectangle> windowBoundsProvider;
    private final int fps;
    private final ScreenCapture screenCapture = ScreenCaptureFactory.getScreenCapture();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(ThreadTools.getNamedThreadFactory((String)"GUICaptureStreamer"));
    private final CaptureRunner captureRunner = new CaptureRunner();
    private final Dimension size = new Dimension();
    private Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
    private Participant participant;
    private Publisher publisher;
    private final String topicName;
    private JPEGEncoder encoder = new JPEGEncoder();
    private ScheduledFuture<?> future = null;

    public GUICaptureStreamer(JFrame window, int fps, float quality, int domainID, String topicName) {
        this(() -> window.getBounds(), fps, quality, domainID, topicName);
    }

    public GUICaptureStreamer(Supplier<Rectangle> windowBoundsProvider, int fps, float quality, int domainID, String topicName) {
        this.windowBoundsProvider = windowBoundsProvider;
        this.fps = fps;
        this.topicName = topicName;
        try {
            ParticipantAttributes attributes = this.domain.createParticipantAttributes(domainID, this.getClass().getSimpleName());
            this.participant = this.domain.createParticipant(attributes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void start() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        ByteBufferPubSubType pubSubType = new ByteBufferPubSubType(topicType, 0x100000);
        PublisherAttributes attributes = this.domain.createPublisherAttributes(this.participant, (TopicDataType)pubSubType, this.topicName, ReliabilityKind.BEST_EFFORT, new String[]{partition});
        try {
            this.publisher = this.domain.createPublisher(this.participant, attributes);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        this.scheduler.scheduleAtFixedRate(this.captureRunner, 10L, 1000000000 / this.fps, TimeUnit.NANOSECONDS);
    }

    public synchronized void stop() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.domain.removeParticipant(this.participant);
    }

    public void destroy() {
        this.domain.removeParticipant(this.participant);
        this.domain = null;
        this.participant = null;
        this.scheduler.shutdownNow();
    }

    private class CaptureRunner
    implements Runnable {
        private CaptureRunner() {
        }

        @Override
        public void run() {
            Rectangle screen;
            Rectangle windowBounds = GUICaptureStreamer.this.windowBoundsProvider.get();
            Rectangle captureRectangle = windowBounds.intersection(screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
            Dimension windowSize = captureRectangle.getSize();
            if (!windowSize.equals(GUICaptureStreamer.this.size)) {
                GUICaptureStreamer.this.size.setSize(windowSize);
            }
            try {
                RGBPicture img = GUICaptureStreamer.this.screenCapture.createScreenCapture(captureRectangle);
                if (img != null) {
                    YUVPicture yuv = img.toYUV(YUVPicture.YUVSubsamplingType.YUV420);
                    ByteBuffer buffer = GUICaptureStreamer.this.encoder.encode(yuv, 90);
                    if (buffer.remaining() <= 0x100000) {
                        GUICaptureStreamer.this.publisher.write((Object)buffer);
                    } else {
                        System.err.println("Not sending screen capture, image size exceeds 1048576");
                    }
                    yuv.delete();
                    img.delete();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

