/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.example;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class ExampleServer {
    private static final int variablesPerType = 200;
    private static final double dt = 0.001;
    private static final int mainRegistryUpdatesPerSecondRegistryUpdates = 10;
    private static final DataServerSettings logSettings = new DataServerSettings(true);
    private final Random random = new Random(127L);
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoRegistry secondRegistry = new YoRegistry(this.getClass().getSimpleName() + "Second");
    private final YoVariableServer yoVariableServer;
    private final List<YoVariable> mainChangingVariables = new ArrayList<YoVariable>();
    private final List<YoVariable> secondChangingVariables = new ArrayList<YoVariable>();
    private long timestamp = 0L;
    private long counter = 0L;

    public ExampleServer() {
        this.createVariables("Main", 200, this.registry, this.mainChangingVariables);
        this.createVariables("Second", 200, this.secondRegistry, this.secondChangingVariables);
        this.yoVariableServer = new YoVariableServer(this.getClass(), null, logSettings, 0.001);
        this.yoVariableServer.setMainRegistry(this.registry, null);
        this.yoVariableServer.addRegistry(this.secondRegistry, null);
    }

    public void start() {
        this.yoVariableServer.start();
        LogTools.info((String)"Starting to loop.");
        for (int i = 0; i < 3; ++i) {
            this.timestamp += Conversions.secondsToNanoseconds((double)0.001);
            this.yoVariableServer.update(this.timestamp);
        }
        while (true) {
            this.timestamp += Conversions.secondsToNanoseconds((double)0.001);
            long dtFactor = Conversions.secondsToNanoseconds((double)0.001) / 2L;
            long jitteryTimestamp = this.timestamp + (long)((this.random.nextDouble() - 0.5) * (double)dtFactor);
            this.updateVariables(this.mainChangingVariables);
            this.yoVariableServer.update(jitteryTimestamp);
            if (this.counter % 10L == 0L) {
                this.updateVariables(this.secondChangingVariables);
                this.yoVariableServer.update(jitteryTimestamp, this.secondRegistry);
            }
            ++this.counter;
            ThreadTools.sleepSeconds((double)0.001);
        }
    }

    private void createVariables(String prefix, int variablesPerType, YoRegistry registry, List<YoVariable> allChangingVariables) {
        for (int i = 0; i < variablesPerType; ++i) {
            new YoBoolean(prefix + "Boolean" + i, registry);
            new YoDouble(prefix + "Double" + i, registry);
            new YoInteger(prefix + "Integer" + i, registry);
            new YoLong(prefix + "Long" + i, registry);
            new YoEnum(prefix + "Enum" + i, registry, SomeEnum.class, this.random.nextBoolean());
        }
        allChangingVariables.addAll(registry.collectSubtreeVariables());
        YoDouble input = new YoDouble(prefix + "Input", registry);
        YoDouble output = new YoDouble(prefix + "Output", registry);
        input.addListener(v -> output.set(input.getValue()));
    }

    private void updateVariables(List<YoVariable> allChangingVariables) {
        for (int varIdx = 0; varIdx < allChangingVariables.size(); ++varIdx) {
            this.updateVariable(allChangingVariables.get(varIdx));
        }
    }

    private void updateVariable(YoVariable variable) {
        if (variable instanceof YoBoolean) {
            ((YoBoolean)variable).set(this.random.nextBoolean());
        } else if (variable instanceof YoDouble) {
            ((YoDouble)variable).set(this.random.nextDouble());
        } else if (variable instanceof YoInteger) {
            ((YoInteger)variable).set(this.random.nextInt());
        } else if (variable instanceof YoLong) {
            ((YoLong)variable).set(this.random.nextLong());
        } else if (variable instanceof YoEnum) {
            int enumSize = ((YoEnum)variable).getEnumSize();
            ((YoEnum)variable).set(this.random.nextInt(enumSize));
        } else {
            throw new RuntimeException("Implement this case for " + variable.getClass().getSimpleName() + ".");
        }
    }

    public static void main(String[] args) {
        LogTools.info((String)("Starting " + ExampleServer.class.getSimpleName()));
        ExampleServer exampleServer = new ExampleServer();
        exampleServer.start();
    }

    public static enum SomeEnum {
        A,
        B,
        C,
        D,
        E,
        F;

    }
}

