/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.dataBuffers;

import java.io.IOException;
import java.nio.ByteBuffer;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.LogDataType;
import us.ihmc.robotDataLogger.dataBuffers.CustomLogDataPublisherType;
import us.ihmc.robotDataLogger.dataBuffers.RegistryReceiveBuffer;
import us.ihmc.tools.compression.CompressionImplementation;
import us.ihmc.tools.compression.CompressionImplementationFactory;

public class CustomLogDataSubscriberType
implements TopicDataType<RegistryReceiveBuffer> {
    public static final String name = "us::ihmc::robotDataLogger::LogData";
    private final int numberOfVariables;
    private final int numberOfStates;
    private final CompressionImplementation compressor;
    private final CDR deserializeCDR = new CDR();

    public CustomLogDataSubscriberType(int maxNumberOfVariables, int maxNumberOfStates) {
        this.numberOfVariables = maxNumberOfVariables;
        this.numberOfStates = maxNumberOfStates;
        this.compressor = CompressionImplementationFactory.instance();
    }

    public void serialize(RegistryReceiveBuffer data, SerializedPayload serializedPayload) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    public void deserialize(SerializedPayload serializedPayload, RegistryReceiveBuffer data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        data.setUid(this.deserializeCDR.read_type_11());
        data.setTimestamp(this.deserializeCDR.read_type_11());
        data.setTransmitTime(this.deserializeCDR.read_type_11());
        data.setType(LogDataType.values[this.deserializeCDR.read_type_c()]);
        data.setRegistryID(this.deserializeCDR.read_type_2());
        data.setNumberOfVariables(this.deserializeCDR.read_type_2());
        if (data.getType() == LogDataType.DATA_PACKET) {
            int dataLength = this.deserializeCDR.read_type_2();
            ByteBuffer buffer = data.allocateBuffer(dataLength);
            serializedPayload.getData().get(buffer.array(), 0, dataLength);
            buffer.limit(dataLength);
            int stateLength = this.deserializeCDR.read_type_2();
            double[] states = data.allocateStates(stateLength);
            for (int i = 0; i < stateLength; ++i) {
                states[i] = this.deserializeCDR.read_type_6();
            }
        }
        this.deserializeCDR.finishDeserialize();
    }

    public final void serialize(RegistryReceiveBuffer data, InterchangeSerializer ser) {
        throw new RuntimeException("Not implemented");
    }

    public final void deserialize(InterchangeSerializer ser, RegistryReceiveBuffer data) {
        throw new RuntimeException("Not implemented");
    }

    public RegistryReceiveBuffer createData() {
        return null;
    }

    public int getTypeSize() {
        return CustomLogDataPublisherType.getTypeSize(this.compressor.maxCompressedLength(this.numberOfVariables * 8), this.numberOfStates);
    }

    public String getName() {
        return name;
    }

    public CustomLogDataSubscriberType newInstance() {
        return new CustomLogDataSubscriberType(this.numberOfVariables, this.numberOfStates);
    }

    public void serialize(RegistryReceiveBuffer data, CDR cdr) {
        throw new RuntimeException("Not implemented");
    }

    public void deserialize(RegistryReceiveBuffer data, CDR cdr) {
        throw new RuntimeException("Not implemented");
    }

    public void copy(RegistryReceiveBuffer src, RegistryReceiveBuffer dest) {
        throw new RuntimeException("Not implemented");
    }
}

