/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.EnumType;

public class EnumTypePubSubType
implements TopicDataType<EnumType> {
    public static final String name = "us::ihmc::robotDataLogger::EnumType";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(EnumType data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        EnumTypePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, EnumType data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        EnumTypePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return EnumTypePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 255; ++i0) {
            current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(EnumType data) {
        return EnumTypePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(EnumType data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getEnumValues().size(); ++i0) {
            current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + ((StringBuilder)data.getEnumValues().get(i0)).length() + 1;
        }
        return current_alignment - initial_alignment;
    }

    public static void write(EnumType data, CDR cdr) {
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length");
        }
        cdr.write_type_d(data.getName());
        if (data.getEnumValues().size() > 255) {
            throw new RuntimeException("enumValues field exceeds the maximum length");
        }
        cdr.write_type_e((IDLSequence)data.getEnumValues());
    }

    public static void read(EnumType data, CDR cdr) {
        cdr.read_type_d(data.getName());
        cdr.read_type_e((IDLSequence)data.getEnumValues());
    }

    public final void serialize(EnumType data, InterchangeSerializer ser) {
        ser.write_type_d("name", data.getName());
        ser.write_type_e("enumValues", (IDLSequence)data.getEnumValues());
    }

    public final void deserialize(InterchangeSerializer ser, EnumType data) {
        ser.read_type_d("name", data.getName());
        ser.read_type_e("enumValues", (IDLSequence)data.getEnumValues());
    }

    public static void staticCopy(EnumType src, EnumType dest) {
        dest.set(src);
    }

    public EnumType createData() {
        return new EnumType();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)EnumTypePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(EnumType data, CDR cdr) {
        EnumTypePubSubType.write(data, cdr);
    }

    public void deserialize(EnumType data, CDR cdr) {
        EnumTypePubSubType.read(data, cdr);
    }

    public void copy(EnumType src, EnumType dest) {
        EnumTypePubSubType.staticCopy(src, dest);
    }

    public EnumTypePubSubType newInstance() {
        return new EnumTypePubSubType();
    }
}

