/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.util.function.Supplier;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.AnnouncementPubSubType;
import us.ihmc.robotDataLogger.ModelFileDescription;
import us.ihmc.robotDataLogger.ModelFileDescriptionPubSubType;

public class Announcement
extends Packet<Announcement>
implements Settable<Announcement>,
EpsilonComparable<Announcement> {
    public StringBuilder identifier_ = new StringBuilder(255);
    public StringBuilder name_ = new StringBuilder(255);
    public StringBuilder hostName_ = new StringBuilder(255);
    public StringBuilder reconnectKey_ = new StringBuilder(255);
    public ModelFileDescription modelFileDescription_ = new ModelFileDescription();
    public boolean log_;

    public Announcement() {
    }

    public Announcement(Announcement other) {
        this();
        this.set(other);
    }

    public void set(Announcement other) {
        this.identifier_.setLength(0);
        this.identifier_.append((CharSequence)other.identifier_);
        this.name_.setLength(0);
        this.name_.append((CharSequence)other.name_);
        this.hostName_.setLength(0);
        this.hostName_.append((CharSequence)other.hostName_);
        this.reconnectKey_.setLength(0);
        this.reconnectKey_.append((CharSequence)other.reconnectKey_);
        ModelFileDescriptionPubSubType.staticCopy(other.modelFileDescription_, this.modelFileDescription_);
        this.log_ = other.log_;
    }

    public void setIdentifier(String identifier) {
        this.identifier_.setLength(0);
        this.identifier_.append(identifier);
    }

    public String getIdentifierAsString() {
        return this.getIdentifier().toString();
    }

    public StringBuilder getIdentifier() {
        return this.identifier_;
    }

    public void setName(String name) {
        this.name_.setLength(0);
        this.name_.append(name);
    }

    public String getNameAsString() {
        return this.getName().toString();
    }

    public StringBuilder getName() {
        return this.name_;
    }

    public void setHostName(String hostName) {
        this.hostName_.setLength(0);
        this.hostName_.append(hostName);
    }

    public String getHostNameAsString() {
        return this.getHostName().toString();
    }

    public StringBuilder getHostName() {
        return this.hostName_;
    }

    public void setReconnectKey(String reconnectKey) {
        this.reconnectKey_.setLength(0);
        this.reconnectKey_.append(reconnectKey);
    }

    public String getReconnectKeyAsString() {
        return this.getReconnectKey().toString();
    }

    public StringBuilder getReconnectKey() {
        return this.reconnectKey_;
    }

    public ModelFileDescription getModelFileDescription() {
        return this.modelFileDescription_;
    }

    public void setLog(boolean log) {
        this.log_ = log;
    }

    public boolean getLog() {
        return this.log_;
    }

    public static Supplier<AnnouncementPubSubType> getPubSubType() {
        return AnnouncementPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return AnnouncementPubSubType::new;
    }

    public boolean epsilonEquals(Announcement other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.identifier_, (StringBuilder)other.identifier_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.name_, (StringBuilder)other.name_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.hostName_, (StringBuilder)other.hostName_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.reconnectKey_, (StringBuilder)other.reconnectKey_, (double)epsilon)) {
            return false;
        }
        if (!this.modelFileDescription_.epsilonEquals(other.modelFileDescription_, epsilon)) {
            return false;
        }
        return IDLTools.epsilonEqualsBoolean((boolean)this.log_, (boolean)other.log_, (double)epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Announcement)) {
            return false;
        }
        Announcement otherMyClass = (Announcement)((Object)other);
        if (!IDLTools.equals((StringBuilder)this.identifier_, (StringBuilder)otherMyClass.identifier_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.name_, (StringBuilder)otherMyClass.name_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.hostName_, (StringBuilder)otherMyClass.hostName_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.reconnectKey_, (StringBuilder)otherMyClass.reconnectKey_)) {
            return false;
        }
        if (!this.modelFileDescription_.equals((Object)otherMyClass.modelFileDescription_)) {
            return false;
        }
        return this.log_ == otherMyClass.log_;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Announcement {");
        builder.append("identifier=");
        builder.append((CharSequence)this.identifier_);
        builder.append(", ");
        builder.append("name=");
        builder.append((CharSequence)this.name_);
        builder.append(", ");
        builder.append("hostName=");
        builder.append((CharSequence)this.hostName_);
        builder.append(", ");
        builder.append("reconnectKey=");
        builder.append((CharSequence)this.reconnectKey_);
        builder.append(", ");
        builder.append("modelFileDescription=");
        builder.append((Object)this.modelFileDescription_);
        builder.append(", ");
        builder.append("log=");
        builder.append(this.log_);
        builder.append("}");
        return builder.toString();
    }
}

