/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.jointState;

import java.nio.DoubleBuffer;
import java.nio.LongBuffer;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.robotDataLogger.JointType;
import us.ihmc.robotDataLogger.jointState.JointState;

public class SixDoFState
extends JointState {
    public static final int numberOfStateVariables = 13;
    private final Quaternion rotation = new Quaternion();
    private final Vector3D translation = new Vector3D();
    private final Twist twist = new Twist();

    public SixDoFState(String name) {
        super(name, JointType.SiXDoFJoint);
    }

    @Override
    public void get(double[] array) {
        array[0] = this.rotation.getS();
        array[1] = this.rotation.getX();
        array[2] = this.rotation.getY();
        array[3] = this.rotation.getZ();
        array[4] = this.translation.getX();
        array[5] = this.translation.getY();
        array[6] = this.translation.getZ();
        this.twist.get(7, array);
    }

    @Override
    public void update(DoubleBuffer buffer) {
        double qs = buffer.get();
        double qx = buffer.get();
        double qy = buffer.get();
        double qz = buffer.get();
        this.rotation.set(qx, qy, qz, qs);
        this.translation.setX(buffer.get());
        this.translation.setY(buffer.get());
        this.translation.setZ(buffer.get());
        this.twist.setAngularPartX(buffer.get());
        this.twist.setAngularPartY(buffer.get());
        this.twist.setAngularPartZ(buffer.get());
        this.twist.setLinearPartX(buffer.get());
        this.twist.setLinearPartY(buffer.get());
        this.twist.setLinearPartZ(buffer.get());
    }

    @Override
    public void update(LongBuffer buffer) {
        double qs = Double.longBitsToDouble(buffer.get());
        double qx = Double.longBitsToDouble(buffer.get());
        double qy = Double.longBitsToDouble(buffer.get());
        double qz = Double.longBitsToDouble(buffer.get());
        this.rotation.set(qx, qy, qz, qs);
        this.translation.setX(Double.longBitsToDouble(buffer.get()));
        this.translation.setY(Double.longBitsToDouble(buffer.get()));
        this.translation.setZ(Double.longBitsToDouble(buffer.get()));
        this.twist.setAngularPartX(Double.longBitsToDouble(buffer.get()));
        this.twist.setAngularPartY(Double.longBitsToDouble(buffer.get()));
        this.twist.setAngularPartZ(Double.longBitsToDouble(buffer.get()));
        this.twist.setLinearPartX(Double.longBitsToDouble(buffer.get()));
        this.twist.setLinearPartY(Double.longBitsToDouble(buffer.get()));
        this.twist.setLinearPartZ(Double.longBitsToDouble(buffer.get()));
    }

    @Override
    public void get(LongBuffer buffer) {
        buffer.put(Double.doubleToLongBits(this.rotation.getS()));
        buffer.put(Double.doubleToLongBits(this.rotation.getX()));
        buffer.put(Double.doubleToLongBits(this.rotation.getY()));
        buffer.put(Double.doubleToLongBits(this.rotation.getZ()));
        buffer.put(Double.doubleToLongBits(this.translation.getX()));
        buffer.put(Double.doubleToLongBits(this.translation.getY()));
        buffer.put(Double.doubleToLongBits(this.translation.getZ()));
        buffer.put(Double.doubleToLongBits(this.twist.getAngularPartX()));
        buffer.put(Double.doubleToLongBits(this.twist.getAngularPartY()));
        buffer.put(Double.doubleToLongBits(this.twist.getAngularPartZ()));
        buffer.put(Double.doubleToLongBits(this.twist.getLinearPartX()));
        buffer.put(Double.doubleToLongBits(this.twist.getLinearPartY()));
        buffer.put(Double.doubleToLongBits(this.twist.getLinearPartZ()));
    }

    @Override
    public int getNumberOfStateVariables() {
        return 13;
    }

    public QuaternionReadOnly getRotation() {
        return this.rotation;
    }

    public void getRotation(Orientation3DBasics orientationToPack) {
        orientationToPack.set((Orientation3DReadOnly)this.rotation);
    }

    public Vector3DReadOnly getTranslation() {
        return this.translation;
    }

    public void getTranslation(Tuple3DBasics translationToPack) {
        translationToPack.set((Tuple3DReadOnly)this.translation);
    }

    public Vector3DReadOnly getTwistAngularPart() {
        return this.twist.getAngularPart();
    }

    public Vector3DReadOnly getTwistLinearPart() {
        return this.twist.getLinearPart();
    }

    public void getTwistAngularPart(Tuple3DBasics twistAngularPartToPack) {
        twistAngularPartToPack.set((Tuple3DReadOnly)this.twist.getAngularPart());
    }

    public void getTwistLinearPart(Tuple3DBasics twistLinearPartToPack) {
        twistLinearPartToPack.set((Tuple3DReadOnly)this.twist.getLinearPart());
    }
}

