/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.HandshakeFileType;
import us.ihmc.robotDataLogger.Variables;

public class VariablesPubSubType
implements TopicDataType<Variables> {
    public static final String name = "us::ihmc::robotDataLogger::Variables";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(Variables data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        VariablesPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Variables data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        VariablesPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return VariablesPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Variables data) {
        return VariablesPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Variables data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getHandshake().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getData().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getSummary().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getIndex().length() + 1;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static void write(Variables data, CDR cdr) {
        cdr.write_type_c(data.getHandshakeFileType().ordinal());
        if (data.getHandshake().length() > 255) {
            throw new RuntimeException("handshake field exceeds the maximum length");
        }
        cdr.write_type_d(data.getHandshake());
        if (data.getData().length() > 255) {
            throw new RuntimeException("data field exceeds the maximum length");
        }
        cdr.write_type_d(data.getData());
        if (data.getSummary().length() > 255) {
            throw new RuntimeException("summary field exceeds the maximum length");
        }
        cdr.write_type_d(data.getSummary());
        if (data.getIndex().length() > 255) {
            throw new RuntimeException("index field exceeds the maximum length");
        }
        cdr.write_type_d(data.getIndex());
        cdr.write_type_7(data.getTimestamped());
        cdr.write_type_7(data.getCompressed());
    }

    public static void read(Variables data, CDR cdr) {
        data.setHandshakeFileType(HandshakeFileType.values[cdr.read_type_c()]);
        cdr.read_type_d(data.getHandshake());
        cdr.read_type_d(data.getData());
        cdr.read_type_d(data.getSummary());
        cdr.read_type_d(data.getIndex());
        data.setTimestamped(cdr.read_type_7());
        data.setCompressed(cdr.read_type_7());
    }

    public final void serialize(Variables data, InterchangeSerializer ser) {
        ser.write_type_c("handshakeFileType", (Enum)data.getHandshakeFileType());
        ser.write_type_d("handshake", data.getHandshake());
        ser.write_type_d("data", data.getData());
        ser.write_type_d("summary", data.getSummary());
        ser.write_type_d("index", data.getIndex());
        ser.write_type_7("timestamped", data.getTimestamped());
        ser.write_type_7("compressed", data.getCompressed());
    }

    public final void deserialize(InterchangeSerializer ser, Variables data) {
        data.setHandshakeFileType((HandshakeFileType)ser.read_type_c("handshakeFileType", HandshakeFileType.class));
        ser.read_type_d("handshake", data.getHandshake());
        ser.read_type_d("data", data.getData());
        ser.read_type_d("summary", data.getSummary());
        ser.read_type_d("index", data.getIndex());
        data.setTimestamped(ser.read_type_7("timestamped"));
        data.setCompressed(ser.read_type_7("compressed"));
    }

    public static void staticCopy(Variables src, Variables dest) {
        dest.set(src);
    }

    public Variables createData() {
        return new Variables();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)VariablesPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Variables data, CDR cdr) {
        VariablesPubSubType.write(data, cdr);
    }

    public void deserialize(Variables data, CDR cdr) {
        VariablesPubSubType.read(data, cdr);
    }

    public void copy(Variables src, Variables dest) {
        VariablesPubSubType.staticCopy(src, dest);
    }

    public VariablesPubSubType newInstance() {
        return new VariablesPubSubType();
    }
}

