/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.server;

class WebsocketDataServerRegistrySendStatistics {
    private long registryLastTimestamp = 0L;
    private long registryLastSendTimestamp = 0L;
    private long registryDT = 0L;
    private long jitter = 0L;
    private long jitterSamples = 0L;

    WebsocketDataServerRegistrySendStatistics() {
    }

    public void update(long timestamp) {
        if (this.registryLastTimestamp != 0L) {
            if (this.registryDT == 0L) {
                this.registryDT = timestamp - this.registryLastTimestamp;
            } else {
                this.registryDT = (this.registryDT * 99L + timestamp - this.registryLastTimestamp) / 100L;
                long D = timestamp - this.registryLastTimestamp - this.registryDT;
                if (D < 0L) {
                    D = -D;
                }
                this.jitter += (D - this.jitter) / 16L;
                ++this.jitterSamples;
            }
        }
        this.registryLastTimestamp = timestamp;
    }

    public boolean isNonMonotonic() {
        return this.registryDT == 0L || this.jitterSamples < 16L || this.jitter > this.registryDT / 2L;
    }

    public boolean shouldSend(long timestamp, long requestedDT, long fastestRegistryBufferDT, boolean checkForOtherRegistry) {
        if (this.isNonMonotonic()) {
            if (checkForOtherRegistry) {
                return false;
            }
            return timestamp > this.registryLastSendTimestamp + requestedDT;
        }
        long adjustedRequestedDT = requestedDT < this.registryDT ? this.registryDT : Math.round((double)requestedDT / (double)this.registryDT) * this.registryDT;
        if (checkForOtherRegistry) {
            long ticksAway = Math.round((double)(timestamp - this.registryLastSendTimestamp) / (double)adjustedRequestedDT);
            long expectedSendTime = this.registryLastSendTimestamp + ticksAway * adjustedRequestedDT;
            long minSendTimestamp = expectedSendTime - fastestRegistryBufferDT / 2L;
            long maxSendTimestamp = minSendTimestamp + fastestRegistryBufferDT;
            return timestamp > minSendTimestamp && timestamp < maxSendTimestamp;
        }
        long minSendTimestamp = this.registryLastSendTimestamp + adjustedRequestedDT - fastestRegistryBufferDT / 2L;
        return timestamp > minSendTimestamp;
    }

    public void updateSendTimestamp(long timestamp) {
        this.registryLastSendTimestamp = timestamp;
    }

    public long getRegistryBufferDT() {
        return this.registryDT;
    }
}

