/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import us.ihmc.codecs.builder.MP4MJPEGMovieBuilder;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.guiRecorder.GUICaptureHandler;
import us.ihmc.robotDataLogger.guiRecorder.GUICaptureReceiver;
import us.ihmc.robotDataLogger.logger.VideoDataLoggerInterface;

public class NetworkStreamVideoDataLogger
extends VideoDataLoggerInterface
implements GUICaptureHandler {
    private final GUICaptureReceiver client;
    private MP4MJPEGMovieBuilder builder;
    private PrintStream timestampStream;
    private int dts = 0;
    private volatile long timestamp = 0L;
    private volatile long lastFrameTimestamp = 0L;

    public NetworkStreamVideoDataLogger(File logPath, LogProperties logProperties, int domainId, String topicName) throws IOException {
        super(logPath, logProperties, topicName);
        this.client = new GUICaptureReceiver(domainId, topicName, this);
        this.client.start();
    }

    @Override
    public void timestampChanged(long newTimestamp) {
        this.timestamp = newTimestamp;
    }

    @Override
    public void restart() throws IOException {
        try {
            if (this.builder != null) {
                this.builder.close();
            }
            if (this.timestampStream != null) {
                this.timestampStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.builder = null;
        this.timestampStream = null;
        this.removeLogFiles();
    }

    @Override
    public void close() {
        this.client.close();
        try {
            if (this.builder != null) {
                this.builder.close();
            }
            if (this.timestampStream != null) {
                this.timestampStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.builder = null;
        this.timestampStream = null;
    }

    @Override
    public void receivedFrame(ByteBuffer buffer) {
        if (this.builder == null) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer.array());
                BufferedImage img = ImageIO.read(inputStream);
                if (img == null) {
                    System.err.println("Cannot decode image");
                    return;
                }
                File videoFileFile = new File(this.videoFile);
                this.builder = new MP4MJPEGMovieBuilder(videoFileFile, img.getWidth(), img.getHeight(), 10, 90);
                File timestampFile = new File(this.timestampData);
                this.timestampStream = new PrintStream(timestampFile);
                this.timestampStream.println("1");
                this.timestampStream.println("10");
                buffer.clear();
                this.dts = 0;
                this.lastFrameTimestamp = System.nanoTime();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            this.builder.encodeFrame(buffer);
            this.timestampStream.println(this.timestamp + " " + this.dts);
            ++this.dts;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getLastFrameReceivedTimestamp() {
        return this.lastFrameTimestamp;
    }
}

