/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.guiRecorder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotDataLogger.logger.LogSettings;
import us.ihmc.robotDataLogger.logger.NetworkStreamVideoDataLogger;

public class GUICaptureRecorder
extends JFrame {
    private static final long serialVersionUID = -5900895574333786847L;
    public final JButton start = new JButton("start");
    public final JButton stop = new JButton("stop");
    private final JComboBox<DataServerSettings> gui = new JComboBox();
    public NetworkStreamVideoDataLogger currentLogger = null;
    private File target;

    public GUICaptureRecorder() {
        super("GUI Capture recorder");
        BoxLayout layout = new BoxLayout(this.getContentPane(), 0);
        this.getContentPane().setLayout(layout);
        for (DataServerSettings dataServerSettings : LogSettings.values()) {
            if (dataServerSettings.getVideoStream() == null) continue;
            this.gui.addItem(dataServerSettings);
        }
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GUICaptureRecorder.this.startLog();
                }
                catch (SocketException | UnknownHostException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUICaptureRecorder.this.stopLog(false);
            }
        });
        this.getContentPane().add(this.gui);
        this.getContentPane().add(this.start);
        this.getContentPane().add(this.stop);
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(3);
        Runtime.getRuntime().addShutdownHook(new Thread("IHMC-GUICaptureRecorderShutdown"){

            @Override
            public void run() {
                GUICaptureRecorder.this.stopLog(true);
            }
        });
        this.pack();
        this.setVisible(true);
    }

    public void startLog() throws UnknownHostException, SocketException {
        if (this.currentLogger == null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            Calendar calendar = Calendar.getInstance();
            String timestamp = dateFormat.format(calendar.getTime());
            DataServerSettings settings = (DataServerSettings)this.gui.getSelectedItem();
            this.target = new File(System.getProperty("user.home") + "/robotLogs/", timestamp + "_" + settings.toString() + "_UILog");
            this.target.mkdirs();
            this.start.setEnabled(false);
            this.stop.setEnabled(true);
        }
    }

    public void stopLog(boolean exiting) {
        if (this.currentLogger != null) {
            this.currentLogger.close();
            if (!exiting) {
                JOptionPane.showMessageDialog(this, "Video saved to " + this.target.getAbsolutePath());
            } else {
                System.out.println("Video saved to " + this.target.getAbsolutePath());
            }
            this.currentLogger = null;
        }
        this.start.setEnabled(true);
    }

    public static void main(String[] args) {
        throw new RuntimeException("TODO: FIX ME");
    }
}

