/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.ZEDSDKAnnounce;

public class ZEDSDKAnnouncePubSubType
implements TopicDataType<ZEDSDKAnnounce> {
    public static final String name = "us::ihmc::robotDataLogger::ZEDSDKAnnounce";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "bbfe6148144cfcd91773734a4990318710c6d90157c06c721db065f97c46a620";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(ZEDSDKAnnounce data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        ZEDSDKAnnouncePubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, ZEDSDKAnnounce data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        ZEDSDKAnnouncePubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return ZEDSDKAnnouncePubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 2 + CDR.alignment((int)current_alignment, (int)2);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(ZEDSDKAnnounce data) {
        return ZEDSDKAnnouncePubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(ZEDSDKAnnounce data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getSensorName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getAddress().length() + 1;
        current_alignment += 2 + CDR.alignment((int)current_alignment, (int)2);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        return current_alignment - initial_alignment;
    }

    public static void write(ZEDSDKAnnounce data, CDR cdr) {
        if (data.getSensorName().length() > 255) {
            throw new RuntimeException("sensor_name field exceeds the maximum length: %d > %d".formatted(data.getSensorName().length(), 255));
        }
        cdr.write_type_d(data.getSensorName());
        if (data.getAddress().length() > 255) {
            throw new RuntimeException("address field exceeds the maximum length: %d > %d".formatted(data.getAddress().length(), 255));
        }
        cdr.write_type_d(data.getAddress());
        cdr.write_type_1(data.getPort());
        cdr.write_type_2(data.getFps());
        cdr.write_type_2(data.getBitrate());
        cdr.write_type_11(data.getSensorTimestamp());
        cdr.write_type_11(data.getControllerTimestamp());
    }

    public static void read(ZEDSDKAnnounce data, CDR cdr) {
        cdr.read_type_d(data.getSensorName());
        cdr.read_type_d(data.getAddress());
        data.setPort(cdr.read_type_1());
        data.setFps(cdr.read_type_2());
        data.setBitrate(cdr.read_type_2());
        data.setSensorTimestamp(cdr.read_type_11());
        data.setControllerTimestamp(cdr.read_type_11());
    }

    public final void serialize(ZEDSDKAnnounce data, InterchangeSerializer ser) {
        ser.write_type_d("sensor_name", data.getSensorName());
        ser.write_type_d("address", data.getAddress());
        ser.write_type_1("port", data.getPort());
        ser.write_type_2("fps", data.getFps());
        ser.write_type_2("bitrate", data.getBitrate());
        ser.write_type_11("sensorTimestamp", data.getSensorTimestamp());
        ser.write_type_11("controllerTimestamp", data.getControllerTimestamp());
    }

    public final void deserialize(InterchangeSerializer ser, ZEDSDKAnnounce data) {
        ser.read_type_d("sensor_name", data.getSensorName());
        ser.read_type_d("address", data.getAddress());
        data.setPort(ser.read_type_1("port"));
        data.setFps(ser.read_type_2("fps"));
        data.setBitrate(ser.read_type_2("bitrate"));
        data.setSensorTimestamp(ser.read_type_11("sensorTimestamp"));
        data.setControllerTimestamp(ser.read_type_11("controllerTimestamp"));
    }

    public static void staticCopy(ZEDSDKAnnounce src, ZEDSDKAnnounce dest) {
        dest.set(src);
    }

    public ZEDSDKAnnounce createData() {
        return new ZEDSDKAnnounce();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)ZEDSDKAnnouncePubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(ZEDSDKAnnounce data, CDR cdr) {
        ZEDSDKAnnouncePubSubType.write(data, cdr);
    }

    public void deserialize(ZEDSDKAnnounce data, CDR cdr) {
        ZEDSDKAnnouncePubSubType.read(data, cdr);
    }

    public void copy(ZEDSDKAnnounce src, ZEDSDKAnnounce dest) {
        ZEDSDKAnnouncePubSubType.staticCopy(src, dest);
    }

    public ZEDSDKAnnouncePubSubType newInstance() {
        return new ZEDSDKAnnouncePubSubType();
    }
}

