/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.LoadStatus;
import us.ihmc.robotDataLogger.YoType;
import us.ihmc.robotDataLogger.YoVariableDefinition;

public class YoVariableDefinitionPubSubType
implements TopicDataType<YoVariableDefinition> {
    public static final String name = "us::ihmc::robotDataLogger::YoVariableDefinition";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "47788074ef85fc4d41967bc5006da101900e00ccaa28e8af31c5da7ecd907d3e";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(YoVariableDefinition data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        YoVariableDefinitionPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, YoVariableDefinition data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        YoVariableDefinitionPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return YoVariableDefinitionPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 2 + CDR.alignment((int)current_alignment, (int)2);
        current_alignment += 2 + CDR.alignment((int)current_alignment, (int)2);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(YoVariableDefinition data) {
        return YoVariableDefinitionPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(YoVariableDefinition data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getDescription().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 2 + CDR.alignment((int)current_alignment, (int)2);
        current_alignment += 2 + CDR.alignment((int)current_alignment, (int)2);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 8 + CDR.alignment((int)current_alignment, (int)8);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        return current_alignment - initial_alignment;
    }

    public static void write(YoVariableDefinition data, CDR cdr) {
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length: %d > %d".formatted(data.getName().length(), 255));
        }
        cdr.write_type_d(data.getName());
        if (data.getDescription().length() > 255) {
            throw new RuntimeException("description field exceeds the maximum length: %d > %d".formatted(data.getDescription().length(), 255));
        }
        cdr.write_type_d(data.getDescription());
        cdr.write_type_c(data.getType().ordinal());
        cdr.write_type_3(data.getRegistry());
        cdr.write_type_3(data.getEnumType());
        cdr.write_type_7(data.getAllowNullValues());
        cdr.write_type_7(data.getIsParameter());
        cdr.write_type_6(data.getMin());
        cdr.write_type_6(data.getMax());
        cdr.write_type_c(data.getLoadStatus().ordinal());
    }

    public static void read(YoVariableDefinition data, CDR cdr) {
        cdr.read_type_d(data.getName());
        cdr.read_type_d(data.getDescription());
        data.setType(YoType.values[cdr.read_type_c()]);
        data.setRegistry(cdr.read_type_3());
        data.setEnumType(cdr.read_type_3());
        data.setAllowNullValues(cdr.read_type_7());
        data.setIsParameter(cdr.read_type_7());
        data.setMin(cdr.read_type_6());
        data.setMax(cdr.read_type_6());
        data.setLoadStatus(LoadStatus.values[cdr.read_type_c()]);
    }

    public final void serialize(YoVariableDefinition data, InterchangeSerializer ser) {
        ser.write_type_d("name", data.getName());
        ser.write_type_d("description", data.getDescription());
        ser.write_type_c("type", (Enum)data.getType());
        ser.write_type_3("registry", data.getRegistry());
        ser.write_type_3("enumType", data.getEnumType());
        ser.write_type_7("allowNullValues", data.getAllowNullValues());
        ser.write_type_7("isParameter", data.getIsParameter());
        ser.write_type_6("min", data.getMin());
        ser.write_type_6("max", data.getMax());
        ser.write_type_c("loadStatus", (Enum)data.getLoadStatus());
    }

    public final void deserialize(InterchangeSerializer ser, YoVariableDefinition data) {
        ser.read_type_d("name", data.getName());
        ser.read_type_d("description", data.getDescription());
        data.setType((YoType)ser.read_type_c("type", YoType.class));
        data.setRegistry(ser.read_type_3("registry"));
        data.setEnumType(ser.read_type_3("enumType"));
        data.setAllowNullValues(ser.read_type_7("allowNullValues"));
        data.setIsParameter(ser.read_type_7("isParameter"));
        data.setMin(ser.read_type_6("min"));
        data.setMax(ser.read_type_6("max"));
        data.setLoadStatus((LoadStatus)ser.read_type_c("loadStatus", LoadStatus.class));
    }

    public static void staticCopy(YoVariableDefinition src, YoVariableDefinition dest) {
        dest.set(src);
    }

    public YoVariableDefinition createData() {
        return new YoVariableDefinition();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)YoVariableDefinitionPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(YoVariableDefinition data, CDR cdr) {
        YoVariableDefinitionPubSubType.write(data, cdr);
    }

    public void deserialize(YoVariableDefinition data, CDR cdr) {
        YoVariableDefinitionPubSubType.read(data, cdr);
    }

    public void copy(YoVariableDefinition src, YoVariableDefinition dest) {
        YoVariableDefinitionPubSubType.staticCopy(src, dest);
    }

    public YoVariableDefinitionPubSubType newInstance() {
        return new YoVariableDefinitionPubSubType();
    }
}

