/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.Model;

public class ModelPubSubType
implements TopicDataType<Model> {
    public static final String name = "us::ihmc::robotDataLogger::Model";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "6d7fe7d3d8b07e957ab466dc84e2d5f653d3e2cceab5599496e96b3271adb0ea";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(Model data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        ModelPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Model data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        ModelPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return ModelPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 255; ++i0) {
            current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Model data) {
        return ModelPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Model data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getLoader().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getPath().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getResourceBundle().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getResourceDirectoriesList().size(); ++i0) {
            current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + ((StringBuilder)data.getResourceDirectoriesList().get(i0)).length() + 1;
        }
        return current_alignment - initial_alignment;
    }

    public static void write(Model data, CDR cdr) {
        if (data.getLoader().length() > 255) {
            throw new RuntimeException("loader field exceeds the maximum length: %d > %d".formatted(data.getLoader().length(), 255));
        }
        cdr.write_type_d(data.getLoader());
        if (data.getPath().length() > 255) {
            throw new RuntimeException("path field exceeds the maximum length: %d > %d".formatted(data.getPath().length(), 255));
        }
        cdr.write_type_d(data.getPath());
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length: %d > %d".formatted(data.getName().length(), 255));
        }
        cdr.write_type_d(data.getName());
        if (data.getResourceBundle().length() > 255) {
            throw new RuntimeException("resourceBundle field exceeds the maximum length: %d > %d".formatted(data.getResourceBundle().length(), 255));
        }
        cdr.write_type_d(data.getResourceBundle());
        if (data.getResourceDirectoriesList().size() > 255) {
            throw new RuntimeException("resourceDirectoriesList field exceeds the maximum length: %d > %d".formatted(data.getResourceDirectoriesList().size(), 255));
        }
        cdr.write_type_e((IDLSequence)data.getResourceDirectoriesList());
    }

    public static void read(Model data, CDR cdr) {
        cdr.read_type_d(data.getLoader());
        cdr.read_type_d(data.getPath());
        cdr.read_type_d(data.getName());
        cdr.read_type_d(data.getResourceBundle());
        cdr.read_type_e((IDLSequence)data.getResourceDirectoriesList());
    }

    public final void serialize(Model data, InterchangeSerializer ser) {
        ser.write_type_d("loader", data.getLoader());
        ser.write_type_d("path", data.getPath());
        ser.write_type_d("name", data.getName());
        ser.write_type_d("resourceBundle", data.getResourceBundle());
        ser.write_type_e("resourceDirectoriesList", (IDLSequence)data.getResourceDirectoriesList());
    }

    public final void deserialize(InterchangeSerializer ser, Model data) {
        ser.read_type_d("loader", data.getLoader());
        ser.read_type_d("path", data.getPath());
        ser.read_type_d("name", data.getName());
        ser.read_type_d("resourceBundle", data.getResourceBundle());
        ser.read_type_e("resourceDirectoriesList", (IDLSequence)data.getResourceDirectoriesList());
    }

    public static void staticCopy(Model src, Model dest) {
        dest.set(src);
    }

    public Model createData() {
        return new Model();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)ModelPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Model data, CDR cdr) {
        ModelPubSubType.write(data, cdr);
    }

    public void deserialize(Model data, CDR cdr) {
        ModelPubSubType.read(data, cdr);
    }

    public void copy(Model src, Model dest) {
        ModelPubSubType.staticCopy(src, dest);
    }

    public ModelPubSubType newInstance() {
        return new ModelPubSubType();
    }
}

