/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.Announcement;
import us.ihmc.robotDataLogger.ModelFileDescriptionPubSubType;

public class AnnouncementPubSubType
implements TopicDataType<Announcement> {
    public static final String name = "us::ihmc::robotDataLogger::Announcement";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "b5c3a94c5cae255913526c1c0741e43f65320aa046efc90f86f41ebb5311c3d9";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(Announcement data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        AnnouncementPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Announcement data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        AnnouncementPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return AnnouncementPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += ModelFileDescriptionPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Announcement data) {
        return AnnouncementPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Announcement data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getIdentifier().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getHostName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getReconnectKey().length() + 1;
        current_alignment += ModelFileDescriptionPubSubType.getCdrSerializedSize(data.getModelFileDescription(), current_alignment);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static void write(Announcement data, CDR cdr) {
        if (data.getIdentifier().length() > 255) {
            throw new RuntimeException("identifier field exceeds the maximum length: %d > %d".formatted(data.getIdentifier().length(), 255));
        }
        cdr.write_type_d(data.getIdentifier());
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length: %d > %d".formatted(data.getName().length(), 255));
        }
        cdr.write_type_d(data.getName());
        if (data.getHostName().length() > 255) {
            throw new RuntimeException("hostName field exceeds the maximum length: %d > %d".formatted(data.getHostName().length(), 255));
        }
        cdr.write_type_d(data.getHostName());
        if (data.getReconnectKey().length() > 255) {
            throw new RuntimeException("reconnectKey field exceeds the maximum length: %d > %d".formatted(data.getReconnectKey().length(), 255));
        }
        cdr.write_type_d(data.getReconnectKey());
        ModelFileDescriptionPubSubType.write(data.getModelFileDescription(), cdr);
        cdr.write_type_7(data.getLog());
    }

    public static void read(Announcement data, CDR cdr) {
        cdr.read_type_d(data.getIdentifier());
        cdr.read_type_d(data.getName());
        cdr.read_type_d(data.getHostName());
        cdr.read_type_d(data.getReconnectKey());
        ModelFileDescriptionPubSubType.read(data.getModelFileDescription(), cdr);
        data.setLog(cdr.read_type_7());
    }

    public final void serialize(Announcement data, InterchangeSerializer ser) {
        ser.write_type_d("identifier", data.getIdentifier());
        ser.write_type_d("name", data.getName());
        ser.write_type_d("hostName", data.getHostName());
        ser.write_type_d("reconnectKey", data.getReconnectKey());
        ser.write_type_a("modelFileDescription", (TopicDataType)new ModelFileDescriptionPubSubType(), (Object)data.getModelFileDescription());
        ser.write_type_7("log", data.getLog());
    }

    public final void deserialize(InterchangeSerializer ser, Announcement data) {
        ser.read_type_d("identifier", data.getIdentifier());
        ser.read_type_d("name", data.getName());
        ser.read_type_d("hostName", data.getHostName());
        ser.read_type_d("reconnectKey", data.getReconnectKey());
        ser.read_type_a("modelFileDescription", (TopicDataType)new ModelFileDescriptionPubSubType(), (Object)data.getModelFileDescription());
        data.setLog(ser.read_type_7("log"));
    }

    public static void staticCopy(Announcement src, Announcement dest) {
        dest.set(src);
    }

    public Announcement createData() {
        return new Announcement();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)AnnouncementPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Announcement data, CDR cdr) {
        AnnouncementPubSubType.write(data, cdr);
    }

    public void deserialize(Announcement data, CDR cdr) {
        AnnouncementPubSubType.read(data, cdr);
    }

    public void copy(Announcement src, Announcement dest) {
        AnnouncementPubSubType.staticCopy(src, dest);
    }

    public AnnouncementPubSubType newInstance() {
        return new AnnouncementPubSubType();
    }
}

