/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.FileWriter;
import java.io.IOException;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.RepeatingTaskThread;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.zed.SL_InitParameters;
import us.ihmc.zed.SL_RuntimeParameters;
import us.ihmc.zed.global.zed;

public class ZEDSVOLogger {
    private static final double CONNECT_TIMEOUT = 2.0;
    private static final boolean TRANSCODE = false;
    private static int nextCameraId = 10;
    private final int cameraID = nextCameraId++;
    private SL_InitParameters initParameters;
    private SL_RuntimeParameters runtimeParameters;
    private final RepeatingTaskThread grabThread = new RepeatingTaskThread(this.getClass().getName() + "GrabThread", this::grab);
    private final RepeatingTaskThread connectionWatchdogThread = new RepeatingTaskThread(this.getClass().getName() + "ConnectionWatchdog", this::connectionCheck);
    private String svoPrefix;
    private long controllerZeroInSensorFrame;
    private FileWriter timestampWriter;
    private volatile double lastGrabTime;
    private volatile boolean stopRequested;
    private volatile boolean completelyStopped;
    private volatile boolean failedBeyondRecovery;

    public void start(String svoFile, String datFile, String address, int port, int fps, int bitrate, long sensorTimestamp, long controllerTimestamp) {
        int returnCode;
        if (this.stopRequested) {
            throw new IllegalStateException("Cannot restart ZEDSVOLogger once stopped");
        }
        String[] parts = svoFile.split("[/\\\\]");
        this.svoPrefix = parts[parts.length - 1].substring(0, "yyyyMMdd_HHmmss".length());
        this.timestampWriter = (FileWriter)ExceptionTools.handle(() -> new FileWriter(datFile, true), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
        this.initParameters = new SL_InitParameters();
        this.initParameters.input_type(2);
        this.initParameters.async_grab_camera_recovery(true);
        this.runtimeParameters = new SL_RuntimeParameters();
        this.runtimeParameters.reference_frame(1);
        this.runtimeParameters.enable_depth(false);
        this.controllerZeroInSensorFrame = sensorTimestamp - controllerTimestamp;
        LogTools.info((String)("Connecting to ZED SDK stream on: " + address + ":" + port));
        if (zed.sl_is_opened((int)this.cameraID)) {
            zed.sl_close_camera((int)this.cameraID);
        }
        if ((returnCode = zed.sl_open_camera((int)this.cameraID, (SL_InitParameters)this.initParameters, (int)0, (String)"", (String)address, (int)port, (String)"", (String)"", (String)"")) != 0) {
            LogTools.error((String)("ZED SDK error code: " + returnCode));
        }
        if ((returnCode = zed.sl_enable_recording((int)this.cameraID, (String)svoFile, (int)1, (int)bitrate, (int)fps, (boolean)false)) != 0) {
            LogTools.error((String)("ZED SDK error code: " + returnCode));
        }
        if (zed.sl_is_opened((int)this.cameraID)) {
            LogTools.info((String)("Connected to ZED SDK stream on: " + address + ":" + port));
            this.grabThread.setFrequencyLimit(-1.0);
            this.grabThread.startRepeating();
        }
        this.connectionWatchdogThread.setFrequencyLimit(Conversions.secondsToHertz((double)2.0));
        ThreadTools.startAThread(() -> {
            ThreadTools.park((double)5.0);
            this.connectionWatchdogThread.startRepeating();
        }, (String)(this.getClass().getSimpleName() + "ConnectionWatchdogDelay"));
    }

    public void stop() {
        if (!this.stopRequested) {
            this.stopRequested = true;
            this.grabThread.blockingKill();
            this.connectionWatchdogThread.kill();
            zed.sl_close_camera((int)this.cameraID);
            zed.sl_unload_instance((int)this.cameraID);
            this.initParameters.close();
            this.runtimeParameters.close();
            System.out.println("Closing ZED SDK stream");
            ExceptionTools.handle(this.timestampWriter::close, (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE);
            this.completelyStopped = true;
        }
    }

    public void grab() {
        if (this.stopRequested) {
            throw new IllegalStateException("Cannot grab(), already stopped");
        }
        int returnCode = zed.sl_grab((int)this.cameraID, (SL_RuntimeParameters)this.runtimeParameters);
        this.lastGrabTime = (double)System.currentTimeMillis() / 1000.0;
        try {
            long sensorTimestamp = zed.sl_get_current_timestamp((int)this.cameraID);
            long controllerTimestamp = sensorTimestamp - this.controllerZeroInSensorFrame;
            this.timestampWriter.write("%d %d %s%n".formatted(controllerTimestamp, sensorTimestamp, this.svoPrefix));
        }
        catch (IOException e) {
            LogTools.error((String)e.getMessage());
        }
        if (returnCode == 1 || returnCode == 4) {
            this.failedBeyondRecovery = true;
        }
        if (returnCode == 19 || returnCode == -1) {
            this.stop();
        }
    }

    private void connectionCheck() {
        if (!this.stopRequested()) {
            if (!zed.sl_is_opened((int)this.cameraID)) {
                LogTools.info((String)"Unable to connect to ZED SDK stream");
                this.stop();
            }
            if ((double)System.currentTimeMillis() / 1000.0 - this.lastGrabTime > 2.0) {
                LogTools.info((String)"grab() timeout reached, disconnecting from ZED SDK stream");
                this.stop();
            }
        }
    }

    public boolean stopRequested() {
        return this.stopRequested;
    }

    public boolean completelyStopped() {
        return this.completelyStopped;
    }

    public boolean failedBeyondRecovery() {
        return this.failedBeyondRecovery;
    }
}

