/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.stream.Collectors;
import us.ihmc.idl.serializers.extra.JSONSerializer;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.Announcement;
import us.ihmc.robotDataLogger.AnnouncementPubSubType;
import us.ihmc.robotDataLogger.Handshake;
import us.ihmc.robotDataLogger.HandshakePubSubType;
import us.ihmc.robotDataLogger.logger.DataServerSettings;
import us.ihmc.robotDataLogger.util.HandshakeHashCalculator;

public class DataServerServerContent {
    private final String name;
    private final String hostName;
    private final Announcement announcement;
    private final ByteBuf announcementBuffer;
    private final Handshake handshake;
    private final ByteBuf handshakeBuffer;
    private final ByteBuf index;
    private final ByteBuf model;
    private final ByteBuf resourceZip;

    public DataServerServerContent(String name, Handshake handshake, LogModelProvider logModelProvider, DataServerSettings dataServerSettings) {
        try {
            this.name = name;
            this.announcement = this.createAnnouncement(name, dataServerSettings.isLogSession(), handshake);
            this.hostName = this.announcement.getHostNameAsString();
            this.announcement.setIdentifier(UUID.randomUUID().toString());
            if (logModelProvider != null) {
                byte[] model = logModelProvider.getModel();
                this.announcement.getModelFileDescription().setHasModel(true);
                this.announcement.getModelFileDescription().setName(logModelProvider.getModelName());
                this.announcement.getModelFileDescription().setModelLoaderClass(logModelProvider.getLoader().getCanonicalName());
                this.announcement.getModelFileDescription().setModelFileSize(model.length);
                for (String resourceDirectory : logModelProvider.getTopLevelResourceDirectories()) {
                    this.announcement.getModelFileDescription().getResourceDirectories().add(resourceDirectory);
                }
                this.model = Unpooled.wrappedBuffer((byte[])model);
                byte[] resourceZip = logModelProvider.getResourceZip();
                if (resourceZip != null && resourceZip.length > 0) {
                    this.resourceZip = Unpooled.wrappedBuffer((byte[])resourceZip);
                    this.announcement.getModelFileDescription().setHasResourceZip(true);
                    this.announcement.getModelFileDescription().setResourceZipSize(resourceZip.length);
                } else {
                    this.announcement.getModelFileDescription().setHasResourceZip(false);
                    this.resourceZip = null;
                }
            } else {
                this.announcement.getModelFileDescription().setHasModel(false);
                this.model = null;
                this.resourceZip = null;
            }
            AnnouncementPubSubType announcementPubSubType = new AnnouncementPubSubType();
            JSONSerializer announcementSerializer = new JSONSerializer((TopicDataType)announcementPubSubType);
            byte[] announcementData = announcementSerializer.serializeToBytes((Object)this.announcement);
            this.announcementBuffer = Unpooled.directBuffer((int)announcementData.length);
            this.announcementBuffer.writeBytes(announcementData);
            HandshakePubSubType handshakeType = new HandshakePubSubType();
            JSONSerializer handshakeSerializer = new JSONSerializer((TopicDataType)handshakeType);
            byte[] handshakeData = handshakeSerializer.serializeToBytes((Object)handshake);
            this.handshake = handshake;
            this.handshakeBuffer = Unpooled.directBuffer((int)handshakeData.length);
            this.handshakeBuffer.writeBytes(handshakeData);
            this.index = this.createIndex();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Announcement createAnnouncement(String name, boolean log, Handshake handshake) throws UnknownHostException {
        Announcement announcement = new Announcement();
        announcement.setName(name);
        announcement.setHostName(InetAddress.getLocalHost().getHostName());
        announcement.setIdentifier("");
        announcement.setLog(log);
        String handshakeHash = HandshakeHashCalculator.calculateHash(handshake);
        announcement.setReconnectKey(handshakeHash);
        return announcement;
    }

    public ByteBuf getAnnouncement() {
        return this.announcementBuffer.retainedDuplicate();
    }

    public Announcement getAnnouncementObject() {
        return this.announcement;
    }

    public String getAnnouncementContentType() {
        return "application/json; charset=UTF-8";
    }

    public Handshake getHandshakeObject() {
        return this.handshake;
    }

    public ByteBuf getHandshake() {
        return this.handshakeBuffer.retainedDuplicate();
    }

    public String getHandshakeContentType() {
        return "application/json; charset=UTF-8";
    }

    public ByteBuf getIndex() {
        return this.index.retainedDuplicate();
    }

    public String getIndexContentType() {
        return "text/html; charset=UTF-8";
    }

    public boolean hasModel() {
        return this.model != null;
    }

    public ByteBuf getModel() {
        return this.model.retainedDuplicate();
    }

    public String getModelContentType() {
        return "text/xml; charset=UTF-8";
    }

    public boolean hasResourceZip() {
        return this.resourceZip != null;
    }

    public ByteBuf getResourceZip() {
        return this.resourceZip.retainedDuplicate();
    }

    public String getResourceZipContentType() {
        return "application/zip";
    }

    private ByteBuf createIndex() {
        InputStream is = this.getClass().getResourceAsStream("index.html");
        if (is != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String index = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            index = index.replace("{NAME}", this.name);
            index = index.replace("{HOSTNAME}", this.hostName);
            return Unpooled.copiedBuffer((CharSequence)index, (Charset)CharsetUtil.UTF_8);
        }
        throw new RuntimeException("Cannot load index.html");
    }
}

