/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.memoryLogger;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBuffer;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBufferBuilder;
import us.ihmc.robotDataLogger.interfaces.BufferListenerInterface;
import us.ihmc.robotDataLogger.memoryLogger.MemoryBufferEntry;
import us.ihmc.robotDataLogger.memoryLogger.MemoryLogWriter;
import us.ihmc.robotDataLogger.websocket.server.DataServerServerContent;

public class CircularMemoryLogger
implements BufferListenerInterface {
    private DataServerServerContent dataserverContent = null;
    private int previousBufferID = -1;
    private int numberOfRegistries;
    private final MemoryBufferEntry[] circularBuffer;
    private final File logDirectory;
    private volatile boolean isRecording;
    private final AtomicLong timestampAndIndex = new AtomicLong();

    public CircularMemoryLogger(File logDirectory, int numberOfEntries) {
        if (numberOfEntries > 0xFFFFFF) {
            throw new RuntimeException("Memory logger supports a maximum of 16777215 entries, using 24bit index");
        }
        if (numberOfEntries <= 0) {
            throw new RuntimeException("Memory logger needs at least 1 entry");
        }
        this.logDirectory = logDirectory;
        this.circularBuffer = new MemoryBufferEntry[numberOfEntries];
    }

    @Override
    public void setContent(DataServerServerContent content) {
        this.dataserverContent = content;
    }

    @Override
    public void allocateBuffers(int numberOfRegistries) {
        this.numberOfRegistries = numberOfRegistries;
        if (this.circularBuffer.length <= numberOfRegistries + 1) {
            throw new RuntimeException("Memory logger needs at " + (numberOfRegistries + 2) + " entries");
        }
        for (int i = 0; i < this.circularBuffer.length; ++i) {
            this.circularBuffer[i] = new MemoryBufferEntry(numberOfRegistries);
        }
    }

    @Override
    public void addBuffer(int bufferID, RegistrySendBufferBuilder builder) {
        if (this.previousBufferID + 1 != bufferID) {
            throw new RuntimeException("Non sequential buffer IDs");
        }
        this.previousBufferID = bufferID;
        for (int i = 0; i < this.circularBuffer.length; ++i) {
            this.circularBuffer[i].initializeRegistry(bufferID, builder.getNumberOfVariables(), builder.getNumberOfJointStates());
        }
    }

    @Override
    public void start() {
        this.isRecording = true;
    }

    private int getIndexForTimestamp(int currentIndex, long timestamp) {
        int index = currentIndex;
        for (int i = 1; i < this.circularBuffer.length / 10; ++i) {
            long ts;
            int nextIndex = currentIndex - i;
            if (nextIndex < 0) {
                nextIndex = this.circularBuffer.length + nextIndex;
            }
            if ((ts = this.circularBuffer[nextIndex].getTimestamp()) < timestamp) {
                return index;
            }
            if (ts == timestamp) {
                return nextIndex;
            }
            index = nextIndex;
        }
        return -1;
    }

    @Override
    public void updateBuffer(int bufferID, RegistrySendBuffer buffer) {
        int bufferIndex = -1;
        long adjustedTimestamp = -1L;
        for (int i = 0; i < 1000; ++i) {
            if (!this.isRecording) {
                return;
            }
            long currentValue = this.timestampAndIndex.get();
            int currentIndex = (int)(currentValue & 0xFFFFFFL);
            long currentTimestamp = currentValue >> 24;
            long bufferTimestamp = buffer.getTimestamp() & 0xFFFFFFFFFFL;
            if (currentTimestamp == bufferTimestamp) {
                bufferIndex = currentIndex;
                adjustedTimestamp = buffer.getTimestamp();
                break;
            }
            if (currentTimestamp > bufferTimestamp) {
                bufferIndex = this.getIndexForTimestamp(currentIndex, buffer.getTimestamp());
                if (bufferIndex >= 0) {
                    adjustedTimestamp = this.circularBuffer[bufferIndex].getTimestamp();
                    break;
                }
                return;
            }
            int nextIndex = (currentIndex + 1) % this.circularBuffer.length;
            long nextValue = bufferTimestamp << 24 | (long)nextIndex;
            if (!this.timestampAndIndex.compareAndSet(currentValue, nextValue)) continue;
            bufferIndex = nextIndex;
            adjustedTimestamp = buffer.getTimestamp();
            break;
        }
        if (bufferIndex < 0) {
            LogTools.info((String)"Timeout");
            return;
        }
        MemoryBufferEntry nextBuffer = this.circularBuffer[bufferIndex];
        nextBuffer.timestamps[bufferID] = adjustedTimestamp;
        ByteBuffer variableData = buffer.getBuffer();
        variableData.position(0);
        ByteBuffer nextVariableData = nextBuffer.variables[bufferID];
        nextVariableData.clear();
        nextVariableData.put(variableData);
        int jointStates = buffer.getJointStates().length;
        if (jointStates > 0) {
            System.arraycopy(buffer.getJointStates(), 0, nextBuffer.jointStates[bufferID], 0, jointStates);
        }
    }

    @Override
    public void close() {
        this.isRecording = false;
        long currentValue = this.timestampAndIndex.get();
        int currentIndex = (int)(currentValue & 0xFFFFFFL);
        int skipPackets = this.numberOfRegistries + 1;
        MemoryBufferEntry previousBufferEntry = new MemoryBufferEntry(this.numberOfRegistries);
        MemoryLogWriter writer = new MemoryLogWriter(this.dataserverContent, this.logDirectory);
        for (int i = currentIndex + skipPackets; i < currentIndex + this.circularBuffer.length; ++i) {
            int writeIndex = i % this.circularBuffer.length;
            if (writeIndex == currentIndex) {
                throw new RuntimeException();
            }
            MemoryBufferEntry entry = this.circularBuffer[writeIndex];
            long entryTimestamp = entry.getTimestamp();
            if (entryTimestamp == 0L) continue;
            for (int r = 0; r < this.numberOfRegistries; ++r) {
                long bufferTime = entry.timestamps[r];
                if (bufferTime != entryTimestamp) {
                    if (previousBufferEntry.variables[r] != null) {
                        entry.variables[r] = previousBufferEntry.variables[r];
                    }
                    if (previousBufferEntry.jointStates[r] == null) continue;
                    entry.jointStates[r] = previousBufferEntry.jointStates[r];
                    continue;
                }
                previousBufferEntry.variables[r] = entry.variables[r];
                previousBufferEntry.jointStates[r] = entry.jointStates[r];
            }
            writer.addBuffer(entry);
        }
        writer.finish();
    }
}

