/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.locks.LockSupport;
import us.ihmc.robotDataLogger.util.PaddedVolatileBoolean;
import us.ihmc.robotDataLogger.util.PaddedVolatileLong;
import us.ihmc.robotDataLogger.util.PaddedVolatileReference;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;
import us.ihmc.robotDataLogger.websocket.server.WebsocketDataServerFrameHandler;

class WebsocketDataBroadcaster
implements ChannelFutureListener {
    public static final int TIMESTAMP_PUBLISHING_SLEEP_NS = 500000;
    private final Object channelLock = new Object();
    private final TimestampPublishingThread timestampPublishingThread = new TimestampPublishingThread();
    private final PaddedVolatileReference<WebsocketDataServerFrameHandler[]> channels = new PaddedVolatileReference<WebsocketDataServerFrameHandler[]>(new WebsocketDataServerFrameHandler[0]);
    private final PaddedVolatileBoolean active = new PaddedVolatileBoolean(true);
    private final PaddedVolatileLong newTimestamp = new PaddedVolatileLong(Long.MIN_VALUE);

    public WebsocketDataBroadcaster() {
        this.timestampPublishingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(WebsocketDataServerFrameHandler websocketLogFrameHandler) {
        Object object = this.channelLock;
        synchronized (object) {
            WebsocketDataServerFrameHandler[] newChannels = Arrays.copyOf(this.channels.get(), this.channels.get().length + 1);
            newChannels[newChannels.length - 1] = websocketLogFrameHandler;
            this.channels.set(newChannels);
            websocketLogFrameHandler.addCloseFutureListener(this);
        }
    }

    public void write(int bufferID, long timestamp, ByteBuffer frame) throws IOException {
        WebsocketDataServerFrameHandler[] localChannels = this.channels.get();
        for (int i = 0; i < localChannels.length; ++i) {
            localChannels[i].write(bufferID, timestamp, frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationComplete(ChannelFuture future) throws Exception {
        Object object = this.channelLock;
        synchronized (object) {
            Channel channel = future.channel();
            WebsocketDataServerFrameHandler[] oldChannels = this.channels.get();
            WebsocketDataServerFrameHandler[] newChannels = new WebsocketDataServerFrameHandler[oldChannels.length - 1];
            int newI = 0;
            for (int i = 0; i < oldChannels.length; ++i) {
                if (oldChannels[i].channel() == channel) {
                    oldChannels[i].release();
                    continue;
                }
                if (newI >= newChannels.length) {
                    return;
                }
                newChannels[newI] = oldChannels[i];
                ++newI;
            }
            this.channels.set(newChannels);
        }
    }

    public void writeCommand(DataServerCommand command, int argument) {
        WebsocketDataServerFrameHandler[] localChannels = this.channels.get();
        for (int i = 0; i < localChannels.length; ++i) {
            localChannels[i].writeCommand(command, argument);
        }
    }

    public void publishTimestamp(long timestamp) {
        this.newTimestamp.set(timestamp);
    }

    public void stop() {
        this.active.set(false);
    }

    private class TimestampPublishingThread
    extends Thread {
        private TimestampPublishingThread() {
            super(TimestampPublishingThread.class.getSimpleName());
        }

        @Override
        public void run() {
            long lastSendTimestamp = Long.MIN_VALUE;
            while (WebsocketDataBroadcaster.this.active.getBoolean()) {
                long newTimestampLocal = WebsocketDataBroadcaster.this.newTimestamp.getLong();
                if (lastSendTimestamp != newTimestampLocal) {
                    WebsocketDataServerFrameHandler[] localChannels = WebsocketDataBroadcaster.this.channels.get();
                    for (int i = 0; i < localChannels.length; ++i) {
                        localChannels[i].publishTimestamp(newTimestampLocal);
                    }
                    lastSendTimestamp = newTimestampLocal;
                }
                LockSupport.parkNanos(500000L);
            }
        }
    }
}

