/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import us.ihmc.idl.serializers.extra.CustomDeserializationHandler;
import us.ihmc.idl.serializers.extra.PropertiesSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.LogPropertiesPubSubType;

public class LogPropertiesReader
extends LogProperties {
    public LogPropertiesReader(File file) {
        PropertiesSerializer serializer = new PropertiesSerializer((TopicDataType)new LogPropertiesPubSubType());
        serializer.setCustomDeserializationHandler((CustomDeserializationHandler)new LegacyFileHandler());
        try {
            this.set((LogProperties)((Object)serializer.deserialize(file)));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load properties " + file.getAbsolutePath());
        }
    }

    private static class LegacyFileHandler
    implements CustomDeserializationHandler<LogProperties> {
        private LegacyFileHandler() {
        }

        public void handle(JsonNode node, LogProperties data) {
            JsonNode videoStreams;
            JsonNode resourceDirectories = node.with("model").get("resourceDirectories");
            if (resourceDirectories != null) {
                System.out.println("Handling legacy resource directories");
                for (String directory : resourceDirectories.asText().split(",")) {
                    System.out.println("Adding directory " + directory);
                    data.getModel().getResourceDirectoriesList().add(directory);
                }
            }
            if ((videoStreams = node.get("videoStreams")) != null) {
                String[] videos;
                for (String video : videos = videoStreams.asText().split(",")) {
                    System.out.println("Trying " + video + "...");
                    JsonNode cameraNode = node.get(video);
                    if (cameraNode == null) continue;
                    Camera camera = (Camera)((Object)data.getCameras().add());
                    camera.setType(cameraNode.get("type").asText());
                    camera.setName(video);
                    camera.setTimestampFile(cameraNode.path("timestamps").asText());
                    camera.setVideoFile(cameraNode.path("video").asText());
                    camera.setInterlaced(cameraNode.path("interlaced").asBoolean());
                    System.out.println("Added " + camera);
                }
            }
        }
    }
}

