/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.memoryLogger;

import java.nio.ByteBuffer;

class MemoryBufferEntry {
    final ByteBuffer[] variables;
    final double[][] jointStates;
    final long[] timestamps;

    public MemoryBufferEntry(int numberOfBuffers) {
        this.variables = new ByteBuffer[numberOfBuffers];
        this.jointStates = new double[numberOfBuffers][];
        this.timestamps = new long[numberOfBuffers];
    }

    public void initializeRegistry(int registryID, int numberOfVariables, int numberOfJointStates) {
        this.variables[registryID] = ByteBuffer.allocateDirect(numberOfVariables * 8);
        this.jointStates[registryID] = (double[])(numberOfJointStates > 0 ? new double[numberOfJointStates] : null);
    }

    public long getTimestamp() {
        long maxTimestamp = 0L;
        for (int i = 0; i < this.timestamps.length; ++i) {
            if (this.timestamps[i] <= maxTimestamp) continue;
            maxTimestamp = this.timestamps[i];
        }
        return maxTimestamp;
    }
}

