/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.guiRecorder;

import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindPolicyType;
import java.io.IOException;
import java.nio.ByteBuffer;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantProfile;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.pubsub.types.ByteBufferPubSubType;
import us.ihmc.robotDataLogger.guiRecorder.GUICaptureHandler;

public class GUICaptureReceiver
implements SubscriberListener {
    private final String topicName;
    private final Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
    private final Participant participant;
    private final GUICaptureHandler handler;
    private final ByteBuffer receiveBuffer = ByteBuffer.allocateDirect(0x100000);

    public GUICaptureReceiver(int domainID, String topicName, GUICaptureHandler handler) throws IOException {
        this.topicName = topicName;
        this.handler = handler;
        ParticipantProfile participantAttributes = this.domain.createParticipantAttributes(domainID, this.getClass().getSimpleName());
        this.participant = this.domain.createParticipant(participantAttributes);
    }

    public void start() throws IllegalArgumentException, IOException {
        ByteBufferPubSubType pubSubType = new ByteBufferPubSubType("us::ihmc::robotDataLogger::gui::screenshot", 0x100000);
        SubscriberAttributes attributes = this.domain.createSubscriberAttributes(this.participant, (TopicDataType)pubSubType, this.topicName, ReliabilityQosKindPolicyType.BEST_EFFORT, new String[]{"/us/ihmc/robotDataLogger/GuiStreamer"});
        this.domain.createSubscriber(this.participant, attributes, (SubscriberListener)this);
    }

    public void close() {
        this.domain.removeParticipant(this.participant);
    }

    public void onNewDataMessage(Subscriber subscriber) {
        this.receiveBuffer.clear();
        if (subscriber.takeNextData((Object)this.receiveBuffer, null)) {
            this.receiveBuffer.flip();
            this.handler.receivedFrame(this.receiveBuffer);
        }
    }

    public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
    }
}

