/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.publisher.logger.ui;

import java.io.IOException;
import javafx.stage.Stage;
import us.ihmc.publisher.logger.LoggerDeployConfiguration;
import us.ihmc.publisher.logger.utils.SSHDeploy;
import us.ihmc.publisher.logger.utils.ui.FXConsole;
import us.ihmc.robotDataLogger.CameraSettings;
import us.ihmc.robotDataLogger.StaticHostList;

public interface LoggerDeployScript {
    default public void deploy(String logger_host, String logger_user, String logger_password, String logger_sudo_password, String logger_dist, boolean nightly_restart, Stage stage, boolean logger_service, boolean allow_many_instances) {
        FXConsole deployConsole = new FXConsole(stage);
        SSHDeploy.SSHRemote remote = new SSHDeploy.SSHRemote(logger_host, logger_user, logger_password, logger_sudo_password);
        LoggerDeployConfiguration.deploy(remote, logger_dist, nightly_restart, deployConsole, logger_service, allow_many_instances);
    }

    default public boolean implementsAutoRestart() {
        return true;
    }

    default public void saveConfiguration(String logger_host, String logger_user, String logger_password, String logger_sudo_password, CameraSettings settings, StaticHostList staticHostList, boolean restartonSave, Stage stage) {
        FXConsole deployConsole = new FXConsole(stage);
        SSHDeploy.SSHRemote remote = new SSHDeploy.SSHRemote(logger_host, logger_user, logger_password, logger_sudo_password);
        LoggerDeployConfiguration.saveConfiguration(remote, settings, staticHostList, restartonSave, deployConsole);
    }

    default public CameraSettings loadCameraConfiguration(String logger_host, String logger_user, String logger_password, String logger_sudo_password, Stage stage) throws IOException {
        SSHDeploy.SSHRemote remote = new SSHDeploy.SSHRemote(logger_host, logger_user, logger_password, logger_sudo_password);
        return LoggerDeployConfiguration.loadCameraConfiguration(remote);
    }

    default public StaticHostList loadStaticHostList(String logger_host, String logger_user, String logger_password, String logger_sudo_password, Stage stage) throws IOException {
        SSHDeploy.SSHRemote remote = new SSHDeploy.SSHRemote(logger_host, logger_user, logger_password, logger_sudo_password);
        return LoggerDeployConfiguration.loadStaticHostList(remote);
    }
}

