/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.MathTools;
import us.ihmc.idl.serializers.extra.YAMLSerializer;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.Announcement;
import us.ihmc.robotDataLogger.CameraConfiguration;
import us.ihmc.robotDataLogger.CameraSettings;
import us.ihmc.robotDataLogger.CameraSettingsLoader;
import us.ihmc.robotDataLogger.HandshakeFileType;
import us.ihmc.robotDataLogger.HandshakePubSubType;
import us.ihmc.robotDataLogger.YoVariableClientInterface;
import us.ihmc.robotDataLogger.YoVariablesUpdatedListener;
import us.ihmc.robotDataLogger.handshake.LogHandshake;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.jointState.JointState;
import us.ihmc.robotDataLogger.logger.BlackmagicVideoDataLogger;
import us.ihmc.robotDataLogger.logger.LogPropertiesWriter;
import us.ihmc.robotDataLogger.logger.NetworkStreamVideoDataLogger;
import us.ihmc.robotDataLogger.logger.VideoDataLoggerInterface;
import us.ihmc.robotDataLogger.logger.YoVariableLoggerOptions;
import us.ihmc.robotDataLogger.logger.YoVariableSummarizer;
import us.ihmc.robotDataLogger.util.DebugRegistry;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerDescription;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;
import us.ihmc.tools.compression.SnappyUtils;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableLoggerListener
implements YoVariablesUpdatedListener {
    private static final int FLUSH_EVERY_N_PACKETS = 250;
    public static final long STATUS_PACKET_RATE = Conversions.secondsToNanoseconds((double)5.0);
    private static final long VIDEO_RECORDING_TIMEOUT = Conversions.secondsToNanoseconds((double)1.0);
    public static final String propertyFile = "robotData.log";
    private static final String handshakeFilename = "handshake.yaml";
    private static final String dataFilename = "robotData.bsz";
    private static final String modelFilename = "model.sdf";
    private static final String modelResourceBundle = "resources.zip";
    private static final String indexFilename = "robotData.dat";
    private static final String summaryFilename = "summary.csv";
    private final Object synchronizer = new Object();
    private final Object timestampUpdater = new Object();
    private final boolean flushAggressivelyToDisk;
    private final File tempDirectory;
    private final File finalDirectory;
    private final YoVariableLoggerOptions options;
    private FileChannel dataChannel;
    private FileChannel indexChannel;
    private final ByteBuffer indexBuffer = ByteBuffer.allocate(16);
    private ByteBuffer compressedBuffer;
    private volatile boolean connected = false;
    private final LogPropertiesWriter logProperties;
    private ArrayList<VideoDataLoggerInterface> videoDataLoggers = new ArrayList();
    private final ArrayList<CameraConfiguration> cameras = new ArrayList();
    private boolean clearingLog = false;
    private long currentIndex = 0L;
    private long lastReceivedTimestamp = Long.MIN_VALUE;
    private final Announcement request;
    private final Consumer<Announcement> doneListener;
    private YoVariableSummarizer yoVariableSummarizer = null;
    private List<YoVariable> variables;
    private List<JointState> jointStates;
    private ByteBuffer dataBuffer;
    private LongBuffer dataBufferAsLong;
    private YoVariableClientInterface yoVariableClientInterface = null;
    private long lastStatusUpdateTimestamp = 0L;
    private long logStartedTimestamp = 0L;
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public YoVariableLoggerListener(File tempDirectory, File finalDirectory, String timestamp, Announcement request, HTTPDataServerDescription target, YoVariableLoggerOptions options, Consumer<Announcement> doneListener) {
        LogTools.info((String)YoVariableLoggerListener.toString(request));
        this.flushAggressivelyToDisk = options.isFlushAggressivelyToDisk();
        this.tempDirectory = tempDirectory;
        this.finalDirectory = finalDirectory;
        this.options = options;
        this.request = request;
        this.doneListener = doneListener;
        this.logProperties = new LogPropertiesWriter(new File(tempDirectory, propertyFile));
        this.logProperties.getVariables().setHandshake(handshakeFilename);
        this.logProperties.getVariables().setData(dataFilename);
        this.logProperties.getVariables().setCompressed(true);
        this.logProperties.getVariables().setTimestamped(true);
        this.logProperties.getVariables().setIndex(indexFilename);
        this.logProperties.getVariables().setHandshakeFileType(HandshakeFileType.IDL_YAML);
        this.logProperties.setName(request.getNameAsString());
        this.logProperties.setTimestamp(timestamp);
        if (!options.getDisableVideo() && target.getCameraList() != null) {
            CameraSettings cameras = CameraSettingsLoader.load();
            for (int i = 0; i < target.getCameraList().size(); ++i) {
                byte camera_id = target.getCameraList().get(i);
                for (CameraConfiguration camera : cameras.getCameras()) {
                    if (camera.getCameraId() != camera_id) continue;
                    LogTools.info((String)("Adding camera " + camera.toString()));
                    this.cameras.add(camera);
                }
            }
        } else {
            LogTools.warn((String)"Video capture disabled. Ignoring camera's and network streams");
        }
    }

    @Override
    public boolean changesVariables() {
        return false;
    }

    private void logHandshake(LogHandshake handshake, YoVariableHandshakeParser handshakeParser) {
        File handshakeFile = new File(this.tempDirectory, handshakeFilename);
        try {
            YAMLSerializer serializer = new YAMLSerializer((TopicDataType)new HandshakePubSubType());
            serializer.serialize(handshakeFile, (Object)handshake.getHandshake());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (handshake.getModelLoaderClass() != null) {
            this.logProperties.getModel().setLoader(handshake.getModelLoaderClass());
            this.logProperties.getModel().setName(handshake.getModelName());
            for (String resourceDirectory : handshake.getResourceDirectories()) {
                this.logProperties.getModel().getResourceDirectoriesList().add(resourceDirectory);
            }
            this.logProperties.getModel().setPath(modelFilename);
            this.logProperties.getModel().setResourceBundle(modelResourceBundle);
            File modelFile = new File(this.tempDirectory, modelFilename);
            File resourceFile = new File(this.tempDirectory, modelResourceBundle);
            try {
                FileOutputStream modelStream = new FileOutputStream(modelFile, false);
                modelStream.write(handshake.getModel());
                modelStream.getFD().sync();
                modelStream.close();
                FileOutputStream resourceStream = new FileOutputStream(resourceFile, false);
                resourceStream.write(handshake.getResourceZip());
                resourceStream.getFD().sync();
                resourceStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (handshake.getHandshake().getSummary().getCreateSummary()) {
            this.yoVariableSummarizer = new YoVariableSummarizer(handshakeParser.getYoVariablesList(), handshake.getHandshake().getSummary().getSummaryTriggerVariableAsString(), handshake.getHandshake().getSummary().getSummarizedVariables().toStringArray());
            this.logProperties.getVariables().setSummary(summaryFilename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedTimestampAndData(long timestamp) {
        this.receivedTimestampOnly(timestamp);
        ByteBuffer buffer = this.reconstructBuffer(timestamp);
        this.connected = true;
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.clearingLog && this.dataChannel != null && this.dataChannel.isOpen()) {
                try {
                    if (this.yoVariableSummarizer != null) {
                        this.yoVariableSummarizer.setBuffer(buffer);
                    }
                    buffer.clear();
                    this.compressedBuffer.clear();
                    SnappyUtils.compress(buffer, this.compressedBuffer);
                    this.compressedBuffer.flip();
                    this.indexBuffer.clear();
                    this.indexBuffer.putLong(timestamp);
                    this.indexBuffer.putLong(this.dataChannel.position());
                    this.indexBuffer.flip();
                    this.indexChannel.write(this.indexBuffer);
                    this.dataChannel.write(this.compressedBuffer);
                    if (this.flushAggressivelyToDisk && ++this.currentIndex % 250L == 0L) {
                        this.indexChannel.force(false);
                        this.dataChannel.force(false);
                    }
                    if (this.yoVariableSummarizer != null) {
                        this.yoVariableSummarizer.update();
                    }
                    this.updateStatus();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus() {
        Object object = this.synchronizer;
        synchronized (object) {
            long now;
            if (this.yoVariableClientInterface != null && (now = System.nanoTime()) > this.lastStatusUpdateTimestamp + STATUS_PACKET_RATE) {
                boolean recordingVideo = false;
                for (int i = 0; i < this.videoDataLoggers.size(); ++i) {
                    if (this.videoDataLoggers.get(i).getLastFrameReceivedTimestamp() + VIDEO_RECORDING_TIMEOUT <= now) continue;
                    recordingVideo = true;
                }
                int time = (int)MathTools.clamp((double)Conversions.nanosecondsToSeconds((long)(now - this.logStartedTimestamp)), (double)0.0, (double)DataServerCommand.getMaximumArgumentValue());
                if (recordingVideo) {
                    this.yoVariableClientInterface.sendCommand(DataServerCommand.LOG_ACTIVE_WITH_CAMERA, time);
                } else {
                    this.yoVariableClientInterface.sendCommand(DataServerCommand.LOG_ACTIVE, time);
                }
                this.lastStatusUpdateTimestamp = now;
            }
        }
    }

    private ByteBuffer reconstructBuffer(long timestamp) {
        int i;
        this.dataBuffer.clear();
        this.dataBufferAsLong.clear();
        this.dataBufferAsLong.put(timestamp);
        for (i = 0; i < this.variables.size(); ++i) {
            this.dataBufferAsLong.put(this.variables.get(i).getValueAsLongBits());
        }
        for (i = 0; i < this.jointStates.size(); ++i) {
            this.jointStates.get(i).get(this.dataBufferAsLong);
        }
        this.dataBufferAsLong.flip();
        this.dataBuffer.clear();
        return this.dataBuffer;
    }

    @Override
    public void disconnected() {
        LogTools.info((String)("Logger disconnected from " + this.request.getHostNameAsString()));
        try {
            this.dataChannel.close();
            this.indexChannel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (VideoDataLoggerInterface videoDataLogger : this.videoDataLoggers) {
            this.closeVideo(videoDataLogger);
        }
        if (!this.connected) {
            File indexFile;
            File model;
            File properties;
            LogTools.error((String)"Never started logging, cleaning up");
            for (VideoDataLoggerInterface videoDataLogger : this.videoDataLoggers) {
                videoDataLogger.removeLogFiles();
            }
            File handshakeFile = new File(this.tempDirectory, handshakeFilename);
            if (handshakeFile.exists()) {
                LogTools.info((String)"Deleting handshake file");
                handshakeFile.delete();
            }
            if ((properties = new File(this.tempDirectory, propertyFile)).exists()) {
                LogTools.info((String)"Deleting properties file");
                properties.delete();
            }
            if ((model = new File(this.tempDirectory, modelFilename)).exists()) {
                LogTools.info((String)"Deleting model file");
                model.delete();
            }
            File resources = new File(this.tempDirectory, modelResourceBundle);
            LogTools.info((String)"Deleting resource bundle");
            resources.delete();
            File dataFile = new File(this.tempDirectory, dataFilename);
            if (dataFile.exists()) {
                LogTools.info((String)"Deleting data file");
                dataFile.delete();
            }
            if ((indexFile = new File(this.tempDirectory, indexFilename)).exists()) {
                LogTools.info((String)"Deleting index file");
                indexFile.delete();
            }
            if (this.tempDirectory.exists()) {
                LogTools.info((String)"Deleting log directory");
                this.tempDirectory.delete();
            }
        } else {
            if (this.yoVariableSummarizer != null) {
                this.yoVariableSummarizer.writeData(new File(this.tempDirectory, summaryFilename));
            }
            this.tempDirectory.renameTo(this.finalDirectory);
            this.doneListener.accept(this.request);
        }
    }

    private void closeVideo(VideoDataLoggerInterface videoDataLogger) {
        Future<?> future = this.executor.submit(() -> videoDataLogger.close());
        try {
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            LogTools.info((String)"Closing video stream timed out after 5s.");
        }
    }

    @Override
    public boolean updateYoVariables() {
        return false;
    }

    @Override
    public void setShowOverheadView(boolean showOverheadView) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(YoVariableClientInterface yoVariableClientInterface, LogHandshake handshake, YoVariableHandshakeParser handshakeParser, DebugRegistry debugRegistry) {
        this.logHandshake(handshake, handshakeParser);
        int bufferSize = handshakeParser.getBufferSize();
        this.compressedBuffer = ByteBuffer.allocate(SnappyUtils.maxCompressedLength(bufferSize));
        this.dataBuffer = ByteBuffer.allocate(bufferSize);
        this.dataBufferAsLong = this.dataBuffer.asLongBuffer();
        this.variables = handshakeParser.getYoVariablesList();
        this.jointStates = handshakeParser.getJointStates();
        File dataFile = new File(this.tempDirectory, dataFilename);
        File indexFile = new File(this.tempDirectory, indexFilename);
        Object object = this.synchronizer;
        synchronized (object) {
            try {
                this.dataChannel = new FileOutputStream(dataFile, false).getChannel();
                this.indexChannel = new FileOutputStream(indexFile, false).getChannel();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (!this.options.getDisableVideo()) {
                for (CameraConfiguration camera : this.cameras) {
                    try {
                        switch (camera.getType()) {
                            case CAPTURE_CARD: {
                                this.videoDataLoggers.add(new BlackmagicVideoDataLogger(camera.getNameAsString(), this.tempDirectory, this.logProperties, Byte.parseByte(camera.getIdentifierAsString()), this.options));
                                break;
                            }
                            case NETWORK_STREAM: {
                                this.videoDataLoggers.add(new NetworkStreamVideoDataLogger(this.tempDirectory, this.logProperties, 7, camera.getIdentifierAsString()));
                            }
                        }
                    }
                    catch (IOException e) {
                        LogTools.error((String)"Cannot start video data logger");
                        e.printStackTrace();
                    }
                }
            }
            try {
                this.logProperties.store();
                this.dataChannel.force(true);
                this.indexChannel.force(true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.yoVariableClientInterface = yoVariableClientInterface;
            this.logStartedTimestamp = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedTimestampOnly(long timestamp) {
        Object object = this.timestampUpdater;
        synchronized (object) {
            if (timestamp > this.lastReceivedTimestamp) {
                for (int i = 0; i < this.videoDataLoggers.size(); ++i) {
                    this.videoDataLoggers.get(i).timestampChanged(timestamp);
                }
                this.lastReceivedTimestamp = timestamp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLog() {
        Iterator<VideoDataLoggerInterface> iterator = this.synchronizer;
        synchronized (iterator) {
            this.clearingLog = true;
        }
        try {
            LogTools.info((String)"Clearing log.");
            this.dataChannel.truncate(0L);
            this.indexChannel.truncate(0L);
            for (VideoDataLoggerInterface videoDataLogger : this.videoDataLoggers) {
                videoDataLogger.restart();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.yoVariableSummarizer != null) {
            this.yoVariableSummarizer.restart();
        }
        iterator = this.synchronizer;
        synchronized (iterator) {
            this.clearingLog = false;
            this.logStartedTimestamp = System.nanoTime();
        }
    }

    @Override
    public void connected() {
    }

    @Override
    public void receivedCommand(DataServerCommand command, int argument) {
        if (command == DataServerCommand.CLEAR_LOG) {
            this.clearLog();
        } else if (command == DataServerCommand.RESTART_LOG && this.yoVariableClientInterface.isConnected()) {
            LogTools.info((String)("Restarting Log: " + this.request.getNameAsString()));
            this.yoVariableClientInterface.stop();
        }
    }

    private static String toString(Announcement announcement) {
        StringBuilder builder = new StringBuilder();
        builder.append("Announcement {");
        builder.append("\n  identifier = ");
        builder.append((CharSequence)announcement.identifier_);
        builder.append("\n  name = ");
        builder.append((CharSequence)announcement.name_);
        builder.append("\n  hostName = ");
        builder.append((CharSequence)announcement.hostName_);
        builder.append("\n  log = ");
        builder.append(announcement.log_);
        builder.append("\n}");
        return builder.toString();
    }
}

