/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerConnection;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerDescription;

public class DataServerSelectorJFrame
extends JFrame {
    private static final int DEFAULT_PORT = 8008;
    private static final long serialVersionUID = 7413581697585956415L;
    private final Object tableRowLock = new Object();
    private final DefaultTableModel model;
    private final HashMap<HTTPDataServerDescription, SelectorRow> tableRows = new HashMap();
    private final CompletableFuture<HTTPDataServerConnection> selectConnection = new CompletableFuture();

    public DataServerSelectorJFrame(HostAddedListener hostAddedListener) {
        super("Control sessions");
        this.setMinimumSize(new Dimension(1024, 320));
        this.setLocationRelativeTo(null);
        this.setLocationByPlatform(true);
        JPanel hostPanel = new JPanel(new BorderLayout());
        JScrollPane scroller = new JScrollPane();
        Object[] columnNames = new String[]{"Host", "Port", "Hostname", "Controller"};
        this.model = new DefaultTableModel(columnNames, 0){
            private static final long serialVersionUID = 7807098301637938830L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        JTable table = new JTable(this.model);
        table.setFillsViewportHeight(true);
        table.setAutoResizeMode(4);
        scroller.getViewport().add(table);
        table.addMouseListener(new DoubleClickListener());
        this.getContentPane().setLayout(new BorderLayout());
        hostPanel.add((Component)table.getTableHeader(), "First");
        hostPanel.add((Component)scroller, "Center");
        this.getContentPane().add((Component)hostPanel, "Center");
        JPanel addHostPanel = new JPanel();
        addHostPanel.setLayout(new BoxLayout(addHostPanel, 0));
        addHostPanel.add(new JLabel("New host: "));
        JTextField hostField = new JTextField();
        hostField.setEnabled(true);
        addHostPanel.add(hostField);
        addHostPanel.add(new JLabel(":"));
        JTextField port = new JTextField(String.valueOf(8008), 6);
        port.setMaximumSize(new Dimension(Short.MAX_VALUE, (int)port.getPreferredSize().getWidth()));
        addHostPanel.add(port);
        addHostPanel.add(Box.createHorizontalStrut(5));
        JButton add = new JButton("+");
        addHostPanel.add(add);
        this.getContentPane().add((Component)addHostPanel, "Last");
        add.addActionListener(e -> {
            hostAddedListener.hostAdded(hostField.getText(), port.getText());
            hostField.setText("");
            port.setText(String.valueOf(8008));
        });
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                if (!DataServerSelectorJFrame.this.selectConnection.isDone()) {
                    DataServerSelectorJFrame.this.selectConnection.cancel(false);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHost(HTTPDataServerDescription description) {
        Object object = this.tableRowLock;
        synchronized (object) {
            if (this.tableRows.containsKey(description)) {
                SelectorRow row = this.tableRows.remove(description);
                this.tableRows.put(description, row);
            } else {
                SelectorRow newRow = new SelectorRow(description);
                this.tableRows.put(description, newRow);
                SwingUtilities.invokeLater(() -> {
                    Object object = this.tableRowLock;
                    synchronized (object) {
                        this.model.addRow(newRow);
                        this.model.fireTableDataChanged();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHost(HTTPDataServerConnection connection) {
        Object object = this.tableRowLock;
        synchronized (object) {
            if (connection.getTarget().isPersistant() || connection.isConnected()) {
                if (!this.tableRows.containsKey(connection.getTarget())) {
                    this.addHost(connection.getTarget());
                }
                this.tableRows.get(connection.getTarget()).update(connection);
                SwingUtilities.invokeLater(() -> this.model.fireTableDataChanged());
            } else {
                SwingUtilities.invokeLater(() -> {
                    Object object = this.tableRowLock;
                    synchronized (object) {
                        SelectorRow row = this.tableRows.remove(connection.getTarget());
                        if (row != null) {
                            for (int i = 0; i < this.model.getRowCount(); ++i) {
                                if (this.model.getDataVector().get(i) != row) continue;
                                this.model.removeRow(i);
                                return;
                            }
                        }
                    }
                });
            }
        }
    }

    public HTTPDataServerConnection select() {
        try {
            this.setVisible(true);
            HTTPDataServerConnection connection = this.selectConnection.get();
            this.setVisible(false);
            return connection;
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            return null;
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SelectorRow selectorRow;
            JTable target;
            int row;
            if (e.getClickCount() == 2 && (row = (target = (JTable)e.getSource()).getSelectedRow()) >= 0 && (selectorRow = (SelectorRow)DataServerSelectorJFrame.this.model.getDataVector().get(row)).getActiveConnection() != null) {
                DataServerSelectorJFrame.this.selectConnection.complete(selectorRow.getActiveConnection());
            }
        }
    }

    private class SelectorRow
    extends Vector<Object> {
        private static final long serialVersionUID = 6875046233769595894L;
        private static final String OFFLINE_HOSTNAME_DESCRIPTION = "[Offline]";
        private static final String OFFLINE_CONTROLLER_DESCRIPTION = "";
        private HTTPDataServerConnection activeConnection;

        public SelectorRow(HTTPDataServerDescription description) {
            this.add(description.getHost());
            this.add(description.getPort());
            this.add(OFFLINE_HOSTNAME_DESCRIPTION);
            this.add(OFFLINE_CONTROLLER_DESCRIPTION);
        }

        public synchronized void update(HTTPDataServerConnection connection) {
            if (connection.isConnected()) {
                this.set(2, connection.getAnnouncement().getHostNameAsString());
                this.set(3, connection.getAnnouncement().getNameAsString());
                this.activeConnection = connection;
            } else {
                this.set(2, OFFLINE_HOSTNAME_DESCRIPTION);
                this.set(3, OFFLINE_CONTROLLER_DESCRIPTION);
                this.activeConnection = null;
            }
        }

        public synchronized HTTPDataServerConnection getActiveConnection() {
            return this.activeConnection;
        }
    }

    public static interface HostAddedListener {
        public void hostAdded(String var1, String var2);
    }
}

