/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.publisher.logger.ui;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Date;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import us.ihmc.publisher.logger.LoggerDeployConfiguration;
import us.ihmc.publisher.logger.ui.LoggerDeployController;
import us.ihmc.publisher.logger.utils.SSHDeploy;
import us.ihmc.publisher.logger.utils.TeeStream;
import us.ihmc.publisher.logger.utils.ui.FXConsole;

public class LoggerDeployApplication
extends Application {
    private static final URL uiDescription = LoggerDeployApplication.class.getResource("LoggerSetup.fxml");

    public static void open(String loggerDistribution, LoggerDeployController.LoggerDeployScript deployScript, Scene scene) {
        try {
            FXMLLoader loader = new FXMLLoader(uiDescription);
            Parent root = (Parent)loader.load();
            LoggerDeployController controller = (LoggerDeployController)loader.getController();
            controller.setLoggerDistribution(loggerDistribution);
            controller.setDeployScript(deployScript);
            Stage stage = new Stage();
            stage.setTitle("Logger deployment");
            stage.initOwner(scene.getWindow());
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setScene(new Scene(root, 1280.0, 900.0));
            stage.show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void start(Stage stage) throws IOException {
        this.redirectOutput();
        FXMLLoader loader = new FXMLLoader(uiDescription);
        Parent root = (Parent)loader.load();
        LoggerDeployController controller = (LoggerDeployController)loader.getController();
        controller.setLoggerDistribution((String)this.getParameters().getNamed().get("logger-dist"));
        controller.setDeployScript((host, user, pw, sudo_pw, dist, nightly_restart, popup_stage) -> {
            FXConsole deployConsole = new FXConsole(popup_stage);
            SSHDeploy.SSHRemote remote = new SSHDeploy.SSHRemote(host, user, pw, sudo_pw);
            LoggerDeployConfiguration.deploy(remote, dist, nightly_restart, deployConsole);
        });
        Scene scene = new Scene(root, 1280.0, 900.0);
        stage.setTitle("Logger deployment");
        stage.setScene(scene);
        stage.show();
    }

    private void redirectOutput() throws FileNotFoundException {
        PrintStream log = new PrintStream(new FileOutputStream("logger-deploy.log", true));
        TeeStream stdOutStream = new TeeStream(System.out, log);
        TeeStream stdErrStream = new TeeStream(System.err, log);
        System.setOut(stdOutStream);
        System.setErr(stdErrStream);
        System.out.println("--- " + new Date().toString() + " ---");
    }

    public static void main(String[] args) {
        LoggerDeployApplication.launch((String[])args);
    }
}

