/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.publisher.logger.ui;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import us.ihmc.publisher.logger.LoggerDeployConfiguration;
import us.ihmc.publisher.logger.ui.CameraBean;
import us.ihmc.publisher.logger.ui.HostBean;
import us.ihmc.publisher.logger.utils.SSHDeploy;
import us.ihmc.publisher.logger.utils.ui.FXConsole;
import us.ihmc.publisher.logger.utils.ui.PreferencesHolder;
import us.ihmc.robotDataLogger.CameraConfiguration;
import us.ihmc.robotDataLogger.CameraSettings;
import us.ihmc.robotDataLogger.CameraType;
import us.ihmc.robotDataLogger.Host;
import us.ihmc.robotDataLogger.StaticHostList;

public class LoggerDeployController
implements Initializable {
    private LoggerDeployScript loggerDeployScript;
    PreferencesHolder prefs;
    @FXML
    TextField logger_host;
    @FXML
    TextField logger_user;
    @FXML
    PasswordField logger_pasword;
    @FXML
    PasswordField logger_sudo_password;
    ObservableList<CameraBean> cameraList = FXCollections.observableArrayList();
    @FXML
    TableView<CameraBean> camera_table;
    @FXML
    TableColumn<CameraBean, String> camera_name_col;
    @FXML
    TableColumn<CameraBean, Integer> camera_id_col;
    @FXML
    TableColumn<CameraBean, Integer> camera_input_col;
    ObservableList<HostBean> hostList = FXCollections.observableArrayList();
    @FXML
    TableView<HostBean> host_table;
    @FXML
    TableColumn<HostBean, String> host_col;
    @FXML
    TableColumn<HostBean, Integer> port_col;
    @FXML
    TableColumn<HostBean, HostBean.CameraHolder> host_cameras_col;
    @FXML
    TextField logger_dist;
    @FXML
    Button browse_dist;
    @FXML
    CheckBox logger_restart_midnight;
    @FXML
    Label restart_label;
    @FXML
    CheckBox restart_on_save;

    public void initialize(URL location, ResourceBundle resources) {
        this.prefs = new PreferencesHolder(Preferences.userRoot().node(this.getClass().getSimpleName()));
        this.prefs.linkToPrefs((TextInputControl)this.logger_host, "127.0.0.1");
        this.prefs.linkToPrefs((TextInputControl)this.logger_user, "halodi");
        this.prefs.linkToPrefs((TextInputControl)this.logger_pasword, "halodi");
        this.prefs.linkToPrefs((TextInputControl)this.logger_sudo_password, "halodi");
        this.prefs.linkToPrefs((TextInputControl)this.logger_dist, "");
        this.prefs.linkToPrefs(this.logger_restart_midnight, false);
        this.prefs.linkToPrefs(this.restart_on_save, true);
        this.camera_table.setEditable(true);
        this.camera_id_col.setCellValueFactory((Callback)new PropertyValueFactory("camera_id"));
        this.camera_name_col.setCellFactory(TextFieldTableCell.forTableColumn());
        this.camera_name_col.setCellValueFactory((Callback)new PropertyValueFactory("camera_name"));
        this.camera_name_col.setOnEditCommit(e -> ((CameraBean)e.getRowValue()).camera_name.set((String)e.getNewValue()));
        this.camera_input_col.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new IntegerStringConverter()));
        this.camera_input_col.setCellValueFactory((Callback)new PropertyValueFactory("camera_input"));
        this.camera_input_col.setOnEditCommit(e -> ((CameraBean)e.getRowValue()).camera_input.set(((Integer)e.getNewValue()).intValue()));
        this.camera_table.setItems(this.cameraList);
        this.camera_table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.host_table.setEditable(true);
        this.host_col.setCellFactory(TextFieldTableCell.forTableColumn());
        this.host_col.setCellValueFactory((Callback)new PropertyValueFactory("hostname"));
        this.host_col.setOnEditCommit(e -> ((HostBean)e.getRowValue()).hostname.set((String)e.getNewValue()));
        this.port_col.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new IntegerStringConverter()));
        this.port_col.setCellValueFactory((Callback)new PropertyValueFactory("port"));
        this.port_col.setOnEditCommit(e -> ((HostBean)e.getRowValue()).port.set(((Integer)e.getNewValue()).intValue()));
        this.host_cameras_col.setCellValueFactory((Callback)new PropertyValueFactory("cameras"));
        this.host_table.setItems(this.hostList);
    }

    public void setDeployScript(LoggerDeployScript loggerDeployScript) {
        this.loggerDeployScript = loggerDeployScript;
        if (!loggerDeployScript.implementsAutoRestart()) {
            this.restart_label.setVisible(false);
            this.logger_restart_midnight.setVisible(false);
        }
    }

    private byte getNextFreeCameraId() {
        for (int i = 0; i < 128; i = (byte)(i + 1)) {
            boolean isFree = true;
            for (CameraBean camera : this.cameraList) {
                if (camera.getCamera_id() != i) continue;
                isFree = false;
            }
            if (!isFree) continue;
            return (byte)i;
        }
        return -1;
    }

    @FXML
    void camera_add(ActionEvent e) {
        byte nextId = this.getNextFreeCameraId();
        if (nextId < 0) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Too many cameras");
            alert.setHeaderText("No more than 128 cameras are supported");
            alert.showAndWait();
        } else {
            this.cameraList.add((Object)new CameraBean(nextId));
        }
    }

    @FXML
    void camera_remove(ActionEvent e) {
        ArrayList toRemove = new ArrayList(this.camera_table.getSelectionModel().getSelectedItems());
        for (CameraBean camera : toRemove) {
            this.cameraList.remove((Object)camera);
        }
    }

    @FXML
    void host_add(ActionEvent e) {
        this.hostList.add((Object)new HostBean());
    }

    @FXML
    void host_remove(ActionEvent e) {
        this.hostList.remove(this.host_table.getSelectionModel().getSelectedItem());
    }

    @FXML
    void set_cameras(ActionEvent e) {
        ObservableList cameras = this.camera_table.getSelectionModel().getSelectedItems();
        ((HostBean)this.host_table.getSelectionModel().getSelectedItem()).setCameras(new HostBean.CameraHolder((List<CameraBean>)cameras));
        this.host_table.refresh();
    }

    @FXML
    void load(ActionEvent e) {
        Alert alert;
        StaticHostList hosts;
        CameraSettings settings;
        SSHDeploy.SSHRemote remote = new SSHDeploy.SSHRemote(this.logger_host.getText(), this.logger_user.getText(), this.logger_pasword.getText(), this.logger_sudo_password.getText());
        try {
            settings = LoggerDeployConfiguration.loadCameraConfiguration(remote);
        }
        catch (IOException ex) {
            Alert alert2 = new Alert(Alert.AlertType.ERROR);
            alert2.setTitle("Cannot load camera configuration.");
            alert2.setHeaderText("Cannot load camera configuration from host. Initializing to empty configuration");
            alert2.setContentText(ex.getMessage());
            alert2.showAndWait();
            settings = new CameraSettings();
        }
        try {
            hosts = LoggerDeployConfiguration.loadStaticHostList(remote);
        }
        catch (IOException ex) {
            alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Cannot load host configuration.");
            alert.setHeaderText("Cannot load host configuration from host. Initializing to empty host list");
            alert.setContentText(ex.getMessage());
            alert.showAndWait();
            hosts = new StaticHostList();
        }
        try {
            Object bean;
            this.cameraList.clear();
            this.hostList.clear();
            if (settings != null && settings.getCameras() != null) {
                for (CameraConfiguration config : settings.getCameras()) {
                    if (config.getType() != CameraType.CAPTURE_CARD) continue;
                    bean = new CameraBean(config);
                    this.cameraList.add(bean);
                }
            }
            if (hosts != null && hosts.getHosts() != null) {
                for (Host host : hosts.getHosts()) {
                    bean = new HostBean(host);
                    this.hostList.add(bean);
                }
            }
            this.camera_table.refresh();
            this.host_table.refresh();
        }
        catch (NumberFormatException ex) {
            alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Configuration is corrupted.");
            alert.setHeaderText(ex.getMessage());
            alert.showAndWait();
        }
    }

    @FXML
    void save(ActionEvent e) {
        FXConsole deployConsole = new FXConsole((Stage)this.logger_host.getScene().getWindow());
        SSHDeploy.SSHRemote remote = new SSHDeploy.SSHRemote(this.logger_host.getText(), this.logger_user.getText(), this.logger_pasword.getText(), this.logger_sudo_password.getText());
        CameraSettings settings = new CameraSettings();
        for (CameraBean cameraBean : this.cameraList) {
            CameraConfiguration config = (CameraConfiguration)((Object)settings.getCameras().add());
            cameraBean.pack(config);
        }
        StaticHostList staticHosts = new StaticHostList();
        for (HostBean hostBean : this.hostList) {
            Host host = (Host)((Object)staticHosts.getHosts().add());
            hostBean.pack(host);
        }
        LoggerDeployConfiguration.saveConfiguration(remote, settings, staticHosts, this.restart_on_save.isSelected(), deployConsole);
    }

    @FXML
    void logger_deploy(ActionEvent e) {
        if (this.loggerDeployScript == null) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("No deployment script set for the logger");
            alert.setHeaderText("Application bug: Logger deployment script not set. Contact the developer.");
            alert.showAndWait();
        } else {
            this.loggerDeployScript.deploy(this.logger_host.getText(), this.logger_user.getText(), this.logger_pasword.getText(), this.logger_sudo_password.getText(), this.logger_dist.getText(), this.logger_restart_midnight.isSelected(), (Stage)this.logger_host.getScene().getWindow());
        }
    }

    private void createFileSelection(String name, String argument, TextField textField, Button browseButton, String filter) {
        if (argument == null) {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter urdfFilter = new FileChooser.ExtensionFilter(name, new String[]{filter});
            fileChooser.getExtensionFilters().add((Object)urdfFilter);
            File browsePath = new File(this.prefs.get(textField.getId() + "_browse", System.getProperty("user.home")));
            fileChooser.setInitialDirectory(browsePath);
            browseButton.setOnAction(e -> {
                File selectedFile = fileChooser.showOpenDialog(browseButton.getScene().getWindow());
                if (selectedFile != null) {
                    textField.setText(selectedFile.getAbsolutePath());
                    this.prefs.put(textField.getId(), selectedFile.getAbsolutePath());
                }
            });
            this.prefs.linkToPrefs((TextInputControl)textField, "");
        } else {
            textField.setText(argument);
            textField.setDisable(true);
            browseButton.setVisible(false);
        }
    }

    public void setLoggerDistribution(String loggerDistribution) {
        Platform.runLater(() -> this.createFileSelection("Logger distribution", loggerDistribution, this.logger_dist, this.browse_dist, "*.tar"));
    }

    public static interface LoggerDeployScript {
        public void deploy(String var1, String var2, String var3, String var4, String var5, boolean var6, Stage var7);

        default public boolean implementsAutoRestart() {
            return true;
        }
    }
}

