/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import us.ihmc.util.PeriodicThreadScheduler;

public class PeriodicGCFreeNonRealtimeThreadScheduler
implements PeriodicThreadScheduler {
    private final String name;
    private volatile boolean running = false;
    private FixedRateThread thread;
    private Runnable runnable;

    public PeriodicGCFreeNonRealtimeThreadScheduler(String name) {
        this.name = name;
    }

    public synchronized void schedule(Runnable runnable, long period, TimeUnit timeunit) {
        if (this.running) {
            throw new RuntimeException("Thread has already been scheduled");
        }
        this.runnable = runnable;
        this.running = true;
        this.thread = new FixedRateThread(timeunit.toNanos(period));
        this.thread.start();
    }

    public synchronized void shutdown() {
        this.running = false;
    }

    public void awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.thread.join(TimeUnit.MILLISECONDS.convert(timeout, timeUnit));
    }

    private class FixedRateThread
    extends Thread {
        private final long dtInNanos;

        public FixedRateThread(long dtInNanos) {
            super(PeriodicGCFreeNonRealtimeThreadScheduler.this.name + "-thread");
            this.dtInNanos = dtInNanos;
        }

        @Override
        public void run() {
            long nextWakeTime = System.nanoTime() + this.dtInNanos;
            while (PeriodicGCFreeNonRealtimeThreadScheduler.this.running) {
                PeriodicGCFreeNonRealtimeThreadScheduler.this.runnable.run();
                long currentTime = System.nanoTime();
                if (currentTime < (nextWakeTime += this.dtInNanos)) {
                    LockSupport.parkNanos(nextWakeTime - currentTime);
                    continue;
                }
                nextWakeTime = currentTime;
            }
        }
    }
}

